/* C_FILE2.C -                                                        */
/* by Michael Smith - October, 1989                                   */
/*                                                                    */
/* Supplementary File manipulation function to be used with the       */
/* function contained in CLIPPER.LIB to allow C programs to open      */
/* files.                                                             */
/*                                                                    */
/* For Use with Clipper Only!!!                                       */
/*                                                                    */
/* __TLEN() - Return the Length of a File Opened using _topen()       */
/* __TEOF() - Return 1 if EOF has been reached.                       */
/*                                                                    */
/* Requires C_FILES1.ASM be compiled and linked                       */

#include <clipper.h>

long __tell(int) ;       /* .ASM to return the Current Position */
long __tgeof(int) ;      /* .ASM to go to the End of the File   */

long __tlen(int file)
{
     long curpos, length ;
     curpos = __tell(file) ;          /* Save the Current Position */
     length = __tgeof(file) ;         /* Store the End of File Pos */
     _tlseek(file,curpos,0) ;         /* Reset the Pointer         */
     return (length) ;
}

int __teof(int file)
{
     if (__tell(file) >= __tlen(file)) return (1) ; else return (0) ;
}
