; GETCPU.ASM
;
; For Clipper '87.  GETCPU()
; Returns a Character String with '80386', '80286', or '808x'
;
; Written By Michael Smith, November 07, 1989.

EXTRN    __RETC:FAR

DGROUP   GROUP     DATASEG
DATASEG  SEGMENT   '_DATA' ; _DATA IS THE REQUIRED CLASS

CPU386   DB        '80386'
         DB        0
CPU286   DB        '80286'
         DB        0
CPU86    DB        '808x'
         DB        0

DATASEG            ENDS

_TEXT    SEGMENT BYTE    'CODE'         ; CODE IS THE REQUIRED CLASS
         ASSUME  CS:_TEXT,DS:DGROUP     ;  CODE FOR SUMMER 87

         PUBLIC   GetCPU

GetCPU   PROC      FAR

         PUSH      BP
         MOV       BP,SP

         PUSHF
         XOR       AX,AX
         PUSH      AX
         POPF
         PUSHF
         POP       AX
         AND       AX,0f000h
         CMP       AX,0f000h
         JZ        is_808x

         MOV       AX,07000h   ; If we can't set bits 12-14 then
         PUSH      AX          ; CPU is 80286
         POPF
         PUSHF
         POP       AX
         AND       AX,07000h
         JZ        is_80286

is_80386 :
         LEA       SI,CPU386        ; Load SI with offset address.
         JMP       DONE

is_80286 :
         LEA       SI,CPU286        ; Load SI with offset address.
         JMP       DONE

is_808x :
         LEA       SI,CPU86        ; Load SI with offset address.

DONE:
         PUSH      DS            ; Push Segment
         PUSH      SI            ; Push Offset
         CALL      __RETC        ; Call Clippers Return String Routine.
         ADD       SP,4          ; Reset Stack.

         POPF
         POP       BP
         RETF

GetCPU   ENDP

_TEXT    ENDS
END
