*:*********************************************************************
*:
*:        Program: Modi.PRG
*:                 Modify/create structures of dbf files
*:                 notes:If a field name is changed, that field's data
*:                       is not recovered when appended to the new
*:                       structure.
*:                       This prg will not allow field types to be changed
*:                       while retaining the same name, as Clipper will bomb
*:                       out trying to append.
*:
*:         System: DBF FILE MODIFICATION SYSTEM
*:         Author: GARRY PREFONTAINE
*:                 920 N WASHINGTON
*:                 EDMOND,OK,73034
*:                 H - (405)340-1449
*:                 W - (405)840-8700
*:      Copyright
*:  Last modified: 10/23/88     18:04
*:     Documented: 10/23/88 at 18:11                SNAP! version 3.11
*:
*:     I got kinda tired of pirating DBU for DBF Structure maintenance
*:     and creation, so I wrote this utility.
*:    
*:     Use it, abuse it, and send any groovy enhancements c/o
*:     the FILE BANK BBS - 619-728-4318.  Lots of Clipper stuff there,
*:     and its where I've taken to dumping my attempts at writing code.
*:    
*:     Note : I make no claims, nor take any responsibility, for the suitability 
*:            of this software for any use whatsoever.
*:    
*:     (sorry - no docs this time around)
*:*********************************************************************
SAVE SCREEN TO MODSCREEN
SET BELL OFF
SET SAFETY OFF
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF
SET CONFIRM OFF
SET Wrap ON
SET KEY -1 TO PICKLST
DO WHILE .T.
   SET COLOR TO +G/N,N/G
   CLEAR
   makewind('MENU',9,19,13,46,"+G/N")
   @10,20 PROMPT "CREATE NEW DATABASE"
   @11,20 PROMPT "MODIFY DATABASE"
   @12,20 PROMPT "QUIT        "
   MENU TO whatdo
   killwind('MENU',9,19,13,46,"+G/N")
   DO CASE
   CASE whatdo = 1
      newdbf = .T.
      dotitle = "Create Structure"
      modbase = SPACE(12)
      @16,20 SAY "DATABASE: " GET modbase PICTURE "@!"
      READ
      modbase = Alltrim(modbase)
      modbase =IIF(.NOT. ".DBF" $ modbase, modbase+".DBF",modbase)
      IF FILE(modbase)
         err_mess("DATABASE ALREADY EXISTS")
         LOOP
      ENDIF
      asize = 0
      DECLARE dbfarr[1],dbfold[1]
      dbfarr[1] = SPACE(21)
      dbfold[1] = SPACE(21)
      CLEAR TYPEAHEAD
      myn = modis()
      IF myn = .T.
         IF .NOT. FILE("TEMP_X.DBF")
            CREATE temp_x.dbf
         ENDIF
         USE temp_x
         FOR I = 1 TO asize
            APPEND Blank
            REPLACE field_name WITH  SUBSTR(dbfarr[I],1,10)
            REPLACE field_type WITH SUBSTR(dbfarr[I],12,1)
            REPLACE field_len WITH VAL(SUBSTR(dbfarr[I],15,3))
            REPLACE field_dec WITH VAL(SUBSTR(dbfarr[I],20,2))
         NEXT
         USE
         RELEASE dbfarr
         CREATE &modbase FROM temp_x
         ERASE temp_x.dbf
      ENDIF
   CASE whatdo = 2
      dotitle = "Modify Structure"
      modbase = SPACE(12)
      @17,20 SAY "(F2 FOR PICKLIST)"
      @16,20 SAY "DATABASE: " GET modbase PICTURE "@!"
      READ
      modbase = Alltrim(modbase)
      IF .NOT. ".DBF" $ modbase
         modbase = modbase+".DBF"
      ENDIF
      IF .NOT. FILE(modbase)
         @23,0 SAY "NO SUCH FILE   - PRESS A KEY"
         INKEY(0)
         LOOP
      ENDIF
      USE &modbase
      asize = fcount()
      IF asize = 0
         @23,0 SAY "UNABLE TO OPEN DATABASE    "
         INKEY(0)
         LOOP
      ENDIF
      DECLARE dbfarr[ASIZE]
      DECLARE dbfold[ASIZE]
      DECLARE t1[ASIZE]
      DECLARE t2[ASIZE]
      DECLARE t2old[ASIZE]
      DECLARE t3[ASIZE]
      DECLARE t4[ASIZE]
      afields(t1,t2,t3,t4)
      memois = .T.
      FOR I = 1 TO asize
         t1[I] = t1[I]+SPACE(10-LEN( t1[I]) )
         dbfarr[I]= TRANSFORM(t1[I],"!!!!!!!!!!")+' '+t2[I]+'  '+TRANSFORM(t3[I],"999")+'  '+TRANSFORM(t4[I],"99")
      NEXT
      acopy(dbfarr,dbfold)
      acopy(t2,t2old)
      RELEASE t1,t2,t3,t4
      USE
      CLEAR TYPEAHEAD
      myn = modis()
      IF myn = .T.
         IF .NOT. FILE("TEMP_X.DBF")
            CREATE temp_x.dbf
         ENDIF
         USE temp_x
         FOR I = 1 TO asize
            APPEND Blank
            REPLACE field_name WITH  SUBSTR(dbfarr[I],1,10)
            REPLACE field_type WITH SUBSTR(dbfarr[I],12,1)
            REPLACE field_len WITH VAL(SUBSTR(dbfarr[I],15,3))
            REPLACE field_dec WITH VAL(SUBSTR(dbfarr[I],20,2))
         NEXT
         RELEASE dbfarr
         IF FILE("TEMP2_X.DBF")
            ERASE temp2_x.dbf
         ENDIF
         RENAME &modbase TO temp2_x.dbf
         USE
         CREATE &modbase FROM temp_x
         USE &modbase
         APPEND FROM temp2_x.dbf
         ERASE temp2_x.dbf
         ERASE temp_x.dbf
         USE
      ENDIF
   CASE whatdo = 3
      CLEAR
      RESTORE SCREEN FROM MODSCREEN
      QUIT
   ENDCASE
ENDDO
*!*********************************************************************
*!
*!       Function: MODIS()
*!
*!*********************************************************************
FUNCTION modis
CLEAR
makewind('makedbf',3,10,23,35)
@3,11 SAY dotitle
@4,11 SAY "NAME      Type Len Dec "
@20,11 SAY "   <INSERT> TO ADD"
@21,11 SAY "   <ENTER> TO MODIFY"
@22,11 SAY "   <ESCAPE> WHEN DONE"
@5,10 SAY ""
@5,35 SAY ""
@19,10 SAY ""
@19,35 SAY ""
@5,11 TO 5,34
@19,11 TO 19,34
redo = .T.
startel = 1
achange = .F.
IF asize > 0
   @19,14 SAY TRANSFORM(1,"999")+' of '+TRANSFORM(asize,"999")+' fields'
ENDIF
DO WHILE redo
   @6,11 CLEAR TO 18,34
   SELECT = achoice(6,11,18,34,dbfarr,'','AC_UDF',startel)
   IF .NOT. redo
      EXIT
   ENDIF
ENDDO
IF asize < 1 .OR. (.NOT. achange)
   RETURN .F.
ENDIF
IF EMPTY( dbfarr[1])
   RETURN .F.
ENDIF
makewind('saveit',12,12,14,60,"+gr/B,+gr/n")
sav = "Y"
@13,13 SAY "Save this structure to disk ? Y/N " GET sav VALID sav $ "YN"
READ
RETURN IIF(sav="Y",.T.,.F.)
killwind('saveit',12,12,14,60)
killwind('makedbf',3,10,23,35)
*!*********************************************************************
*!
*!       Function: AC_UDF()
*!
*!*********************************************************************
FUNCTION AC_UDF
PARAMETERS modep,currel,relpos
lkey = LASTKEY()
DO CASE
CASE lkey = 7     && delete
   achange = .T.
   eledel()
   redo = .T.
   startel = currel-relpos
   sendpos = ''
   FOR I = 1 TO relpos
      sendpos = sendpos+CHR(24)
   NEXT
   KEYBOARD sendpos+CHR(4)
   RETURN 0
CASE lkey = 13 .AND. asize > 0
   edmod = "E"
   oldvalue = dbfarr[currel]
   newvalue =editel(oldvalue)
   dbfarr[currel]=IIF(EMPTY(newvalue),oldvalue,newvalue)
   IF !EMPTY(newvalue)
      achange = .T.
      redo = .T.
      sendpos = ''
      FOR I = 1 TO relpos
         sendpos = sendpos+CHR(24)
      NEXT
      KEYBOARD sendpos
      startel = currel-relpos
      RETURN 0
   ENDIF
   RETURN 2
CASE lkey = 22    && INSERT
   insval = SPACE(21)
   edmod = 'A'
   addval = editel(insval)
   IF !EMPTY(addval)
      achange = .T.
      asize = asize + 1
      DECLARE temp[asize]
      acopy(dbfarr,temp)
      PUBLIC dbfarr[asize]
      acopy(temp,dbfarr)
      sendpos = ''
      if asize > 1
       ains(dbfarr,currel+1)
       dbfarr[currel+1]= addval
       FOR I = 1 TO relpos+1
          sendpos = sendpos+CHR(24)
       NEXT
      else
       ains(dbfarr,1)
       dbfarr[1]= addval
      endif
      redo = .T.
      KEYBOARD sendpos+CHR(4)
      startel = currel-relpos
      RETURN 0
   ELSE
      RETURN 2
   ENDIF
CASE lkey = 27    && escape
   redo = .F.
   RETURN 0
OTHERWISE
   @19,14 SAY TRANSFORM(currel,"999")+' of '+TRANSFORM(asize,"999")+' fields'
   RETURN 2
ENDCASE
RETURN 2
*!*********************************************************************
*!
*!       Function: ELEDEL()
*!
*!*********************************************************************
FUNCTION eledel
IF asize = 0
   RETURN ''
ENDIF
adel(dbfarr,currel)
asize = asize - 1
IF asize > 0
   DECLARE temp[asize]
   acopy(dbfarr,temp)
   PUBLIC dbfarr[asize]
   acopy(temp,dbfarr)
ELSE
   dbfarr[1] = SPACE(21)
ENDIF
RETURN ''
*!*********************************************************************
*!
*!       Function: EDITEL()
*!
*!*********************************************************************
FUNCTION editel
SET Cursor ON
PARAMETERS toedit
makewind('edel',10,40,17,65,"+w/b,+w/n")
@10,42 SAY "Field Edit"
@16,42 SAY "Press Escape to abort"
eledit1 = SUBSTR(toedit,1,10)
eledit2 = SUBSTR(toedit,12,1)
eledit3 = VAL(SUBSTR(toedit,15,3))
eledit4 = VAL(SUBSTR(toedit,20,2))
@11,41 SAY "NAME     " GET eledit1 PICTURE "@K!" VALID valname()
@12,41 SAY "TYPE     " GET eledit2 PICTURE "@K!" VALID valtype()
@13,41 SAY "LENGTH   " GET eledit3 PICTURE "@K 999" VALID vallen()
@14,41 SAY "DECIMALS " GET eledit4 PICTURE "@K 99"  VALID valdec()
READ
IF ! LASTKEY() = 27
   st1 = eledit1
   st2 = ' '
   st3 = eledit2
   st4 = '  '
   st5 = TRANSFORM(eledit3,"999")
   st6 = '  '
   st7 = TRANSFORM(eledit4,"99")
   eledit = st1+st2+st3+st4+st5+st6+st7
ELSE
   eledit = ""
ENDIF
killwind('edel',10,40,17,65)
SET Cursor OFF
RETURN eledit

*!*********************************************************************
*!
*!       Function: VALNAME()
*!
*!*********************************************************************
FUNCTION valname
IF EMPTY(eledit1)
   RETURN .F.
ENDIF
if edmod = 'E'  && edit
   dupname = ascan(dbfarr,eledit1)
   IF dupname > 0          && THAT NAME EXISTS
      IF dupname <> currel    && BUT ITS NOT THE CURRENT ELEMENT
         err_mess("There's already a field by that name")
         RETURN .F.
      ENDIF
   ENDIF
else    &&add
   dupname = ascan(dbfarr,eledit1)
   IF dupname > 0          && THAT NAME EXISTS
         err_mess("There's already a field by that name")
         RETURN .F.
   ENDIF
endif
RETURN .T.
*!*********************************************************************
*!
*!       Function: VALTYPE()
*!
*!*********************************************************************
FUNCTION valtype
tkey = GETKY(LASTKEY())
IF .NOT. eledit2 $ "CNLMD"
   RETURN .F.
ENDIF
dupname = ascan(dbfold,eledit1)
IF dupname > 0
   IF .NOT. t2old[DUPNAME] = eledit2
      err_mess("That field name is in use by a different field TYPE")
      RETURN .F.
   ENDIF
ENDIF
IF eledit2 $ "LMD" .AND. tkey = 'FWD'
   DO CASE
   CASE eledit2 = 'L'
      eledit3 = 1
   CASE eledit2 = 'M'
      eledit3 = 10
   CASE eledit2 = 'D'
      eledit3 = 8
   ENDCASE
   eledit4 = 0
   KEYBOARD CHR(13)+CHR(13)
ENDIF
RETURN .T.
*!*********************************************************************
*!
*!       Function: VALLEN()
*!
*!*********************************************************************
FUNCTION vallen
tkey = GETKY(LASTKEY())
IF EMPTY(eledit3)
   RETURN .F.
ENDIF
IF eledit2 = "C" .AND. tkey = 'FWD'
   eledit4 = 0
   KEYBOARD CHR(13)
ENDIF
RETURN .T.
*!*********************************************************************
*!
*!       Function: VALDEC()
*!
*!*********************************************************************
FUNCTION valdec
RETURN .T.
*!*********************************************************************
*!
*!       Function: MAKEWIND()
*!
*!*********************************************************************
FUNCTION makewind
PARAMETERS w_name,wt,wr,wb,wl,wcolor
PUBLIC &w_name
PUBLIC old_color
old_color = setcolor()
STORE savescreen(wt,wr-1,wb+1,wl) TO &w_name
c_popcol = "+W/R,+w/n"
SET COLOR TO IIF( ! pcount() = 6, &c_popcol, &wcolor)
@wt,wr CLEAR TO wb,wl
@wt,wr TO wb,wl
SET COLOR TO N,N,N,N,N
@ wt+1,wr-1,wb+1,wr-1 BOX CHR(219)
@ wb+1,wr-1 SAY REPLICATE(' ', wl-wr)
SET COLOR TO IIF( ! pcount() = 6, &c_popcol, &wcolor)
RETURN ''
*!*********************************************************************
*!
*!       Function: KILLWIND()
*!
*!*********************************************************************
FUNCTION killwind
PARAMETERS w_name,wt,wr,wb,wl
restscreen(wt,wr-1,wb+1,wl,&w_name)
setcolor(old_color)
RETURN ''
*!*********************************************************************
*!
*!       Function: PICKLST()
*!
*!      Called by: M.PRG          
*!
*!*********************************************************************
FUNCTION PICKLST
PARAMETERS MODULE,lineno,varib
DO CASE
CASE varib = 'MODBASE'         && DBF FILE NAMES
   if adir('*.dbf') > 0
     DECLARE dbf_dir[ADIR('*.DBF')]
     adir('*.DBF',dbf_dir)
     nbrof = adir('*.DBF')
   else
     DECLARE dbf_dir[1]
     nbrof = 1
     dbf_dir[1]= "None found...."
   endif
   wsize = IIF(nbrof > 18,20,nbrof+1)
   makewind('DBFPICK',2,30,2+wsize,50)
   dbfnum = achoice(3,31,2+wsize-1,49,dbf_dir)
   dbffile = iif(dbfnum > 0,dbf_dir[DBFNUM],'')
   killwind('DBFPICK',2,30,2+wsize,50)
   if adir('*.dbf') > 0 .and. dbfnum > 0
     KEYBOARD dbffile+CHR(13)
   endif
ENDCASE
return ''
*!*********************************************************************
*!
*!       Function: GETKY()
*!
*!*********************************************************************
FUNCTION GETKY
PARAMETERS lkey
DO CASE
CASE lkey = 5  .OR. lkey = 18
   RETURN "BWD"
OTHERWISE
   RETURN "FWD"
ENDCASE
*!*********************************************************************
*!
*!       Function: ERR_MESS()
*!
*!*********************************************************************
FUNCTION err_mess
PARAMETERS mess_age
makewind('errmess',20,10,22,70,"+W/B")
@21,11 SAY mess_age
INKEY(3)
killwind('errmess',20,10,22,70)
*: EOF: M.PRG
