* ME.PRG
* Memo editor by Bill Osolinski
* 11:10:14  9/4/1988

* ENVIRONMENT
  set exact off
  set escape off
  set softseek off
  set scoreboard off
  set function 15 to cmonth(date()) + ' ' + ltrim(str(day(date()))) + ',  ' + ltrim(str(year(date())))

* VARIABLES
  ret_val = 0
  t = 1
  l = 09
  b = 22
  r = 69
  line_length = 60
  ins_on = .T.
  scrl_on = .F.
  word_wrap = .T.
  init_count = 1
  text_str = ''
  filename = space(8)
  finished = .F.
  keypress = 0
  line_num = 1
  col_num = 0
  rel_row = 0
  rel_col = 0

* SCREEN
  clear
  @ 00,08 to 23,70
  set color to w+/n
  @ 08,27 to 14,51 double
  set color to
  @ 09,29 say 'M E M O  E D I T O R'
  @ 11,29 say '     written by     '
  @ 13,29 say '   Bill Osolinski   '
  set cursor off
  inkey(2)

* PROCESSING
  do while .not. finished
    set cursor on
    clear
    @ 00,l-1 to 23,r+1
    if empty(filename)
      @ 24,l-1 say '<F1> = help'
    else
      @ 24,l-1 say filename + space(4)
    endif
    text_str = memoedit(text_str,t,l,b,r,.T.,"mfunc",line_length,5,line_num,col_num,rel_row,rel_col)
    do case
      case keypress = 10
        this_line = 0
        this_char = 1
        do while this_line # line_num - 1
          if substr(text_str,this_char,1) = chr(13) .or. substr(text_str,this_char,1) = chr(141)
            this_line = this_line + 1
          endif
          this_char = this_char + 1
        enddo
        text_str = left(text_str,this_char + col_num) + chr(12) + right(text_str,len(text_str) - this_char - col_num - 1)
      case keypress = -4
        @ 01,10 clear to 22,69
        matches = adir("*.TXT")
        declare names[matches]
        declare sizes[matches]
        declare dates[matches]
        declare times[matches]
        declare choices[matches]
        adir("*.TXT",names,sizes,dates,times)
        for x = 1 to matches
          choices[x] = space(7) + left(names[x] + space(14),14) + str(sizes[x],10) + space(2) + dtoc(dates[x]) + space(2) + times[x]
        next
        key_char = achoice(01,09,23,69,choices)
        if key_char > 0
          text_str = text_str + memoread(names[key_char])
          filename = trim(names[key_char])
        endif
      case keypress = -6
        @ 24,00
        @ 24,l-1 say 'Save file?'
        choice = ' '
        do while .not. choice $ 'YN'
          choice = 'Y'
          @ 24,l+10 get m->choice picture '!'
          read
        enddo
        if choice = 'Y'
          if .not. empty(filename)
            filename = left(filename,len(filename)-4)
          endif
          @ 24,00
          @ 24,l-1 say 'Enter filename:'
          @ 24,l+15 get filename picture replicate('!',8)
          read
          if .not. empty(filename)
            filename = trim(filename) + '.TXT'
            if file(filename)
              choice = ' '
              @ 24,l-1 say 'Replace existing file?'
              do while .not. choice $ 'YN'
                choice = 'N'
                @ 24,l+22 get m->choice picture '!'
                read
              enddo
              if choice = 'Y'
                set cursor off
                @ 24,00
                @ 24,l-1 say 'Writing ' + filename
                memowrit(filename,text_str)
                inkey(1)
                set cursor on
              endif
            endif
          endif
        endif
        @ 24,00
        @ 24,l-1 say 'Exit ME?'
        choice = ' '
        do while .not. choice $ 'YN'
          choice = 'N'
          @ 24,l+8 get m->choice picture '!'
          read
        enddo
        if choice = 'Y'
          finished = .T.
        else
          text_str = ''
          filename = space(8)
        endif
      case keypress = -8
        do while .T.
          dbname = space(8)
          @ 24,00
          @ 24,l-1 say 'Enter database name:'
          @ 24,l+20 get dbname picture replicate('!',8)
          read
          if file(dbname + '.DBF')
            use &dbname
            exit
          else
            ?? chr(7)
            @ 24,00
            @ 24,l-1 say 'Database not found...'
            set cursor off
            inkey(0)
            set cursor on
          endif
        enddo
        set cursor off
        @ 24,00
        @ 24,l-1 say 'Please wait'
        declare fnames[fcount()]
        declare fused[fcount()]
        afields(fnames)
        used = 0
        for x = 1 to len(text_str)
          if substr(text_str,x,1) = '{'
            some_field = ''
            do while substr(text_str,x,1) <> '}'
              x = x + 1
              some_field = some_field + substr(text_str,x,1)
            enddo
            some_field = left(some_field,len(some_field)-1)
            if ascan(fnames,some_field) > 0
              used = used + 1
              fused[used] = some_field
            endif
          endif
        next
        out_str = ''
        do while .not. eof()
          merge_str = chr(13) + chr(10) + text_str
          if used > 0
            for x = 1 to used
              datafield = fused[x]
              merge_str = strtran(merge_str,"{" + fused[x] + "}",trim(&datafield))
            next
          endif
          merge_str = strtran(merge_str,chr(141)+chr(10),chr(32))
          merge_str = memoedit(merge_str,0,0,0,0,.T.,"ofunc",line_length)
          out_str = out_str + merge_str + chr(12)
          skip
        enddo
        text_str = out_str
        set cursor on
      case keypress = -9
        if .not. empty(filename)
          filename = left(filename,len(filename)-4)
        endif
        @ 24,00
        @ 24,l-1 say 'Enter filename:'
        @ 24,l+15 get filename picture replicate('!',8)
        read
        if .not. empty(filename)
          filename = trim(filename) + '.TXT'
          if file(filename)
            choice = ' '
            @ 24,l-1 say 'Replace existing file?'
            do while .not. choice $ 'YN'
              choice = 'N'
              @ 24,l+22 get m->choice picture '!'
              read
            enddo
            if choice = 'Y'
              set cursor off
              @ 24,00
              @ 24,l-1 say 'Writing ' + filename
              memowrit(filename,text_str)
              inkey(1)
              set cursor on
            endif
          endif
        endif
      case keypress = -11
        @ 24,00
        search_str = space(20)
        repl_str = space(20)
        @ 24,l-1 say 'Enter the string to search for:'
        @ 24,l+31 get m->search_str
        read
        @ 24,00
        @ 24,l-1 say 'Enter the string to replace with:'
        @ 24,l+33 get m->repl_str
        read
        @ 24,00
        choice = ' '
        @ 24,l-1 say 'OK to proceed?'
        do while .not. choice $ 'YN'
          choice = 'Y'
          @ 24,l+14 get m->choice picture '!'
          read
        enddo
        if choice = 'Y'
          text_str = strtran(text_str,trim(search_str),trim(repl_str))
          text_str = strtran(text_str,chr(141)+chr(10),chr(32))
          text_str = memoedit(text_str,0,0,0,0,.T.,"ofunc",line_length)
        endif
      case keypress = -16
        do while .not. isprinter()
          ?? chr(7)
          set cursor off
          @ 24,l-1 say 'Printer not ready.  Correct and press any key to continue.' + space(10)
          inkey(0)
          set cursor on
        enddo
        @ 24,00
        @ 24,l-1 say 'Printing...'
        set cursor off
        set device to print
        line_no = prow()
        line_count = mlcount(text_str,line_length,5,.F.)
        for cur_line = 1 to line_count
          print_line = memoline(text_str,line_length,cur_line,5,.F.)
          @ line_no + cur_line, 09 say print_line
        next
        if substr(text_str,len(text_str),1) # chr(12)
          eject
        endif
        set printer to
        set device to screen
        set cursor on
      case keypress = -17
        @ 24,00
        @ 24,l-1 say 'Enter left margin:     Right margin:'
        left = l + 1
        right = r + 1
        @ 24,l+18 get m->left picture '99' range 1,79
        @ 24,l+36 get m->right picture '99' range 2,80
        read
        if right - left > 1
          l = left - 1
          r = right - 1
          line_length = r - l
        endif
    endcase
  enddo
  clear
  return

* FUNCTIONS
  function mfunc
  parameters mode, line, col
    ret_val = 0
    do case
      case mode = 3
        if init_count = 1
          ins_mode = readinsert()
          if (ins_on .and. .not. ins_mode) .or. (.not. ins_on .and. ins_mode)
            ret_val = 22
          else
            init_count = 2
            @ b + 2, r - 27 say if(ins_on, "<Insert>", space(8))
          endif
        endif
        if init_count = 2
          if scrl_on
            ret_val = 35
          else
            init_count = 3
            @ b + 2, r - 37 say if(scrl_on, "<Scroll>", space(8))
          endif
        endif
        if init_count = 3
          if .not. word_wrap
            ret_val = 34
          else
            init_count = 4
            @ b + 2, r - 45 say if(word_wrap, "<Wrap>", space(6))
          endif
        endif
        if init_count = 4
          init_count = 1
          ret_val = 0
        endif
      case mode = 0
        @ b + 2, r - 16 say "Line: " + pad(ltrim(str(line)), 3)
        @ b + 2, r - 5 say "Col: " + pad(ltrim(str(col)), 2)
      otherwise
        keypress = lastkey()
        line_num = line
        col_num = col
        rel_row = row() - t
        rel_col = col() - l
        do case
          case keypress = 10
            ret_val = 23
          case keypress = 22
            ins_on = .not. ins_on
            @ b + 2, r - 27 say if(ins_on, "<Insert>", space(8))
            ret_val = 22
          case keypress = 28
            row = row()
            col = col()
            save screen
            @ 01,12 say space(58)
            @ 01,12 say 'KEY'
            @ 01,43 say 'PURPOSE'
            @ 02,l to 02,r
            @ 24,00
            @ 24,l-1 say 'Press <Esc> to exit'
            help_text = memoread('ME.HLP')
            memoedit(help_text,t+2,l,b,r,.F.,"",line_length)
            restore screen
            @ row,col say ''
          case keypress = -1
            ret_val = 2
          case keypress = -2
            ret_val = 25
          case keypress = -3
            ret_val = 20
          case keypress = -4
            ret_val = 23
          case keypress = -5
            word_wrap = .not. word_wrap
            @ b + 2, r - 45 say if(word_wrap, "<Wrap>", space(6))
            ret_val = 34
          case keypress = -6
            ret_val = 23
          case keypress = -7
            scrl_on = .not. scrl_on
            @ b + 2, r - 37 say if(scrl_on, "<Scroll>", space(8))
            ret_val = 35
          case keypress = -8
            ret_val = 23
          case keypress = -9
            ret_val = 23
          case keypress = -11
            ret_val = 23
          case keypress = -16
            ret_val = 23
          case keypress = -17
            ret_val = 23
        endcase
    endcase
  return ret_val

  function ofunc
  parameters mode, line, col
    ret_val = 0
    if mode # 3
      ret_str = 23
      keyboard chr(23)
    endif
  return ret_val


* EOF: ME.PRG