*****************************************************************************
*                          Shareware - DEMO                                 *
*                Mouse interupt 12 with Clipper S'87                        *
*       (c) 1990, Jobst Hensiek, Germany (West),CIS 76656,1606              *
*                                                                           *
*        FEB-17-90                           It explains my orthography!   *
*                                                                           *
*  What do you get:                                                         *
*   - Two new function's:                                                   *
*     +  MOUSE(@M1,@M2,@M3,@M4)                                             *
*     +  M_GETMXY(@MS2,@MS3,@M4,@MS5) <-- Only used for interrupt           *
*                                                                           *
*  What do you need ?                                                       *
*     +  Clipper S'87                                                       *
*     +  My function's                                                      *
*     +  that's it!                                                         *
*                                                                           *
*  Why another mouse interface for clipper ?                                *
*   If don't like doing loops and loops & ..., you have to make a interrupt *
*   to affect your application somehow. So why not using Clipper's SET KEY  *
*   facility to get the interrupts in. Hardware - interrupts are very very  *
*   tricky. Using Clipper's SET KEY function is the smarter way. - Thanks-  *
*   Long before Rich McConnell's EXTOR came along, Clipper could already    *
*   pass parameters by reference down to C & Assembler and back. How ?      *
*   The >call< command, explained on page 5-39 in your Clipper-manual, does *
*   the job!                                                                *
*                                                                           *
*  What I had in mind:                                                      *
*  o  To have only one mouse function to do the job.(Like BASIC)            *
*     - Writing some assembler code. Grinn..                                *
*                                                                           *
*  o  Using the standard mouse functions as discribed in your mouse manual. *
*                                            (except function 9, graphics)  *
*                                                                           *
*  o  Communication with the mousehandler via the 'CALL' command.           *
*     - Passing parameters by reference.                                    *
*                                                                           *
*  o  Setting up a SET KEY ASC("X") TO procedure, activated by the mouse    *
*     handler.                                                              *
*                                                                           *
*  o  Setting up interrupt events according to the mask bits in parameter m3*
*                                                                           *
*  o  Examination of the mouse status after the interrupt.                  *
*                                                                           *
*  o  No loops, like ..., ..., ...                                          *   
*                                                                           *
* --------------------------------------------------------------------------*
*  What I want ?                                                            *
*   You to run the demo! If you do like it, you might want to register.     *                      *
*   You get a working copy of maus.obj and full the documentation via CIS.  *
*   The Assembler source is also available, let me know.                    *                    *     *                                                                *
*****************************************************************************
* !! Read this: Don't erase the copyright information. At least don't use   *                                *
*               !YO!UR! PC while you try it !! Do you hear me ?           *
*****************************************************************************
*---------------------------------< BOF >------------------------------------
*** Used for the demo
SET CURSOR OFF
SET SCOREBOARD OFF
SET INTENSITY OFF

* What do have ?
IF ISCOLOR()
 CLEAR
 col1 ="W/B"
 col2 ="R/B"
 col3 ="G/B"
 col4 ="B/W*"
 col5 ="N/GR"
ELSE
 STORE "W/N" to col1,col2,col3
 STORE "N/W" TO col4,col5
ENDIF
SET COLOUR TO &COL1
CLEAR
DUM = ' '
DO MAUS_BILD

* Function MOUSE & M_GETMXY need this parameters as public
PUBLIC m1,m2,m3,m4,mi2,mi3,mi4,mi5
STORE 0 TO m1,m2,m3,m4,mi2,mi3,mi4,mi5


* Activation character. The mouse handler will place in the keyboard buffer. 
drop_in=ASC("A")


* MOUSE : Reset mouse & get status.
MOUSE(@m1,@m2,@m3,@m4)
IF m1 # -1
  CLEAR
  ? "No mouse found"+chr(7)
  RETURN
ENDIF


* MOUSE: Show mouse cursor
m1=1
MOUSE(@m1,@m2,@m3,@m4)


***** MOUSE: Enable Interrupt ************************************
* !! Disable interrupts while you write to disk or do indexing. !!
* !!            Turn it off before you return to DOS            !!
******************************************************************
m1 = 12                      && function 12 to set the interrupt
m3 = 10                      && MASK-Bit's for interrupt.
m4 = drop_in                 && store a character in the keyboard buffer
SET KEY drop_in TO m_action  && M_ACTION is activated by the mouse interrupt
MOUSE(@m1,@m2,@m3,@m4)


* Wait-State. You may now invoke the "SET KEY drop_in TO procedure" 
@ 1,0 GET DUM
READ

* Shut interrupt off etc. & return to DOS
DO BYE


*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
*  MOUSE: Disable Interrupt !!!!!- Don't forget to do this, before you    *
*                                  return to DOS -!!!!!!                  *
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
*
m1=12   && This shut's him OFF
m3=0    &&
MOUSE(@m1,@m2,@m3,@m4)


* MOUSE: Hide cursor, cursor OFF
m1=2
MOUSE(@m1,@m2,@m3,@m4)
SET COLOUR TO
CLEAR

***
*
*    Read status after mouse interrupt 12
*
*    All Parameters are passed by reference
*    
*    What is what ?
*
PROCEDURE M_ACTION
PRIVATE C
M_GETMXY(@mi2, @mi3, @mi4,@mi5)
DO CASE
   CASE mi2 = 1
    SET COLOUR TO &COL2
    FOR I=7 to 11
      @ I,23 SAY ""
    NEXT
   CASE mi2 = 2
    SET COLOUR TO &COL3
    FOR I=7 to 11
      @ I,42 SAY ""
    NEXT
   CASE mi2 = 3
    FOR I=7 to 11
      SET COLOUR TO &COL2
      @ I,23 SAY ""
      SET COLOUR TO &COL3
      @ I,42 SAY ""
    NEXT
  ENDCASE
  SET COLOUR TO &COL1
  @ 20,25 SAY "X:= "+STR(mi3,3)+"       Y:="+str(mi4,3)
  IF (mi3 >= 432) .AND. (mi3 <= 504)
    m1=2         && mouse cursor off
    MOUSE(@m1,@m2,@m3,@m4)
    IF (mi4 >=136) .AND. (mi4 <= 144)
    SET COLOUR TO &COL4
     @ 17,54 SAY "          "
     @ 18,54 SAY "   hello "
     ? chr(7)
    ENDIF
    IF (mi4 >=160) .AND. (mi4 <= 168)
     SET COLOUR TO &COL5
     @ 20,54 SAY "          "
     @ 21,54 SAY "  bye... "
     C=inkey(1.5)
     DO BYE
    ENDIF
  ENDIF
  SET COLOUR TO &COL1
  C=INKEY(1.5)
  @ 7,23 CLEAR TO 11,29
  @ 7,42 CLEAR TO 11,48
  @ 20,25 CLEAR TO 20,46
  @ 17,54 SAY "          "
  @ 18,54 SAY "   BEEP   "
  *
  * Mouse cursor back on
  m1=1
  MOUSE(@m1,@m2,@m3,@m4)
RETURN

PROCEDURE MAUS_BILD      
@ 3,20 SAY       "               "
@ row()+1,20 SAY "             Ŀ"
@ row()+1,20 SAY "Ŀ"
@ row()+1,20 SAY " Ŀ          Ŀ "
@ row()+1,20 SAY "                          "
@ row()+1,20 SAY "                          "
@ row()+1,20 SAY "                          "
@ row()+1,20 SAY "                          "
@ row()+1,20 SAY "                          "
@ row()+1,20 SAY "            "
@ row()+1,20 SAY "                              "
@ row()+1,20 SAY "   Mouse Interrupt (12) with  "
@ row()+1,20 SAY "        Clipper(tm) S'87      "
@ row()+1,20 SAY "                               Ŀ" 
@ row()+1,20 SAY "  - Interrupt -ͻ             " 
@ row()+1,20 SAY "    invoked at location         BEEP   " 
@ row()+1,20 SAY "                             Ĵ Use the mouse" 
@ row()+1,20 SAY "                                          or press" 
@ row()+1,20 SAY "  ͼ      QUIT     any key to" 
@ row()+1,20 SAY "      quit"
RETURN                                            

PROCEDURE BYE
 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *  MOUSE: Disable Interrupt !!!!!- Don't forget to do this, before you    *
 *                                  return to DOS -!!!!!!                  *
 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
  m1=12                && Interrupt off
  m3=0                 && Mask bit to 0
  MOUSE(@m1,@m2,@m3,@m4)
  m1=2                 && Mouse off
  MOUSE(@m1,@m2,@m3,@m4)
  SET COLOUR TO
  CL_BOX(0,0,24,79,0,7)
  REG()
  SET CURSOR ON
  QUIT
RETURN

FUNCTION CL_BOX
PARAMETERS zl,sl,zr,sr,richt,FARBE
PRIVATE DIF,I,C
DIF=zr-zl+1
FOR I=1 TO DIF
 _SCROLL(zl,sl,zr,sr,richt,FARBE)
 C=inkey(0.01)
NEXT
RETURN(.T.)

FUNCTION REG
PRIVATE I
DECLARE M[20]
m[1]=""
m[2]="  Do you like it? "
m[3]="       Send your order via Easyplex to [76656,1606]"
m[4]="       or by mail. Please accompany 25 US$ or"
m[5]="       50.00 DM (West German Mark's). A cheque"
m[6]="       (traveller cheque) might do it too. You get a"
m[7]="       working copy of >maus.obj< in return via Easyplex."
m[8]=""
m[9]="  My address:"
m[10]="       job - soft"
m[11]="       Jobst Hensiek"
m[12]="       Claustorwall 23"
m[13]="       D-3380 Goslar 1"
m[14]="       West Germany"
m[15]="       Phone: 011 (495) 321-4457"
m[16]="       Don't waste your money on the phone!"
        
FOR I=1 TO 16
  @ 24,5 SAY m[i]
  ?
  C=INKEY(0.01)
NEXT
?
?
RETURN .t.
*---------------------< EOF DEMO >----------------------------------------

*---------------------< The Two mouse Functions >-------------------------
***
*
*    main mouse function                 
*
*    All Parameters are passed by reference
*    
*    What is what ?
*
FUNCTION MOUSE
PARAMETERS m1,m2,m3,m4
 PRIVATE _m1,_m2,_m3,_m4
 *** 
 * The registered version does NOT pass strings.   
 *  o it gives you more speed  
 ***
 _m1=STR(m1,4)
 _m2=STR(m2,4)
 _m3=STR(m3,4)
 _m4=STR(m4,4)
 CALL _maus WITH _m1,_m2,_m3,_m4
 m1=VAL(_m1)
 m2=VAL(_m2)
 m3=VAL(_m3)
 m4=VAL(_m4)
RETURN .T.

FUNCTION M_GETMXY
PARAMETERS mi2,mi3,mi4,mi5
 PRIVATE _mi2,_mi3,_mi4,_mi5
 STORE SPACE(4) TO _mi2,_mi3,_mi4,_mi5
 *** 
 * The registered version does NOT pass strings.  
 *  o it gives you more speed  
 ***
 CALL _getmxy WITH _mi2,_mi3,_mi4,_mi5
 mi2=VAL(_mi2)
 mi3=VAL(_mi3)
 mi4=VAL(_mi4)
 mi5=VAL(_mi5)
RETURN .T.
*---------------------< EOF >-----------------------------------------------











