* Program ...: Makexrf.PRG
* Author ....: John Thomas
* Date ......: March 1, 1988
* Note(s)....: Program to build a cross-reference database file for
*              database files with multilevel fields.
*
*              The multilevel fields must have a common root 
*              Name1, Name2, ... Name15, for example.
*
*              Two parameters are required:
*
*              DO Makexrf WITH filename, root
*
*              where filename is the name of the database file
*              containing multilevel fields, and root is the root
*              common to all the fields to be cross-referenced.
*              The resulting database file will have a name consisting
*              of the letter X and the root of the multilevel fields,
*              Xname.DBF, for example.
*
*
PARAMETERS filename, root

SET TALK OFF
SET SAFETY OFF
SET EXACT OFF
CLOSE DATABASES


filename = UPPER(LTRIM(TRIM(filename)))
root     = UPPER(LTRIM(TRIM(root)))

* ---Make sure file exists.
IF .NOT. "." $ filename
   filename = filename + ".DBF"
ENDIF
IF .NOT. FILE(filename)
   ?
   ? "Can't Access " + filename + ". Quitting."
   CANCEL
ENDIF


CLEAR
? "Setting Up ... Please Wait"

* ---Copy the database structure to a working file.
USE &filename
COPY STRUCTURE EXTENDED TO Temp
USE Temp

* ---Delete all but the multilevel fields from the
* ---temporary file structure, and count the remaining fields.
COUNT FOR Field_name = root TO fieldcnt

IF fieldcnt < 2
   ?
   ? [There must be at least two "] + root + [" fields in ] +;
         filename + [. Quitting.]
   CLOSE DATABASES
   ERASE Temp.DBF
   RETURN
ENDIF

* ---Delete all but the first multilevel field.
GO TOP
DELETE WHILE Field_name <> root
SKIP
DELETE REST
PACK
GO TOP
REPLACE Field_name WITH root

* ---Define a new field to hold the RECNO() from the original file.
INSERT BEFORE BLANK
REPLACE Field_name WITH "Recnum", ;
        Field_type WITH "N", ;
        Field_len WITH 10, ;
        Field_dec with 0
CLOSE DATABASES

* ---Create the new database.
CREATE X&root FROM Temp
ERASE Temp.DBF

* ---Set up databases to create cross-reference file.
SELECT A
USE &filename
SELECT B
USE X&root
SELECT A

* ---Set up test for empty fields. The test must be 
* ---appropriate for the field type. 
temp = root + "1"
DO CASE
CASE TYPE(temp) = "C"
   test = "LEN(TRIM(tdata)) > 0"
CASE TYPE(temp) = "N" 
   * ---Assume zero means empty.
   test = "tdata <> 0"
CASE TYPE(temp) = "D"
   test = "DTOC(tdata) <> [  /  /  ]"
CASE TYPE(temp) = "L"
   * ---Logical fields can't be empty, and so they should
   * ---always be copied to the cross-reference file.
   test = ".T."
CASE TYPE(temp) $ "MU"
   ? temp + "is not a valid cross-reference field. Quitting."
   CLEAR ALL
   CANCEL
ENDCASE


CLEAR
? "Working ... Please Wait"
DO WHILE .NOT. EOF()
   * ---Create a new record for every non-blank
   * ---multilevel field in input database file.
   cnt = 1
   DO WHILE cnt <= fieldcnt
      charcnt = LTRIM(STR(cnt))
      tdata = A->&root&charcnt
      * ---Apply the test macro.
      IF &test
         temp = RECNO()
         SELECT B
         APPEND BLANK
         REPLACE Recnum WITH temp, ;
                 &root WITH tdata
         SELECT A
      ENDIF
      cnt = cnt + 1
   ENDDO
   SKIP
ENDDO

SELECT B
SET RELATION TO Recnum INTO A
SELECT A
SET FIELDS TO ALL
SELECT B
SET FIELDS TO ALL
CLEAR
?
? [     "X&root..DBF" has been created with ] +;
        LTRIM(STR(RECCOUNT())) + [ cross-reference records.]
?
?
? "     X&root..DBF has been related into &filename and all fields"
? "     have been set ON. Enter"
?
? "         CREATE VIEW FROM ENVIRONMENT"
?
? "     at the dot prompt to save this setup in a view file."

* ---Clean up.
SET TALK ON
SET SAFETY ON
RETURN
* EOP: Makexrf.PRG

