;------------------------------------------------------------------------------
;                         ---- LOGICLP.ASM  ----
; Again just a simple set of functions ,sometimes the simple ones are the most
; useful. They will provide Clipper with the ability to perform bit operations
; on numeric variables such as AND, OR, NOT, XOR  on long integers. I use these
; for checksum calculations.
;
; Filename: LOGICLP.ASM
; Program.: Clipper Logical Numeric Functions
; Authors.: Patrick Jonte
; Date....: April 20, 1986
; Function: OR_(exp1,exp2)
;           AND_(exp1,exp2)
;           NOT_(exp1)
;           XOR_(exp1,exp2)
;
; Note   All Variables are passed as Long Numeric

;
;------------------------------------------------------------------------------
;
title LOGICAL NUMERIC FUNCTIONS FOR CLIPPER W85
name LOGICLP
;
_prog segment byte public
;
public  or_
public and_
public xor_
public not_
;
;
extrn   _retc:far      ; return character string
extrn   _retds:far     ; return date type from date string "YYYYMMDD"
extrn   _retl:far      ; return logical true or false
extrn   _retni:far     ; return word as numeric
extrn   _retnl:far     ; return double word as numeric
extrn   _retnd:far     ; return floating point as numeric
;
extrn   _parc:far      ; pass character string
extrn   _parni:far     ; pass integer numeric
extrn   _parnl:far     ; pass integer long numeric
extrn   _parnd:far     ; pass double numeric
extrn   _parl:far      ; pass logical integer
extrn   _pards:far     ; pass date string "yyyymmdd"
;
extrn   _parinfo:far   ; UNDEF           0
                       ; CHARACTER       1
                       ; NUMERIC         2
                       ; LOGICAL         4
                       ; DATE            8
                       ; ALIAS           16
                       ; MPTR            32
                       ; MEMO            65
                       ; WORD            128
;
        assume  cs:_prog
;
or_   proc      far
        push    bp
        push    ds
        push    es
;
        mov     ax,0
        push    ax
        call    _parinfo             ; make sure there is 2 parameters
        pop     bx
        cmp     ax,2
        jnz      F30
;
        mov     ax,1
        push    ax
        call    _parinfo             ; make sure parameter 1 is numeric type
        pop     bx
        cmp     ax,2
        jnz      F30
;
        mov     ax,2
        push    ax
        call    _parinfo            ; make sure parameter 2 is numeric type
        pop     bx
        cmp     ax,2
        jnz      F30
;
        mov     ax,1                ; get #1 parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; dummy pop to fixup stack
        push    ax                  ; ax has the segment address
        push    bx                  ; bx has the offset address
;
        mov     ax,2                ; get #2 parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; fixup stack
        pop     dx                  ; pop previous varibles off stack
        pop     cx
        or      ax,cx               ; do the operation
        or      bx,dx
        push    ax                  ; push the result for a long numeric
        push    bx                  ; ax has the high bx has the low
        call    _retnl              ; rturn value to clipper
        pop     bx
        pop     ax
F30:                                ; all these pops fixup the stack
        pop     es
        pop     ds
        pop     bp
        ret
or_  endp
;
;
;
;
and_   proc      far
        push    bp
        push    ds
        push    es
;
        mov     ax,0
        push    ax
        call    _parinfo             ; make sure there is 2 parameters
        pop     bx
        cmp     ax,2
        jnz     G30
;
        mov     ax,1
        push    ax
        call    _parinfo             ; make sure parameter 1 is numeric type
        pop     bx
        cmp     ax,2
        jnz     G30
;
        mov     ax,2
        push    ax
        call    _parinfo             ; make sure parameter 2 is numeric type
        pop     bx
        cmp     ax,2
        jnz     G30
;
        mov     ax,1                ; get #1 parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; dummy pop to fixup stack
        push    ax                  ; ax has the segment address
        push    bx                  ; bx has the offset address
;
        mov     ax,2                ; get #2 parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; fixup stack
        pop     dx
        pop     cx
        and     ax,cx
        and     bx,dx
        push    ax
        push    bx
        call    _retnl
        pop     bx
        pop     ax
G30:
        pop     es
        pop     ds
        pop     bp
        ret
and_  endp
;
;
;
;
xor_   proc      far
        push    bp
        push    ds
        push    es
;
        mov     ax,0
        push    ax
        call    _parinfo             ; make sure there is 2 parameters
        pop     bx
        cmp     ax,2
        jnz     H30
;
        mov     ax,1
        push    ax
        call    _parinfo             ; make sure parameter 1 is numeric type
        pop     bx
        cmp     ax,2
        jnz     H30
;
        mov     ax,2
        push    ax
        call    _parinfo             ; make sure parameter 2 is numeric type
        pop     bx
        cmp     ax,2
        jnz      H30
;
        mov     ax,1                ; get #1 parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; dummy pop to fixup stack
        push    ax                  ; ax has the segment address
        push    bx                  ; bx has the offset address
;
        mov     ax,2                ; get #2 parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; fixup stack
        pop     dx
        pop     cx
        xor     ax,cx
        xor     bx,dx
        push    ax
        push    bx
        call    _retnl
        pop     bx
        pop     ax
H30:
        pop     es
        pop     ds
        pop     bp
        ret
xor_  endp
;
;
;
;
;
not_   proc      far
        push    bp
        push    ds
        push    es
;
        mov     ax,0
        push    ax
        call    _parinfo             ; make sure there is 1 parameter
        pop     bx
        cmp     ax,1
        jnz      I30
;
        mov     ax,1
        push    ax
        call    _parinfo             ; make sure parameter is numeric type
        pop     bx
        cmp     ax,2
        jnz      I30
;
        mov     ax,1                ; get parameter
        push    ax                  ; put it on the stack
        call    _parnl              ; get the parameter from clipper
        pop     es                  ; dummy pop to fixup stack
;
        not     ax
        not     bx
        push    ax
        push    bx
        call    _retnl
        pop     bx
        pop     ax
I30:
        pop     es
        pop     ds
        pop     bp
        ret
not_  endp
;
;
;
_prog    ends

end
