*  Program Ŀ
*   Application: Billing Information System                                 
*   Description: Clipper Call Stack Routine                                 
*     File Name: LISTSTAC.PRG                                               
*        Author: Terry Thalen                                               
*  Date created: 03-05-94              Date updated: 03-05-94              
*  Time created: 03:53:14pm            Time updated: 03:58:09pm            
*     Make File: None                                                       
*     Exec File: None                  Docs By: Terry Thalen                
*     Copyright: (c) 1994 by Creative Software Solutions                    
* 
* Usage:	SETKEY( K_xx, { || ListStac() }) In Main .PRG File After Local
* and Static declarations
* Notes:  	When using a key handler such as CASE..DO CASE make the first
*				option as follows:
*
*			DO CASE
*				CASE (bAction := SETKEY(nKey)) != NIL
*					EVAL(bAction)
*****************************************************************************


FUNCTION ListStack()
	LOCAL nActivation
	LOCAL aStackArray
	nActivation := 1
	aStackArray := {}
	WHILE ! ( PROCNAME( nActivation ) == "" )
		AADD( aStackArray, { PROCNAME( nActivation ),PROCLINE( nActivation ) } )
		nActivation++
	ENDDO
	StackList(aStackArray)

RETURN( nil )

STATIC FUNCTION StackList(aStackArray)
	LOCAL cScreen
	LOCAL cOldColor
	LOCAL nElement
	LOCAL cHeader
	LOCAL nTop
	LOCAL nLeft
	LOCAL nBottom
	LOCAL nRight
	LOCAL lShadow
	PRIVATE lOkToLeave
	nTop       := 10
	nLeft      := 15
	nBottom    := 15
	nRight     := 75
	cHeader    := "System Call Stack"
	cScreen    := SAVESCREEN( 00,00,24,79 )
	cOldColor  := SETCOLOR()
	nElement   := 1
	lShadow    := .T.
	lOkToLeave := .F.
	SETCOLOR( "W+/BG+" )
	BoxDraw(cHeader, nTop-2,nLeft-2,nBottom+2,nRight+2,lShadow)
	obrowse:=TBROWSENEW( nTop,nLeft,nBottom,nRight )
	obrowse:HEADSEP:=""
	obrowse:COLSEP :=""
	obrowse:GOTOPBLOCK := { || nElement := 1 }
	obrowse:GOBOTTOMBLOCK := { || nElement := LEN( aStackArray ) }
	obrowse:SKIPBLOCK := { |n| arrayskip( LEN( aStackArray ), @nElement, n ) }
	col1 := TBCOLUMNNEW( "Procedure", { || aStackArray[nElement][1] } )
	col1:WIDTH := 15
	col2 := TBCOLUMNNEW( "Line No.", { || aStackArray[nElement][2] } )
	col2:WIDTH := 10
	obrowse:ADDCOLUMN( col1 )
	obrowse:ADDCOLUMN( col2 )
	DO WHILE .t.
		WHILE !obrowse:STABILIZE()
		ENDDO
		usrKey:=INKEY(0)
		DO CASE
			CASE (usrKey==K_DOWN)      ; obrowse:DOWN()
			CASE (usrKey==K_UP)        ; obrowse:UP()
			CASE (usrKey==K_ESC)       ; EXIT
			OTHERWISE
				TONE(125,0)
		ENDCASE
	ENDDO
	RESTSCREEN( 00,00,24,79,cScreen )
	SETCOLOR( cOldColor )
RETURN( nil )

FUNCTION arrayskip( alen, curpos, howmany )
	LOCAL actual
	IF howmany >= 0
		IF ( curpos + howmany ) > alen
			actual := alen - curpos
			curpos := alen
		ELSE
			actual := howmany
			curpos += howmany
		ENDIF
	ELSE
		IF ( curpos + howmany ) < 1
			actual := 1 - curpos
			curpos := 1
		ELSE
			actual := howmany
			curpos += howmany
		ENDIF
	ENDIF
RETURN( actual )

