/*
 * File......: LASTDAY.PRG
 * Author....: Richard M. Mitchell [CIS ID:  72754,3370]
 * Date......: $08/04/94$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 *
 * Modification history:
 * ---------------------
 * Function previously written by Jeff Bryant, re-written for 
 * optimization by Mike Schinkel, additional functionality by Richard
 * M. Mitchell.
 *
 * $Log$
 * 
 */


/*  $DOC$
 *  $FUNCNAME$
 *  FT_LDay()
 *  $CATEGORY$
 *  DATE/TIME
 *  $ONELINER$
 *  Return last day of month (specific day of week optional).
 *  $SYNTAX$
 *  FT_LDay( [dDateToCheck], [xDayOfWeek] ) -> dLastDay
 *  $ARGUMENTS$
 *  <dDateToCheck> is a date within a month for which you want to find
 *     the last date of that month.  Default is the current date.
 *  <xDayOfWeek> is the day of the week to find as the last of that
 *     day in the month of <dDateToCheck>.  If a numeric variable is
 *     passed, it must be an integer between 1 and 7, inclusive.  The
 *     integers correspond to days of the week, Sunday through Saturday.
 *     If a character-type argument, the first three characters must 
 *     match to a day of the week -- for instance, "MON", "MONSTER  ",
 *     "MONDAY" and "MONDAY  " would all be valid references to MONDAY.
 *     The routine is case insensitive.  The default is to ignore the
 *     argument.  An empty string translates as a default.
 *  $RETURNS$
 *  If only a valid <dDateToCheck> is passed, the return is a Clipper
 *  date value that represents the last day of the month of 
 *  <dDateToCheck>.  If a valid <xDayOfWeek> is passed, the last day 
 *  of the month of <dDateToCheck> that falls on <xDayOfWeek> is 
 *  returned.  If <dDateToCheck> or <xDayOfWeek> are not valid 
 *  arguments, then the return is an empty date -- equivalent to 
 *  ctod( "  /  /  " ).
 *  $DESCRIPTION$
 *  This function will return the last day of the month of the date
 *  passed or the last day of the current month if no date argument
 *  is supplied.  
 *
 *  Optionally, a second parameter is available to specify the last
 *  occurence of a day of the week within the supplied or current
 *  month.   
 *
 *  This function is date format insensitive.
 *
 *  Acknowledgements:  Previous versions by Jeff Bryant and Mike 
 *                     Schinkel
 *  $EXAMPLES$
 *  FT_LDay( ctod( "02/01/96" ) )     // returns 02/29/96, as a date
 *  FT_LDay( ctod( "02/01/96" ), "MONDAY" ) //   02/26/96, as a date
 *  FT_LDay( ctod( "07/05/94" ), "tue" ) //      07/26/94, as a date
 *  FT_LDay( ctod( "07/21/94" ), 3 )     //      07/26/94, as a date
 *  FT_LDay()                            // last day of current month
 *  FT_LDay( 3 )                         //        /  /  , empty date
 *  FT_LDay( , 1.3 )                     //        /  /  , empty date
 *  FT_LDay( , "non" )                   //        /  /  , empty date
 *  $SEEALSO$
 *  $INCLUDE$
 *  
 *  $END$
 */
#include "common.ch"
#include "set.ch"

#ifdef TEST
#include "inkey.ch"

function start()
   local GetList := {}
   local dDate := date()
   local cDay := "TUESDAY  "

   cls
   while ! lastkey() == K_ESC
      @ 5, 1 say "Date:  "  get dDate
      @ 6, 1 say "Last Day:  " get cDay
      read

      @ 20, 0 say FT_LDay( dDate, cDay )
   end while
   @ 22, 0 say "Last day of this month:"
   @ 23, 0 say FT_LDay()
   ? FT_LDay( ctod( "02/01/96" ) )     // returns 02/29/96, as a date
   ? FT_LDay( ctod( "02/01/96" ), "MONDAY" ) //   02/26/96, as a date
   ? FT_LDay( ctod( "07/05/94" ), "tue" ) //      07/26/94, as a date
   ? FT_LDay( ctod( "07/21/94" ), 3 )     //      07/26/94, as a date
   ? FT_LDay()                            // last day of current month
   ? FT_LDay( 3 )                         //        /  /  , empty date
   ? FT_LDay( , 1.3 )                     //        /  /  , empty date
   ? FT_LDay( , "non" )                   //        /  /  , empty date

   return NIL
#endif


function FT_LDay( dDate, xDOW )
   local nDOW := 0
   local cTest 
   local dReturn := ctod( " " )

   default dDate to date()

   begin sequence
      
      if ! valtype( dDate ) == "D"
         break
      endif

      if valtype( xDOW ) == "C" 
         if ! empty( xDOW )
            nDOW := ( at( substr( upper( trim( xDOW ) ), 1, 3 ), ;
               "SUNMONTUEWEDTHUFRISAT") + 2 ) / 3
            nDOW := iif( nDOW == int( nDOW ), nDOW, 0 ) 
            if nDOW == 0
               break
            endif 
         endif 
      elseif valtype( xDOW ) == "N"
         if xDOW == int( xDOW ) .and. xDOW > 0 .and. xDOW < 8
            nDOW := xDOW
         else
            break
         endif 
      elseif ! valtype( xDOW ) == "U"
         break
      endif

      dDate += 45 - day( dDate ) 
      dDate -= day( dDate )

   dReturn := dDate - ;
      iif( nDOW > 0 , dow( dDate ) - nDOW, 0 ) - ;
      iif( ( nDOW > 0 ) .and. ( nDOW > dow( dDate ) ), 7, 0 )

   end sequence

   return dReturn
