*:*********************************************************************
*:
*: Procedure file: C:\CLIPPER5\HILL\KAL1.PRG
*:
*:         System: KALENDAR
*:         Author: DENNY K. FUSSELL
*:      Copyright (c) 1992, DENNY K. FUSSELL
*:  Last modified: 10/13/92     10:23
*:
*:  Procs & Fncts: KAL()
*:               : KALENDAR()
*:               : DC()
*:               : SHBOX()
*:               : DR_BOX()
*:               : LOM()
*:               : HPL
*:
*:      Documented 10/13/92 at 10:29                SNAP!  version 5.00
*:*********************************************************************
*!*********************************************************************
*!
*!       Function: KAL()
*!
*!          Calls: READVAR()          (function  in ?)
*!               : KALENDAR()         (function  in KAL1.PRG)
*!
*!*********************************************************************
FUNCTION kal
PRIVATE result, mdate, nday, fday, mbox, mnth, yre, yr, rw[6], cl[7],;
   clscr, clscra, clscrl, clscrl1, h_clr, mv1

PARAMETER trw, tcl
IF TYPE('trw') != 'N'
   trw := 2
   tcl := 46
ELSE
   IF trw > 8
      trw := 8
   ENDIF
   IF tcl > 48
      tcl := 48
   ENDIF
ENDIF

mv1 := readvar()

DO CASE
CASE TYPE("&mv1") = 'D'
   &mv1 := kalendar()
CASE TYPE("&mv1") = 'C'
   &mv1 := DTOC(kalendar())
OTHERWISE
   kalendar()
ENDCASE

*!*********************************************************************
*!
*!       Function: KALENDAR()
*!
*!      Called by: KAL()              (function  in KAL1.PRG)
*!
*!          Calls: SETCOLOR()         (function  in ?)
*!               : READVAR()          (function  in ?)
*!               : SAVESCREEN()       (function  in ?)
*!               : LOM()              (function  in KAL1.PRG)
*!               : SHBOX()            (function  in KAL1.PRG)
*!               : DC()               (function  in KAL1.PRG)
*!
*!*********************************************************************
FUNCTION kalendar
#INCLUDE "INKEY.CH"

local   calscr, c_clr, s, X, z, W, vli4, vli3, vli2, vlin

SAVE SCREEN TO calscr
c_clr := setcolor()
s := .F.
X := 1
z := 0
W := 0
WHILE .T.
   y := SUBSTR(c_clr,X,1)
   DO CASE
   CASE y = ',' .AND. s
      z := X
      EXIT
   CASE y = ',' .AND. !s
      s := .T.
      W := X + 1
   ENDCASE
   X = X + 1
   LOOP
ENDDO
h_clr := SUBSTR(c_clr,W,(z-W))
IF EMPTY(h_clr)
   h_clr := 'n/b'
ENDIF
IF TYPE('tdte') != 'D'
   tdte := readvar()
ENDIF
SET ESCAPE ON
STORE DATE() TO mdate
STORE DAY(mdate) TO nday
STORE nday-1 TO nday
STORE mdate - nday TO fday
STORE CDOW(fday) TO mbox
STORE MONTH(DATE()) TO mnth
yre := YEAR(mdate)
yr := yre
DECLARE rw[6],cl[7]
rw[1] = trw+3
rw[2] = trw+5
rw[3] = trw+7
rw[4] = trw+9
rw[5] = trw+11
rw[6] = trw+13
cl[1] = tcl+1
cl[2] = tcl+5
cl[3] = tcl+9
cl[4] = tcl+13
cl[5] = tcl+17
cl[6] = tcl+21
cl[7] = tcl+25
vli4 := ''
vli3 := 'Ŀ'
vli2 := 'Ĵ'
vlin := '                     '
clscr := savescreen(trw+12,tcl,trw+16,tcl+31)
IF (mbox = 'Friday' .AND. DAY(lom(fday)) = 31) .OR. (mbox = 'Saturday' .AND. DAY(lom(fday)) > 29)
   shbox(trw,tcl,trw+15,tcl+30)
   @trw+2,tcl+1 SAY vli3
   @trw+3,tcl+1 SAY vlin
   @trw+4,tcl+1 SAY vli2
   @trw+5,tcl+1 SAY vlin
   @trw+6,tcl+1 SAY vli2
   @trw+7,tcl+1 SAY vlin
   @trw+8,tcl+1 SAY vli2
   @trw+9,tcl+1 SAY vlin
   @trw+10,tcl+1 SAY vli2
   @trw+11,tcl+1 SAY vlin
   @trw+12,tcl+1 SAY vli2
   @trw+13,tcl+1 SAY vlin
   @trw+14,tcl+1 SAY vli4
   clscra := savescreen(trw+2,tcl,trw+11,tcl+31)
   clscrl := savescreen(trw+12,tcl,trw+15,tcl+31)
   clscrl1 := savescreen(trw+16,tcl+1,trw+16,tcl+31)
ELSE
   shbox(trw,tcl,trw+13,tcl+30)
   @trw+2,tcl+1 SAY vli3
   @trw+3,tcl+1 SAY vlin
   @trw+4,tcl+1 SAY vli2
   @trw+5,tcl+1 SAY vlin
   @trw+6,tcl+1 SAY vli2
   @trw+7,tcl+1 SAY vlin
   @trw+8,tcl+1 SAY vli2
   @trw+9,tcl+1 SAY vlin
   @trw+10,tcl+1 SAY vli2
   @trw+11,tcl+1 SAY vlin
   @trw+12,tcl+1 SAY vli4
   clscra := savescreen(trw+2,tcl,trw+11,tcl+31)
   clscrl := savescreen(trw+10,tcl,trw+13,tcl+31)
   clscrl1 := savescreen(trw+14,tcl+1,trw+14,tcl+31)
ENDIF
dc(rw,cl)
RESTORE SCREEN FROM calscr
tdte := result
RETURN tdte

*!*********************************************************************
*!
*!       Function: DC()
*!
*!      Called by: KALENDAR()         (function  in KAL1.PRG)
*!
*!          Calls: LOM()              (function  in KAL1.PRG)
*!               : RESTSCREEN()       (function  in ?)
*!               : SETCOLOR()         (function  in ?)
*!               : ENTER()            (function  in ?)
*!               : ESC()              (function  in ?)
*!               : HPL                (procedure in KAL1.PRG)
*!
*!*********************************************************************
FUNCTION dc

PARAMETERS rw,cl

local   mkey, vmrow, vmcol, hdr, mdg, grw, gcl, d_old

mkey = 0
DO WHILE .T.
   STORE MONTH(mdate) TO munth
   yre := YEAR(mdate)
   STORE DAY(mdate) TO nday
   STORE nday-1 TO nday
   STORE mdate - nday TO fday
   STORE CDOW(fday) TO mbox
   DO CASE
   CASE mbox = 'Sunday'
      MCOL = 1
   CASE mbox = 'Monday'
      MCOL = 2
   CASE mbox = 'Tuesday'
      MCOL = 3
   CASE mbox = 'Wednesday'
      MCOL = 4
   CASE mbox = 'Thursday'
      MCOL = 5
   CASE mbox = 'Friday'
      MCOL = 6
   CASE mbox = 'Saturday'
      MCOL = 7
   ENDCASE
   vmrow = 1
   vmcol = MCOL
   DO CASE
   CASE munth = 1
      hdr= 'January'
   CASE munth = 2
      hdr = 'February'
   CASE munth = 3
      hdr = 'March'
   CASE munth = 4
      hdr= 'April'
   CASE munth = 5
      hdr = 'May'
   CASE munth = 6
      hdr = 'June'
   CASE munth = 7
      hdr= 'July'
   CASE munth = 8
      hdr = 'August'
   CASE munth = 9
      hdr = 'September'
   CASE munth = 10
      hdr= 'October'
   CASE munth = 11
      hdr = 'November'
   CASE munth = 12
      hdr = 'December'
   ENDCASE
   STORE hdr+' '+TRIM(STR(YEAR(mdate))) TO hdr
   @trw-1,tcl CLEAR TO trw-1,tcl+30
   @ trw-1,tcl+15-(LEN(hdr)/2) SAY hdr
   IF munth != mnth .OR. yre != yr
      IF (mbox = 'Friday' .AND. DAY(lom(fday)) = 31) .OR. (mbox = 'Saturday' .AND. DAY(lom(fday)) > 29)
         restscreen(trw+2,tcl,trw+11,tcl+31,clscra)
         restscreen(trw+12,tcl,trw+15,tcl+31,clscrl)
         restscreen(trw+16,tcl+1,trw+16,tcl+31,clscrl1)
      ELSE
         restscreen(trw+2,tcl,trw+11,tcl+31,clscra)
         restscreen(trw+12,tcl,trw+16,tcl+31,clscr)
         restscreen(trw+10,tcl,trw+13,tcl+31,clscrl)
         restscreen(trw+14,tcl+1,trw+14,tcl+31,clscrl1)
      ENDIF
   ENDIF
   STORE munth TO mnth
   yr := yre
   DO WHILE .T.
      STORE STR(DAY(mdate)) TO mdg
      @trw+1,tcl+2 SAY 'SUN MON TUE WED THU FRI SAT'
      @rw[vmrow],cl[vmcol]+2 SAY VAL(SUBSTR(STR(DAY(fday)),2))
      IF STR(DAY(fday)) = mdg
         STORE rw[vmrow] TO grw
         STORE cl[vmcol] TO gcl
         STORE VAL(SUBSTR(STR(DAY(mdate)),2)) TO gdy
      ENDIF
      STORE vmcol+1 TO vmcol
      STORE fday+1 TO fday
      IF vmcol > 7
         STORE vmrow+1 TO vmrow
         vmcol = 1
      ENDIF
      IF vmrow > 6
         EXIT
      ENDIF
      IF MONTH(fday) != munth
         EXIT
      ENDIF
      LOOP
   ENDDO
   SET CURSOR OFF
   c_clr := setcolor(h_clr)
   @grw,gcl+2 SAY gdy
   setcolor(c_clr)
   ninkeycode := INKEY(0)
   mkey = ninkeycode
   DO CASE
   CASE mkey = 05
      STORE mdate-7 TO mdate
      LOOP
   CASE mkey = 24
      STORE mdate+7 TO mdate
      LOOP
   CASE mkey = 31
      d_old := VAL(SUBSTR(DTOC(mdate),7))-1
      mdate := CTOD(SUBSTR(DTOC(mdate),1,6)+SUBSTR(STR(d_old),-2))
      LOOP
   CASE mkey = 30
      d_old := VAL(SUBSTR(DTOC(mdate),7))+1
      mdate := CTOD(SUBSTR(DTOC(mdate),1,6)+SUBSTR(STR(d_old),-2))
      LOOP
   CASE mkey = 19
      STORE mdate-1 TO mdate
      LOOP
   CASE mkey = 04
      STORE mdate+1 TO mdate
      LOOP
   CASE mkey = 18
      STORE mdate-30 TO mdate
      mdate := mdate - (DAY(lom(mdate))-30)
      LOOP
   CASE mkey = 3
      mdate := mdate + (DAY(lom(mdate))-30)
      STORE mdate+30 TO mdate
      LOOP
   CASE enter()
      STORE mdate TO result
      EXIT
   CASE esc()
      STORE .T. TO result
      EXIT
   CASE mkey = 72 .OR. mkey = 104
      hpl()
      LOOP
   ENDCASE
ENDDO
RETURN result


*!*********************************************************************
*!
*!       Function: SHBOX()
*!
*!      Called by: KALENDAR()         (function  in KAL1.PRG)
*!               : HPL                (procedure in KAL1.PRG)
*!
*!          Calls: DR_BOX()           (function  in KAL1.PRG)
*!               : SETCOLOR()         (function  in ?)
*!
*!*********************************************************************
FUNCTION shbox
PARAMETERS tr, tc, BR, bc, box_no, hdr

IF TYPE("box_no") != "N"
   box_no = 03                        && see DRAW_BOX() for string
ENDIF

tr = MAX( 01, tr )                    && make params honest
tc = MAX( 01, tc )
BR = MIN( 22, BR )
bc = MIN( 78, bc )
BR = IF(!EMPTY(hdr), BR + 01, BR)     && make room for the header
*IF(TYPE( "nml" ) = 'U',SYSCOLOR(1),SETCOLOR(nml))
dr_box(tr, tc, BR, bc, box_no)
*IF !EMPTY(hdr)
*IF(TYPE( "hlt" ) = 'U',SYSCOLOR(2),SETCOLOR(hlt))
*@ tr + 1, tc + 1 SAY MIDDLE( hdr, bc - tc - 1)
*IF(TYPE( "nml" ) = 'U',SYSCOLOR(1),SETCOLOR(nml))
*ENDIF


* paint in the black shadow

IF TYPE("monochrome") = "U"
   monochrome = .F.
ENDIF

SHADOW = IF(monochrome, "", " ")    && or "" or ""
cur_color = setcolor( "W/N+" )
@ tr + 1, bc + 1, BR + 1, bc + 1 BOX SHADOW
@ BR + 1, tc + 1, BR + 1, bc + 1 BOX SHADOW
setcolor(cur_color)

RETURN .T.



*!*********************************************************************
*!
*!       Function: DR_BOX()
*!
*!      Called by: SHBOX()            (function  in KAL1.PRG)
*!
*!*********************************************************************
FUNCTION dr_box
PARAMETERS TOP, LEFT, BOTTOM, RIGHT, border_no, clear_scr
PRIVATE boxchars, bptr, box_str

IF TYPE("Border_no") != "N"
   border_no = 11
ENDIF

boxchars = "ĿͻȺ͸ԳķӺ"+;
   "۲ĿԳ        "+;
   "³Գ"
bptr = (border_no - 01) * 08 + 01
box_str = SUBSTR(boxchars, bptr, 08)

IF TYPE("Clear_scr") != "U"      && pass anything to clear screen
   CLEAR
ENDIF

IF border_no != 0
   SCROLL(TOP, LEFT, BOTTOM, RIGHT, 0)     && clear box
   @ TOP,LEFT,BOTTOM,RIGHT BOX box_str
ENDIF

RETURN .T.


*!*********************************************************************
*!
*!       Function: LOM()
*!
*!      Called by: KALENDAR()         (function  in KAL1.PRG)
*!               : DC()               (function  in KAL1.PRG)
*!
*!*********************************************************************
FUNCTION lom

PARAMETER dte

PRIVATE nmnth,tyr
IF TYPE("dte") != 'D'
   dte := DATE()
ENDIF

nmnth := MONTH(dte)
tyr := YEAR(dte)
IF(nmnth = 12,tyr := (tyr + 1),tyr := tyr)
IF(nmnth = 12,nmnth := 01,nmnth := (nmnth + 1))
tyr := SUBSTR(STR(tyr),-2)
nmnth := SUBSTR(STR(nmnth),-2)
ndte  := (CTOD(nmnth+'/'+'01'+'/'+tyr)) - 1

RETURN ndte

*!*********************************************************************
*!
*!      Procedure: HPL
*!
*!      Called by: DC()               (function  in KAL1.PRG)
*!
*!          Calls: SAVESCREEN()       (function  in ?)
*!               : SHBOX()            (function  in KAL1.PRG)
*!               : RESTSCREEN()       (function  in ?)
*!
*!*********************************************************************
FUNCTION hpl
hlpscr := savescreen(2,5,14,34)
shbox(2,5,13,33)
@3,6 SAY 'Left arrow - 1 day back'
@4,6 SAY 'Right arrow - 1 day forward'
@5,6 SAY 'Up arrow - 1 week back'
@6,6 SAY 'Down arrow - 1 week forward'
@7,6 SAY 'PGUP - 1 month back'
@8,6 SAY 'PGDN - 1 month forward'
@9,6 SAY 'CTL-PGUP 1 year back'
@10,6 SAY 'CTL-PGDN 1 year forward'
@11,6 SAY 'ENTER - input date'
@12,6 SAY 'ESC - exit'

INKEY(5)

restscreen(2,5,14,34,hlpscr)
RETURN nil

*: EOF: KAL1.PRG
