	PAGE	,132
	NAME    ISPRINT
;************
;
;	ISPRINT2.asm
;
;	This file contains demonstration programs using the 
;	CLIPPER assembly interface.
;
;	Function source.....
;
;		ISPRINTER()

	INCLUDE	EXTENDA.INC


;***************
;
;	define segment names
;
	CODESEG	ISPRINT2
	DATASEG


;***************
;
;	declaration of public functions
;
	CLpublic <ISPRINTER>

;***************
;
;	Static data
;
	CLstatic <long nbuff 0>

	; storage for full pathname and pointer to address it
	CLstatic <byte ASCIIZ <<64 DUP(0)>>, cptr PATH ASCIIZ>



;***************
;
;	Equates
;

$define FALSE			0000H
$define TRUE			0001H


;*******
;
;	ISPRINTER()
;
;	CAUTION:  this routine works only on IBM-PC BIOS-compatibles!
;
;	Logical true if the printer is online and ready, otherwise false.
;
;	status = ISPRINTER()
;
;		status  -   logical.
;
;	Placed in the public domain by Tom Rettig Associates.
;
	; function declaration
	; return types include void, char, int, long, double, date, and log

 CLfunc log ISPRINTER <int lpt_no>

 CLcode
    mov di, false       ; Initialise return value to false.
    cmp PCOUNT, 1       ; Verify parameter count.

    jne isprt0
    cmp lpt_no, 2       ; Verify printer number (0-2) and
    jg  isprt0          ; return if out of bounds.

    ; Save registers.
    push     ax
    push     dx

    mov dx, lpt_no      ; Store printer to get status from.
    mov ah, 2           ; Store service number.
    int 17h             ; Call printer status interrupt.

    mov di, false       ; Initilize return to false.
    cmp ah, 90h         ; If printer not selected or not ready
    jne isprt1          ; return.
    mov di, true        ; Set return value to true.

 isprt1:
    ; Restore registers.
    pop     dx
    pop     ax

 isprt0:
    CLret   di          ; Return from Isprinter.


	; end of assembly
		END

; eof isprint2.asm

