*****************************************************************************
*
*  idx.prg
*
*  This program demonstrates the indexer() fuction
*
*  Written by Will Cattell
*
*

private talk_on      && Set talk on - used in place of dbase's 
*                    &&    SET TALK ON/OFF command
*
*                    && The private statement creates a memory variable 
*                    && whose data type is implictly logical and  whose
*                    && value is false


@ 0,0 clear

?
?  "  Building a Character Index with the INDEXER function in it and"
?  "  displaying the record count while the index is being built"
?
wait "Press any key to start"

store .t.   to talk_on      && Display the record number while indexing
select 0
use file0001
index on upper( file0001->lastname );
         + upper( file0001->firstname );
         + indexer( 23, 30 );
      to lastname


@ 0,0 clear
?
?  "  List records of the database with the display in indexer() active"
?
wait "Press any key to start"

do dsp_list    && Display the records in a list fashion


@ 0,0 clear
?
?  "  List records of the database with the display in indexer() turned off"
?
wait "Press any key to start"

store .f.   to talk_on      && Do not display the record number any more

do dsp_list    && Display the records in a list fashion

close database
return


function indexer
*
*  Displays the record number while indexing
*
*  This function must be embedded in a CHARACTER index expression.
*
*  To activate the record number display:
*     store .t. to  talk_on
*
*  Otherwise:
*     store .f. to  talk_on;
*     or leave talk_on undefined
*
*  WARNING: Whenever you embed INDEXER() in an index, the function
*  is executed everytime the index is referenced.
*  
*  Index files are accessed whenever they are referenced in the USE
*     SET INDEX, INDEX ON or SET ORDER TO commands and whenever your 
*     application performs file IO ( SEEKs, REPLACEs, GOTOs, etc.)
*
*
   parameters  parm_row,;    && The row to display the recno()
               parm_col      && The column to display the recno()

   if pcount() = 2                     && All parameters were passed
      if type( "parm_row" ) = "N";     && The row parameter is numeric
      .and. type( "parm_col" ) = "N";  && The column parameter is numeric
      .and. type( "m->talk_on" ) = "L" && Set talk on variable has been set
         if m->talk_on                 &&    and is on
            @ parm_row,parm_col  say "Record: "
            @ parm_row,col()     say recno()
         endif
      endif
   endif

return ""                  && Since you must return something
*                          &&    return a null value.



procedure dsp_list
*
*  Display the records in a list fashion
*
   select file0001
   goto top

   do while .not. eof()
      @ 6,0 clear
      store 1 to loop_cnt
      do while m->loop_cnt <= 10 .and. .not. eof()
         @ row()+1,10   say recno()
         @ row(),col()+1   say file0001->lastname
         @ row(),col()+1   say file0001->firstname

         store m->loop_cnt + 1 to loop_cnt

         select file0001
         skip +1
      enddo
      wait
   enddo
return
*****************************************************************************

