**************************************************************************
*                                                                        *
*           Program Name: INDEXER.PRG                                    *          
*                                                                        *
**************************************************************************
*                                                                        *
* Created: 6/27/1988 at 12:11                                            *        
*                                                                        *
* Revision: 1.2           Last Revised: 6/27/1988 at 12:46               *
*                                                                        *
*                         M O D   L O G                                  *
*                                                           *
* Rev.      Date        Author         Description                       *
*                                                                        *
* 1.0                                  Original version of INDEXER() as  *
*                                      it appeared in Vol 1, Issue 1 of  *
*                                      the Data Based Forum News, last   *
*                                      page, right column.               *
*                                                                        *
* 1.1       6/27/88     M. Ostroff     Fix INDEXER function so that it   *
*                                      doesn't get "data type mismatch"  *
*                                      errors when used with non-string  *
*                                      index expressions.                *
*                                                                        *
* 1.2       6/27/88     M. Ostroff     Enhance INDEXER message string to *
*                                      optionally show % completion      *
*                                      based on total number of records  *
*                                      in indexed database.              *
*                                                                        *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                        *
* Calling Set Up                                                         *
*                       MUST define the following variables in the       *
*                       program which calls the INDEXER() function:      *
*                                                                        *
*                       TALK = Controls whether the index progress       *
*                              string is displayed. Set TALK to .T.      *
*                              before indexing, then set it to .F.       *
*                              after you are done. (Otherwise, will      *
*                              continue to see the progress string       *
*                              EVERY time you access the database.)      *
*                                                                        *
*                       RTN_TYPE = This is a single-character string     *
*                                  for holding a letter code which       *
*                                  designates the TYPE of index express. *
*                                  being used. Use "S" for string, "D"   *
*                                  for date, "N" for numeric, and "L"    *
*                                  for logical. If undefined, INDEXER()  *
*                                  sets RTN_TYPE to "S".                 *
*                                                                        *
*                                                                        *
*                                                                        *
*                       WARNING - If RTN_TYPE is not defined correctly,  *
*                                 your program will crash with a "data   *
*                                 type mismatch" error when it tries to  *
*                                 index a file. The entire program will  *
*                                 abort back to DOS, and NO data that is *
*                                 contained in temporary memory buffers  *
*                                 is written to disk.                    *
*                                                                        *
*                                 IN OTHER WORDS, make SURE that your    *
*                                 program forces a data write of all     *
*                                 buffers BEFORE it indexes anything.    *
*                                                                        *
*                                                                        *
* Calling Parameters                                                     *
*                       Call the function in one of two ways:            *
*                                                                        *
*                       INDEX ON expr+INDEXER(row,col,numrecs) TO file   *
*                                         or                             *
*                       INDEX ON expr+INDEXER(row,col) TO file           *
*                                                                        *
*                                                                        *
*                       where    row = the row number where the message  *
*                                      string is to appear               *
*                                col = the column number where the       *
*                                      message string is to appear       *
*                                numrecs = the number of total records   *
*                                          in the database being indexed *
*                                                                        *
*                       (All 3 parameters are numerics.)                 *
*                                                                        *
*                       If the first form of INDEXER is used (ie,numrecs *
*                       is supplied), the message string will be:        *
*                                                                        *
*                            xxx records indexed -  xx% completed        *
*                                                                        *
*                                                                        *
*                       If the second form is used (ie, only row & col   *
*                       are supplied), the message string will be:       *
*                                                                        *
*                            Indexing Record: xxx                        *
*                                                                        *
*                                                                        *
**************************************************************************
*
FUNCTION INDEXER

   PARAMETERS row,col,numrecs

   IF TYPE("rtn_type") = "U"
      rtn_type = "S"
   ELSE
      rtn_type = UPPER(rtn_type)
   ENDIF

   DO CASE
      CASE pcount() >= 3
         full = .T.
         percnt = TRANSFORM(ROUND((RECNO()/numrecs)*100,0),"999")
      CASE pcount() < 2
         full = .F.
         store 1 to row,col
      OTHERWISE
         full = .F.
   ENDCASE

   IF TYPE("talk") = "U"
      talk = .f.
   ENDIF

   IF talk
      IF full
         @ row,col SAY TRANSFORM(RECNO(),"999999")+" records indexed - "+percnt+"% completed"
      ELSE
         @ row,col SAY "Indexing Record: "+TRANSFORM(RECNO(),"999999")
      ENDIF
   ENDIF
*
*  Make sure that we return a non-value of a type compatable 
*  with the index expression type being used.
*
   DO CASE
      CASE rtn_type = "D"
         RETURN(CTOD("  /  /  "))
      CASE rtn_type = "N"
         RETURN(0)
      CASE rtn_type = "L"
         RETURN(.T.)
      OTHERWISE
         RETURN("")
   ENDCASE
