*  BOF: INC.PRG

*  FILE.......: INC.PRG
*  AUTHOR.....: Berend Tober
*  CIS id #...: 70541,1030
*  DATE.......: Thu  94/11/10 12:00:16

*
* This is an original work by Berend M. Tober
* and is placed in the public domain.
*

#include "common.ch"

#ifdef FT_TEST

#define EOL chr(10)+chr(13)

procedure t_inc()
   local bTest := {|x,n|qout("(", x,", ",n,") --> ", Inc( x, n ))}
   cls

   qout( EOL,"Numerical:")
   eval( bTest, 1,  1)
   eval( bTest, 1,  2)
   eval( bTest, 1, -1)
   eval( bTest, 1, -2)

   qout(EOL,"Date")
   eval( bTest, date(),  1)
   eval( bTest, date(),  2)
   eval( bTest, date(), -1)
   eval( bTest, date(), -2)

   qout(EOL,"Character")
   eval( bTest, "a",  1)
   eval( bTest, "a",  2)
   eval( bTest, "a", -1)
   eval( bTest, "a", -2)

   qout(EOL,"Boolean")
   eval( bTest, .t.,  1)
   eval( bTest, .t.,  2)
   eval( bTest, .t., -1)
   eval( bTest, .t., -2)

   return

#endif

************************************ Inc() *************************************
FUNCTION Inc( xVal, nInc )
   LOCAL cType := VALTYPE( xVal )
   DEFAULT nInc TO 1
   DO CASE
   CASE cType == "N"
      xVal += nInc

   CASE cType == "D"
      xVal += nInc

   CASE cType == "C"
      xVal := STUFF( xVal, LEN( xVal ), 1, CHR( nInc+ASC(RIGHT( xVal, 1 ))))

   CASE cType == "L"
      xVal := !xVal

   OTHERWISE
      ALERT("INC: Non-supported data type")

   ENDCASE
   RETURN xVal
*  end of Inc()

************************************ Dec() *************************************
FUNCTION Dec( xVal, nInc )
   DEFAULT nInc TO 1
   RETURN Inc( xVal, -nInc)
*  end of Dec()

* EOF: INC.PRG
