// -------------------------------------------------------------------
//
//  Call Inc_Look_Up(TRow, BRow, LCol, RCol)
//
//  TRow  --- Top Row
//  BRow  --- Bottom Row
//  LCol  --- Left Column
//  RCol  --- Right Column
//
//  You need to open the DataBase where you want to do the LookUp
//  Make sure that you have INDEXes for the fields where you need
//  to do the search on.
//  
//  The following variables need to be defined (you can increase
//  the size of the arrays or make these dynamic by using ASIZE)
//
//  PUBLIC  fnames[2], titles[2], indexes[2], pics[2]
//
//  fnames  --->  Field Names
//  titles  --->  Field Titles
//  indexes --->  INDEX files used
//  pics    --->  PICTUREs used for the fields
//
//  Take a good look at the sample code which I hope will answer
//  all the questions. If the code doesn't, leave me a message 
//  in the 'Orlando Silver Bullet BBS'
//
//  Make sure to INDEX using the UPPER() function, this function
//  converts everything to upper case
//
//  Manny Celi
//
FUNCTION Test()

PRIVATE  fnames[2], titles[2], indexes[2], pics[2]

CLS

USE customer
INDEX ON UPPER(compname) TO compname
INDEX ON UPPER(compnumb) TO compnumb
SET INDEX TO compname, compnumb

fnames[1]   := "LEFT(customer->compname, 30)"
fnames[2]   := "customer->compnumb"
indexes[1]  := 1
indexes[2]  := 2
titles[1]   := "Company Name"
titles[2]   := "Company Code"
pics[1]     := "@X"
pics[2]     := "!!!!!"

  // -------------------------------------------
  //  Inc_Look_Up will return FALSE if the ESC
  //  key was pressed.
  //  Otherwise, you can do whatever you want
  // -------------------------------------------
  //              T   B   L   R
  IF Inc_Look_Up( 5, 18, 10, 60)
     IF Input_Var == "TPLAINTIFF"
        Comp_Name := customer->compname
     ELSE
        Comp_Numb := customer->compnumb
     ENDIF
  ENDIF
  customer->(DBCLOSEAREA())
  // -------------------------------------------

RETURN NIL
// -------------------------------------------------------------------
//  All the Code above this message is a sample on how to use
//  these functions. I kept most of the original code written by
//  Galen Mulrooney, based on code written by Robert Kohut but made it
//  a little easier to integrate to an application without having
//  to do what I did.
//
//  All you need to do is delete the above code and use the functions
//  as they are.
//
//  It's a great function that does impress people and all the credit
//  is given to the authors (I don't know them), Galen Mulrooney & 
//  Robert Kohut.
//
//  Manny Celi - 09/09/92
//
// -------------------------------------------------------------------


// -------------------------------------------------------------------
//  FUNCTION Inc_Look_Up(TRow, BRow, LCol, RCol)
//
//  Generic DBEDIT Window for Incremental Look_Ups
//  ie. Type "P" and gets first occurance w/P, next type "E"
//      gets 1st occurance with "PE", etc....
//
// --------------------------------------------------------------------
FUNCTION Inc_Look_Up(TRow, BRow, LCol, RCol)

LOCAL   Win_buffer
PRIVATE TopRow, BottRow, LeftCol, RightCol

SET DELETED ON
SET FUNCTION 10 TO CHR(23)         && Ctrl-W.
SET SCOREBOARD OFF

TopRow      := TRow
BottRow     := BRow
LeftCol     := LCol
RightCol    := RCol
Win_buffer  := SAVESCREEN( 0, 0, 24, 79)

IF ISCOLOR()
     xbrowse    := "N/BG,W+/B"
     xerror     := "GR+/R,N/R"
     xinfo      := "GR+/B"
     xnormal    := "W+/B,W+/R,,,N/W"
ELSE
     xbrowse    := ""
     xerror     := ""
     xinfo      := ""
     xnormal    := ""
ENDIF

SET COLOR TO (xbrowse)
shadbox( TopRow, LeftCol-2, BottRow, RightCol+2)
bline23()

NewField    := .F.
EntryStr    := ""
BottomScrn  := SAVESCREEN(BottRow+1, 27, BottRow+5, 52)

DBEDIT(TopRow, LeftCol, Bottrow, RightCol, fnames, "genfunc", pics, titles, .T., .T., "")

RESTSCREEN( 0, 0, 24, 79, Win_Buffer)

SET COLOR TO &PNORMAL
IF LASTKEY() == 27
   RETURN .F.
ENDIF

RETURN .T.
// --------------------------------------------------------------------
FUNCTION genfunc(Mode, FldPtr)
// --------------------------------------------------------------------
//     by Galen Mulrooney, based on code written by Robert Kohut.
//     Released to Public Domain for the furtherment of the Clipper 
//     Language and its devotees.  12/9/1990.
//
//   Generic Function to use for DBEDITS.
//   The following Keys are active:
//        ESC = Exit
//        INS, F2, Del, Enter call &Boxname
//   The following PUBLIC Variables are REQUIRED:
//        Boxname (name of function to call when INS, Del, Enter, or F2 
//             key is pressed.  Boxname will called with PARAMETER "A", ".",
//             "E", or "2", respectively.
//             Function must return DBEDIT Return Value.
//        Indexes is an array with the same number of elements as there are
//             fields being dBEDITed.  Each element must contain the Index number
//             that must be active for seeks on that field; or 0 if not indexed.
//        fnames[] must be the name of the array hoding the field names.
//        The bottom portion of the screen MUST be saved into BottomScrn (21,27,24,52)
//        EntryStr MUST be initialized to ""
//        TopRow is the top row coordinate of dBEDIT.
//        BottRow is the bottom row coordinate of dBEDIT.
//        NewField MUST = .F.
//        DELETED SHOULD BE SET ON
// --------------------------------------------------------------------

LKey      := LASTKEY()
CurFld    := fnames[FldPtr]
EntryLen  := Len(EntryStr)
RetVal    := 1

IF LKey == 27 .OR. LKey == 23       && ESCape. or Ctrl-W
   RETURN 0
ENDIF

IF INDEXORD() != indexes[FldPtr]                             && Proper index not active
   IF indexes[FldPtr] # 0                                    && This field is indexed
      SET ORDER TO indexes[FldPtr]                           && Set index order to proper index
      NewField := .T.                                        && NewField is used to re-paint the screen when passing the top or bott of screen.
   ENDIF
   EntryStr := ""                                            && Reset Entry String
   EntryLen := 0
   RESTSCREEN(BottRow+1, 27, BottRow+5, 52, BottomScrn)                      && Erase Box
ENDIF

IF Mode == 1
   err(" Top-of-file ... no more Records in this direction ")
   RETURN 1
ENDIF

IF Mode == 2
   err(" Bottom-of-file ... no more Records in this direction ")
   RETURN 1
ENDIF

IF Mode == 3
   err(" No records were found.  If this is incorrect, try re-indexing. ")
   RETURN 1
ENDIF

IF Mode == 0
   IF (LKey==5 .OR. LKey==24 .OR. LKey==18 .OR. LKey==3 .OR. LKey == 30 .OR. LKey == 31) .AND. EntryLen > 0    && ,,PgUp,PgDn,Ctrl-PgUp,Ctrl-PgDn
      EntryStr := ""                               && Reset Entry String
      EntryLen := 0
      RESTSCREEN(BottRow+1, 27, BottRow+5, 52, BottomScrn)       && Erase Box
   ENDIF
   IF LKey == 5 .AND. ROW() == TopRow+2 .AND. NewField
      NewField  := .F.
      RetVal    := 2
   ELSEIF LKey == 24 .AND. ROW() == BottRow-1 .AND. NewField
      NewField  := .F.
      RetVal    := 2
   ENDIF
ENDIF

IF Mode == 4                                       && Exception
   IF LKey = -1                                    && F2
      EntryStr = ""                                && Reset Entry String
      RESTSCREEN(BottRow+1, 27, BottRow+5, 52, BottomScrn)           && Erase Box
      RETURN 2
   ENDIF

   IF LKey == 13                                   && Enter
      EntryStr  := ""                              && Reset Entry String
      RESTSCREEN(BottRow+1, 27, BottRow+5, 52, BottomScrn)           && Erase Box
      RETURN 0
   ENDIF
   *
   *    EntryString Processing
   *
   IF LKey == 8  .AND. INDEXORD() == indexes[FldPtr]        && Backspace
      EntryStr := LEFT(EntryStr, EntryLen-1)
   ELSEIF ((LKey>32 .AND. LKey<127) .OR. (LKey==32 .AND. EntryLen>0)) .AND. INDEXORD() == indexes[FldPtr]
   *  (Search Characters AND this field is indexed)
      EntryStr  := EntryStr + UPPER(CHR(LASTKEY()))
      PresRec   := RECNO()
      SEEK EntryStr
      IF ! FOUND()
         TONE(125,0)
         EntryStr := LEFT(EntryStr, EntryLen)
         GOTO PresRec
      ELSE
         IF LEN(EntryStr) == 1
            RetVal := 2
            shadbox(BottRow+3, 27, BottRow+4, 51, "", "S")
         ENDIF
      ENDIF
   ELSE
      TONE(125,0)
   ENDIF
ENDIF

IF LEN(EntryStr) > 0
   @ BottRow+3, 30 SAY SPACE(20)
   @ BottRow+3, 30 SAY EntryStr
ELSE
   RESTSCREEN(BottRow+1, 27, BottRow+5, 52, BottomScrn)
ENDIF

RETURN RetVal
// --------------------------------------------------------------------
FUNC shadbox(t, l, b, r, ParaColor, OutLine)
// --------------------------------------------------------------------
//   Produces Shadow Box.  Placed in Public Domain by Robert Kohut.
//

PRIVATE OldColor, Mask
OldColor  := SETCOLOR()
Mask      := REPL("X",79)

//---   Shade the area below the box
Shadow := SAVESCREEN(b+1,l+1,b+1,r+1)
Shadow := TRAN(Shadow,LEFT(Mask,LEN(Shadow)))
RESTSCREEN(b+1,l+1,b+1,r+1,Shadow)

//---   Shade the area to the right of the box
Shadow := SAVESCREEN(t+1,r+1,b+1,r+1)
Shadow := TRAN(Shadow,LEFT(Mask,LEN(Shadow)))
RESTSCREEN(t+1,r+1,b+1,r+1,Shadow)

//---  do the box
IF PCOUNT() > 4
   IF LEN(ParaColor) > 0
      SETCOLOR(ParaColor)
   ENDIF
ENDIF
SCROLL(t, l, b, r, 0)
IF PCOUNT() == 6
   IF OutLine == "D"
      @ t-1, l+1 TO b, r-1 double
   ELSEIF OutLine == " "
      @ t-1, l+1 clea to b, r-1
   ELSE
      @ t-1, l+1 TO b, r-1
   ENDIF
ELSE
   @ t-1, l+1 TO b, r-1
ENDIF
SETCOLOR(OldColor)
RETURN .T.
// --------------------------------------------------------------------
FUNCTION bline23()
// --------------------------------------------------------------------

PRIVATE OldColor

OldColor := SETCOLOR()
SET COLOR TO (xinfo)

@ 23, 00 CLEAR TO 23,79
@ 23,25 SAY "<ESC>"
@ 23,38 SAY "<ENTER>"

SET COLOR TO (xnormal)
@ 23,31 SAY "EXIT"
@ 23,46 SAY "Pick"

SET COLOR TO (OldColor)

RETURN
// --------------------------------------------------------------------
FUNC err       &&  Prints error message
// --------------------------------------------------------------------
PARA msg
PRIVATE rw, OldLine24, OldColor

rw        := (80 - LEN(msg)) / 2
OldColor  := SETCOLOR()
OldLine24 := SAVESCREEN(24, 00, 24, 79)
TONE(225, 2)
SET COLOR TO (xerror)
@ 24, rw SAY msg
INKEY(0)
KEYBOARD ""        && This is kludgy way of making sure that LASTKEY() isn't
INKEY(0)            && affected by whatever key the user hits to exit this message.
SET COLOR TO (OldColor)
RESTSCREEN(24, 00, 24, 79, OldLine24)
RETURN .F.
*
*    end err
*
// --------------------------------------------------------------------

