* file testhand.prg

clear
t = handles()
do csay with 1,"Handle Expansion Test"
do csay with 3,"Number of file handles used:" + str(handcnt(),4)
nfiles = 30
@ 5,20 say "Enter number of files to open: " get nfiles pict "999"
read
if lastkey() = 27
   return
endif
?
for ix = 1 to nfiles
   s = strzero(ix,2)
   use test
   f = "temp" + s
   copy to &f
   use &f
   index on testfield to &f
   use 
   ? "File " + f + " opened. "
next
?
wait
for ix = 1 to nfiles
   s = strzero(ix,2)
   select &s
   f = "temp" + s
   use &f index &f
   append blank
   replace testfield with f
   ? "Record written to file " + f + "  handles used: " + str(handcnt(),3) + "  memory: " + str(memory(0))
next
?
wait
for ix = 1 to nfiles
   s = strzero(ix,2)
   select &s
   use
   f = "temp" + s + ".dbf"
   ? "File " + f + " closed"
next
?
wait
return

procedure csay
parameters x,s
@ x,0
@ x,(80-len(s))/2 say s
return


FUNCTION STRZERO
* Syntax: STRZERO( <expN>, [<length> [,<decimals>]] )
* Return: The STR() of <expN> with leading zeros instead of blanks
*
PARAMETERS cl_num, cl_len, cl_dec
PRIVATE cl_str
DO CASE
   CASE TYPE("cl_dec") # "U"
      cl_str = STR(cl_num,cl_len,cl_dec)
   CASE TYPE("cl_len") # "U"
      cl_str = STR(cl_num,cl_len)
   OTHERWISE
      cl_str = STR(cl_num)
ENDCASE
IF "-" $ cl_str    && negative number
   * Move the minus sign to appear in front of the zeros.
   RETURN "-" + REPLICATE( "0", LEN(cl_str)-LEN(LTRIM(cl_str)) ) +;
                SUBSTR( cl_str, AT("-",cl_str)+1 )
ELSE   && positive number
   RETURN REPLICATE( "0", LEN(cl_str)-LEN(LTRIM(cl_str)) ) + LTRIM(cl_str)
ENDIF
