PAGE    60,132
        TITLE   HANDPROC - Handle table utility functions

; HANDCNT()  - RETURNS NUMBER OF ACTIVE HANDLES
; HANDSIZ()  - RETURNS SIZE OF HANDLE TABLE
; HANDVAL(n) - RETURNS HANDLE TABLE ENTRY FOR HANDLE n, 0 <= n < HTABLEN

        PUBLIC  HANDCNT,HANDSIZ,HANDVAL
        EXTRN   __RETNI:FAR,__PARNI:FAR,HAND_AD:FAR

_PROG   SEGMENT 'CODE'
        ASSUME  CS:_PROG

HANDCNT PROC    FAR                     ; RETURN NUMBER OF ACTIVE HANDLES
        PUSH    BP
        PUSH    DS
        PUSH    ES
        PUSH    SI
        PUSH    DI
        CALL    HAND_AD                 ; RETURNS: DS:SI - HANDLE TABLE POINTER               
        XOR     AX,AX                   ;          CX    - TABLE LENGTH
        MOV     DL,0FFH
HCNTLP:
        CMP     BYTE PTR [SI],DL        ; INACTIVE (UNUSED) HANDLES HAVE A
        JZ      HCNT1                   ; HANDLE TABLE VALUE OF 0FFh.
        INC     AX
HCNT1:                                  ; COUNT THE TABLE ENTRIES WHICH
        INC     SI                      ; ARE NOT EQUAL TO 0FFH.
        LOOP    HCNTLP
        POP     DI
        POP     SI
        POP     ES
        POP     DS
        POP     BP
        PUSH    AX
        CALL    __RETNI
        ADD     SP,2
        RET
HANDCNT ENDP

HANDSIZ PROC    FAR                     ; RETURNS SIZE OF HANDLE TABLE
        PUSH    BP
        PUSH    DS
        PUSH    ES
        PUSH    SI
        PUSH    DI
        CALL    HAND_AD                 ; HANDLE TABLE SIZE RETURNED IN CX
        POP     DI
        POP     SI
        POP     ES
        POP     DS
        POP     BP
        PUSH    CX
        CALL    __RETNI
        ADD     SP,2
        RET
HANDSIZ ENDP

HANDVAL PROC    FAR                     ; RETURNS HANDLE TABLE ENTRY FOR
        PUSH    BP                      ; THE PASSED HANDLE NUMBER
        MOV     BP,SP
        PUSH    DS
        PUSH    ES
        PUSH    SI
        PUSH    DI
        MOV     AX,1                    ; GET THE PASSED HANDLE IN AX
        PUSH    AX
        CALL    __PARNI
        ADD     SP,2
        PUSH    AX                      ; SAVE IT TEMPORARILY
        CALL    HAND_AD                 ; DS:SI IS HANDLE TABLE POINTER
        POP     BX                      ; TABLE ENTRY TO RETRIEVE
        CMP     BX,CX                   ; SEE IF OUT OF RANGE
        JBE     VAL1                   
        MOV     AL,0FFH                 ; IF OUT OF RANGE, RETURN 0FFh.
VAL1:
        MOV     AL,[BX][SI]
        MOV     AH,0
        POP     DI
        POP     SI
        POP     ES
        POP     DS
        POP     BP
        PUSH    AX
        CALL    __RETNI
        ADD     SP,2
        RET
HANDVAL ENDP

_PROG   ENDS
        END
        
