*****************************************************************************
*
* Program Name : sauvalid
*
* Written By   : David L. Collison
* Written On   : December 09, 1989
*
* Updated By   : David L. Collison
* Updated On   : December 09, 1989
*
* Copyright    : Copyright (c), 1989 - Executive Assist
*
* Description  : This program contains all validation functions that will
*                be used in the sample edit system.
*
* Files Used   :
*
* Prg's Called :
*
* Parameters   :
*
*****************************************************************************

*****************************************************************************
*
* Function Name : sav_user
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will validate the existence of a user record
*                 and optionally create the record if the userd does not
*                 exist, if the user does exist, the information from the
*                 current record will be stored to the edit variables.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_USERNO - Numeric - Member number to validate.
*                 P_EDITOP - Numeric - Type of edit being performed.
*                                      1 - Add
*                                      2 - Display
*                                      3 - Modify
*                                      4 - Remove
*
*****************************************************************************

FUNCTION SAV_USER

   PARAMETERS P_USERNO, P_EDITOP

   PRIVATE M_SELECT

   M_SELECT = SELECT()

   IF SELECT ( 'CLIPUSER' ) > 0

      SELECT CLIPUSER

   ELSE

      SELECT 0
      MM_DFOPN ( 'CLIPUSER', .F. )
      SET INDEX TO CLIPUSER

   ENDIF

   SEEK P_USERNO

   DO CASE
      CASE P_EDITOP = 1 .AND. .NOT. EOF()

         MM_UTMSG ( 'THIS USER NUMBER CURRENTLY EXISTS . . . ANY KEY TO RETRY ' )

         RETU ( .F. )

      CASE P_EDITOP <> 1 .AND. EOF()

         MM_UTMSG ( 'THIS USER NUMBER DOES NOT EXIST . . . ANKY KEY TO RETRY ' )

         RETU ( .F. )

      CASE P_EDITOP = 1 .AND. EOF()

         MM_LKFIL ()

         APPEND BLANK
         REPLACE MENUMBER WITH P_USERNO

         MM_LKFUN ()

   ENDCASE

   M_MEFRSTNM = MEFRSTNM
   M_MEMIDDLE = MEMIDDLE
   M_MELASTNM = MELASTNM
   M_MEADDRS1 = MEADDRS1
   M_MEADDRS2 = MEADDRS2
   M_MECITYNM = MECITYNM
   M_MESTATID = MESTATID
   M_MEZIPCOD = MEZIPCOD
   M_MEPHONNO = MEPHONNO
   M_MEBUSNES = MEBUSNES
   M_MEBADDR1 = MEBADDR1
   M_MEBADDR2 = MEBADDR2
   M_MEBCITYN = MEBCITYN
   M_MEBSTATE = MEBSTATE
   M_MEBZIPCD = MEBZIPCD
   M_MEBPHONE = MEBPHONE
   M_MEBEXTEN = MEBEXTEN
   M_MEDTJOIN = MEDTJOIN
   M_MEDUESPD = MEDUESPD

   SELECT ( M_SELECT )

RETURN ( .T. )

*****************************************************************************
*
* Function Name : sav_stat
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will validate the state id entered by user.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_STATID - Character - State id being validated.
*
*****************************************************************************

FUNCTION SAV_STAT

   PARAMETER P_STATID

   PRIVATE M_ACTION

   IF .NOT. P_STATID $ '[IA][IL][WI][MN][MS]' .AND. .NOT. EMPTY ( P_STATID )

      M_ACTION = MM_UTGET ( 24, 00, 'VERIFY STATE ID IS CORRECT (Y/N) : ', 'YN' )

      IF M_ACTION = 'N'
         RETU ( .F. )
      ENDIF

   ENDIF

RETURN ( .T. )

*****************************************************************************
*
* Function Name : sav_zipc
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will validate the zip code entered by user.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_ZIPCOD - Character - Zip Code being validated.
*
*****************************************************************************

FUNCTION SAV_ZIPC

   PARAMETER P_ZIPCOD

   IF LEN ( ALLTRIM ( P_ZIPCOD ) ) < 5 .AND. .NOT. EMPTY ( P_ZIPCOD )
   
      MM_UTMSG ( 'INVALID ZIP CODE . . . ANY KEY TO RETRY ' )

      RETU ( .F. )

   ENDIF

RETURN ( .T. )

*****************************************************************************
*
* Function Name : sav_phon
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will validate the phone no. entered by user.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_PHONNO - Numeric - Phone Number being validated.
*
*****************************************************************************

FUNCTION SAV_PHON

   PARAMETER P_PHONNO

   IF P_PHONNO < 1111110000 .AND. P_PHONNO <> 0
   
      MM_UTMSG ( 'INVALID PHONE NUMBER . . . ANY KEY TO RETRY ' )

      RETU ( .F. )

   ENDIF

RETURN ( .T. )

*****************************************************************************
*
* Function Name : sav_extn
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will validate the extension no. entered by
*                 the user.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_EXTENS - Numeric - Phone Extension being validated.
*
*****************************************************************************

FUNCTION SAV_EXTN

   PARAMETER P_EXTENS

   IF P_EXTENS < 0 
   
      MM_UTMSG ( 'INVALID EXTENSION NUMBER . . . ANY KEY TO RETRY ' )

      RETU ( .F. )

   ENDIF

RETURN ( .T. )

*****************************************************************************
*
* Function Name : sav_date
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will validate the date entered by user.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_DATECK - DATE - Date being validated.
*                 P_DATE02 - DATE - Date to validate P_DATECK against.
*
*****************************************************************************

FUNCTION SAV_DATE

   PARAMETER P_DATECK, P_DATE02

   IF DOW ( P_DATECK ) = 01 .OR. DOW ( P_DATECK ) = 07 
   
      MM_UTMSG ( 'INVALID DATE (MON-FRI) . . . ANY KEY TO RETRY ' )

      RETU ( .F. )

   ENDIF

   IF PCOUNT() > 01

      IF P_DATECK < P_DATE02 .AND. .NOT. EMPTY ( P_DATECK )

         MM_UTMSG ( 'DATE ENTERED MUST BE GREATER THAN : ' + DTOC ( P_DATE02 ) + ' . . . ANY KEY TO RETRY ' )

         RETU ( .F. )

      ENDIF

   ENDIF

RETURN ( .T. )

