; Program ...: Chdir.ASM 
; Author ....: Jeffrey McCrimon 
; Date ......: September 1, 1987 
; Notes .....: .BIN to be LOADed and CALLed from within dBASE III PLUS 
;              to set/return the current working directory.  To set the  
;              directory, use the following syntax: 
; 
;                  LOAD Chdir 
;                  STORE "<new directory>" to mvar 
;                  CALL Chdir WITH mvar 
; 
;              To get the current directory, use the following syntax: 
; 
;                  LOAD Chdir 
;                  STORE SPACE(65) TO mvar 
;                  CALL Chdir WITH mvar 
; 
;              mvar will hold the current directory. 
; 
;              In either case, if an error occurs, a plus sign ("+") 
;              will be placed in the first character of the memory variable. 
; 
CHGDIR  EQU     03Bh            ; Change directory. 
GETDIR  EQU     047h            ; Get the directory. 
ERRCHAR EQU     '+'             ; Error indicator. 
SPACE   EQU     32 
;--------------------------------------------------------------- 
; Macro to perform DOS INT 21H function call. 
DOSINT  MACRO   FUNCTION 
        MOV     AH,FUNCTION 
        INT     21H 
        ENDM 
;*************************************************************** 
CODE    SEGMENT BYTE    PUBLIC  'CODE' 
        ASSUME  CS:CODE 
CHDIR   PROC    FAR 
START:  JMP     ENTRY           ; Skip over the data area. 
 
        DB      13, 'Chdir.ASM by Jeffrey McCrimon', 13, 10 
        DB      '(c) Copyright, Ashton-Tate 1987',26 

ENTRY:  MOV     SI,BX                   ; Point to variable passed in. 
        CMP     BYTE PTR [SI],SPACE     ; Is the first byte a space? 
        JZ      GETCD                   ; Yes, get the current directory. 
        MOV     DX,BX                   ; No, specify the directory. 
        DOSINT  CHGDIR                  ; Change the directory. 
        CMP     AX,3                    ; Do we have any errors? 
        JZ      ERROR                   ; Yes, change first byte of variable. 
        JMP     END                     ; No, quit and return to dBASE III PLUS. 
GETCD:  SUB     DL,DL                   ; Specify the current drive. 
        DOSINT  GETDIR                  ; Get the current directory. 
        JMP     END                     ; Quit and return to dBASE III PLUS 
ERROR:  MOV     BYTE PTR [BX], ERRCHAR  ; "+" will indicate error occurred. 
END:    RET 
CHDIR   ENDP 
CODE    ENDS 
;*************************************************************** 
        END     START 
