
; Getdirec.asm
;
;  This routine accepts a 67 byte string variable and returns it 
; as the complete DOS path.  For example, if it is called as follows
; from the D:\database\invoices\overdue subdirectory, the reult would
; be as follows:
;
; * Find out what directory the user has changed to.
; currdirec=space(67)
; call getdirec with currdirec
;
;  Currdirec will have the value "D:\DATABASE\INVOICES\OVERDUE    "
; on return from the call.
;
; July 1, 1986
; Eric Engelmann, Technical Director of EMS, a microcomputer consulting
; company located at:
; 11701 Karen Drive
; Potomac, MD 20854
;
; Telephone (301) 299-9239
;
TITLE Getdirec
;
;
          Public  Getdirec

_Prog     SEGMENT BYTE
          ASSUME  CS:_Prog

Getdirec  Proc    Far          ;This is the standard stuff for Clipper
          Push    BP           ; invoked assembler calls.
          Mov     BP,SP
          Push    DS
          Push    ES
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       M A I N   P R O G R A M
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          CLD 
          LDS     SI,[BP+6] ;Load the segment of the passed variable
                            ; into DS and the offset into SI


          MOV     AH,19H    ;Get the drive and store it into the first bytes
                            ; of the memory variable (int 19 puts a 0,1,2
                            ; into AL)
          INT     21H                                             
          ADD     AL,41H    ;Add 64 to get letter for drive      

          MOV     [SI],AL   ; Write the drive letter to the first byte of the
                            ; clipper memory variable.
          MOV     AL,3AH    ;Put a colon in the accumualtor
          MOV     [SI+1],AL ;Put the colon into the second byte fo the Clipper
                            ; variable.

          MOV     AL,5CH    ;Put a backslash into the accumulator 
          MOV     [SI+2],AL ;Put the backslash inot the third byte of the 
                            ; Clipper variable.

          MOV     DL,00H    ;Put the memory address to recieve the path in SI
                            ; Use the default drive.
          INC     SI        ;Have DOS put the directory string into the 

          INC     SI        ; fourth and subsequent bytes of the Clipper
                            ; variable.

          INC     SI

          MOV     AH,47H     ;Select DOS function call 21,47, (gets subdir)
          INT     21H                                             




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       C L E A N   U P
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          POP     ES               ; This is the standard Clipper cleanup
          POP     DS               ;prior to return to the calling program.
          POP     BP

          RET                             
Getdirec  ENDP
_Prog     ENDS
          END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


