****
*       GETDATE.PRG
*
*   Calender program extract from STAGE templates.
*   Author: Luis Castro.
*
*
*   Compile:    CLIPPER getdate /n
*   Link:       RTLINK FILE getdate
*   Execute:    getdate row col <from dos>
*               getdate row,col <from clipper>
*
*   Returns:    selected date <as a string>
*

FUNCTION GETDATE
parameter r1,c1
LOCAL r2,c2,r1now,c1now,amdatescr,amchoice,amtemp,istoday,atrdate
LOCAL amtoday,amdate,amday,amdays,amtopofs,amlastdate,amlastday
LOCAL ccUP,ccDOWN,ccLEFT,ccRIGHT
LOCAL ccHOME,ccEND,ccPGUP,ccPGDN
LOCAL ccCtrlLEFT,ccCtrlRIGHT
LOCAL ccCtrlHOME,ccCtrlEND,ccCtrlPGDN,ccCtrlPGUP
LOCAL ccESC,ccENTER,ccDEL,ccBS,ccCtrlENTER
LOCAL ccCRLF,ccBROWkeys
LOCAL F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
   r1 = IIF( type('r1') = 'C',val(r1),r1)
   c1 = IIF( type('c1') = 'C',val(c1),c1)
   r1 = IIF( r1+10<=MAXROW(),r1,MAXROW()-10 )
   c1 = IIF( c1+23<=MAXCOL(),c1,MAXCOL()-23 )
   r2 = r1 + 10
   c2 = c1 + 23
   * ---INKEY constants/variables:
   ccHOME          = CHR( 1)
   ccCtrlRIGHT     = CHR( 2)
   ccPGDN          = CHR( 3)
   ccRIGHT         = CHR( 4)
   ccUP            = CHR( 5)
   ccEND           = CHR( 6)
   ccDEL           = CHR( 7)
   ccBS            = CHR( 8)
   ccCtrlENTER     = CHR(10)
   ccENTER         = CHR(13)
   ccPGUP          = CHR(18)
   ccLEFT          = CHR(19)
   ccCtrlEND       = CHR(23)
   ccDOWN          = CHR(24)
   ccCtrlLEFT      = CHR(26)
   ccESC           = CHR(27)
   ccCtrlHOME      = CHR(29)
   ccCtrlPGDN      = CHR(30)
   ccCtrlPGUP      = CHR(31)
   ccCRLF          = CHR(13) + CHR(10)
   F1      = CHR(28)
   F2      = CHR(254)
   F3      = CHR(253)
   F4      = CHR(252)
   F5      = CHR(251)
   F6      = CHR(250)
   F7      = CHR(249)
   F8      = CHR(248)
   F9      = CHR(247)
   F10     = CHR(246)
   amdatescr = GETIMAGE(r1,c1,r2,c2)
   SET CURSOR OFF
   amchoice = " "
   amtoday = DATE()
   amdate = amtoday
   SETCOLOR('gr+/b')
   @ r1,c1 CLEAR TO r2,c2
   @ r1,c1,r2,c2 BOX ""
   @ r1+2,c1+1 SAY ""
   SETCOLOR('w+/b')
   @ r1+3,c1+2 SAY  "Su Mo Tu We Th Fr Sa"
   DoSHADOW(r1,c1,r2,c2)
   r1 = r1 + 4
   c1 = c1 + 2
   c2 = c2 - 2
   DO WHILE .NOT. (amchoice $ ccENTER+ccESC)
      * ---another month.
      amday = DAY(amdate)
      amlastdate = (amdate-amday+32) - DAY(amdate-amday+32)
      amlastday = DAY(amlastdate)
      amtopofs = DOW(amdate - amday + 1) - 1
      amdays = STUFF(SPACE(111),amtopofs*3+1,amlastday*3,LEFT(;
         " 1  2  3  4  5  6  7  8  9 10 " +;
         "11 12 13 14 15 16 17 18 19 20 " +;
         "21 22 23 24 25 26 27 28 29 30 31 ",amlastday*3) )
      * ---display heading & days.
      SETCOLOR('gr+/b')
      @ r1-3,c1 CLEAR TO r1-3,c2
      DoCENTER( r1-3,c1,c2,CMONTH(amdate)+STR(YEAR(amdate),5),'gr+/b' )
      SETCOLOR('w+/b')
      @ r1,  c1 SAY LEFT(amdays,21)
      @ r1+1,c1 SAY SUBSTR(amdays,22,21)
      @ r1+2,c1 SAY SUBSTR(amdays,43,21)
      @ r1+3,c1 SAY SUBSTR(amdays,64,21)
      @ r1+4,c1 SAY SUBSTR(amdays,85,21)
      @ r1+5,c1 SAY RIGHT(amdays,6)
      IF MONTH(amdate) = MONTH(amtoday) .AND. YEAR(amdate) = YEAR(amtoday)
         * ---highlight today's date.
         SETCOLOR('w+/bg')
         @ r1 + (amtopofs+DAY(amtoday)) / 7.1,;
           c1 + DOW(amtoday) * 3 - 3 SAY STR(DAY(amtoday),2)
      ENDIF
      * ---day in month loop.
      DO WHILE MONTH(amdate) = MONTH(amlastdate) .AND.;
               YEAR(amdate) = YEAR(amlastdate)
         amday = DAY(amdate)
         r1now = r1 + (amtopofs + amday) / 7.1
         c1now = c1 + DOW(amdate) * 3 - 3
         istoday = (amdate = amtoday)
         SETCOLOR('n/gr')
         @ r1now,c1now SAY STR(amday,2)
         amchoice = GETKEY( ;
            ccESC+ccENTER+ccBS+ccLEFT+ccRIGHT+ccUP+ccDOWN+;
            ccPGUP+ccPGDN+ccHOME+ccEND+ccCtrlHOME+ccCtrlEND+;
            ccCtrlPGUP+ccCtrlPGDN+ccCtrlLEFT+ccCtrlRIGHT,"GETDATE" )
         DO CASE
         CASE amchoice = ccESC
            * ---return a null date.
            amdate = CTOD("")
            EXIT
         CASE amchoice = ccENTER
            * ---accept this date.
            EXIT
         CASE amchoice $ ccBS+ccLEFT
            * ---prior day.
            amdate = amdate - 1
         CASE amchoice $ ccRIGHT+" "
            * ---next day.
            amdate = amdate + 1
         CASE amchoice = ccUP
            * ---prior week.
            amdate = amdate - 7
         CASE amchoice = ccDOWN
            * ---next week.
            amdate = amdate + 7
         CASE amchoice = ccPGUP
            * ---prior month.
            amdate = amdate - MAX(amday,DAY(amdate-amday))
         CASE amchoice = ccPGDN
            * ---next month.
            amtemp = amdate + amlastday
            amdate = amtemp - IIF( amday<=DAY(amtemp),0,DAY(amtemp) )
         CASE amchoice = ccHOME
            * ---1st day of month.
            amdate = amdate - amday + 1
         CASE amchoice = ccEND
            * ---last day of month.
            amdate = amlastdate
         CASE amchoice = ccCtrlHOME
            * ---1st day of year.
            amdate = CTOD("01/01/"+STR(YEAR(amdate),4))
         CASE amchoice = ccCtrlEND
            * ---last day of year.
            amdate = CTOD("12/31/"+STR(YEAR(amdate),4))
         CASE amchoice = ccCtrlPGUP
            * ---prior year.
            amtemp = LEFT(DTOC(amdate),6)
            amtemp = IIF(amtemp="02/29/","02/28/",amtemp)
            amdate = CTOD(amtemp+STR(YEAR(amdate)-1,4))
         CASE amchoice = ccCtrlPGDN
            * ---next year.
            amtemp = LEFT(DTOC(amdate),6)
            amtemp = IIF(amtemp="02/29/","02/28/",amtemp)
            amdate = CTOD(amtemp+STR(YEAR(amdate)+1,4))
         CASE amchoice = ccCtrlLEFT
            * ---1st day of week.
            amdate = amdate - DOW(amdate) + 1
         CASE amchoice = ccCtrlRIGHT
            * ---last day of week.
            amdate = amdate - DOW(amdate) + 7
         ENDCASE
         IF istoday
            SETCOLOR('w+/bg')
         ELSE
            SETCOLOR('w+/b')
         ENDIF
         @ r1now,c1now SAY STR(amday,2)
      ENDDO
   ENDDO
*   PUTIMAGE(@amdatescr)
   SET CURSOR ON
   @24,1 say 'DATE = '+DTOC(amdate)
RETURN DTOC(amdate)

FUNCTION GETIMAGE( r1,c1,r2,c2 )
LOCAL amr2,amc2
   amr2 = IIF( r2+1<=MAXROW(),r2+1,r2 ) && if DoSHADOW is used
   amc2 = IIF( c2+2<=MAXCOL(),c2+2,c2 )
RETURN CHR(r1) + CHR(c1) + CHR(amr2) + CHR(amc2) +;
   SETCOLOR() + "|" + SAVESCREEN( r1,c1,amr2,amc2 )

FUNCTION DoSHADOW( r1,c1,r2,c2 )
LOCAL amr1,amc1,amr2,amc2
   IF (r2+1 <= MAXROW()) .AND. (c2+2 <= MAXCOL())
      * ---BOTTOM shadow.
      amr1 = r2 + 1
      amc1 = c1 + 1
      amr2 = r2 + 1
      amc2 = c2 + 2
      RESTSCREEN( amr1,amc1,amr2,amc2,;
         TRANSFORM( SAVESCREEN(amr1,amc1,amr2,amc2),;
                    REPLICATE("X"+CHR(7),amc2-amc1+1)))
      * ---RIGHT shadow.
      amr1 = r1 + 1
      amc1 = c2 + 1
      RESTSCREEN( amr1,amc1,amr2,amc2,;
         TRANSFORM( SAVESCREEN(amr1,amc1,amr2,amc2),;
                    REPLICATE("X"+CHR(7),(amr2-amr1+1)*2 )))
   ENDIF
RETURN NIL

PROCEDURE DoCENTER( r1,c1,c2,amhdg,amhue )
LOCAL amcolor,amsaylen,amhdglen
   amcolor = SETCOLOR(amhue)
   amsaylen = c2 - c1 + 1
   amhdglen = LEN( amhdg )
   IF amsaylen > amhdglen
      @ r1,c1 + ((amsaylen-amhdglen)/2)+0.5 SAY amhdg
   ELSE
      @ r1,c1 SAY amhdg
   ENDIF
   SETCOLOR(amcolor)
RETURN

FUNCTION GETKEY( amkeys )
LOCAL amchoice,amkey
   amchoice = "***"
   WHILE .NOT. (amchoice $ amkeys)
      amkey = INKEY()
      IF amkey > 0
         amchoice = UPPER(CHR(amkey))
      ELSEIF amkey < 0
         amchoice = CHR(255+amkey)
      ENDIF
   END WHILE
RETURN amchoice

PROCEDURE PUTIMAGE( amimage )
LOCAL amtemp,amcolor
   amtemp = LEFT( amimage,4 )
   amcolor = SUBSTR( amimage,5,AT("|",amimage)-5 )
   SETCOLOR(amcolor)
   RESTSCREEN( ;
      ASC(SUBSTR(amtemp,1,1)),;
      ASC(SUBSTR(amtemp,2,1)),;
      ASC(SUBSTR(amtemp,3,1)),;
      ASC(SUBSTR(amtemp,4,1)),;
      SUBSTR(amimage,AT("|",amimage)+1) )
RETURN
