*!*********************************************************************
*!
*!       Function: ULIST()
*!
*!*********************************************************************
FUNCTION ulist
*& User defined list function
PARAMETERS arrlist

PRIVATE SELECT,Recno,LIST,FIELDS[fcount()],Fcount,I,;
   rn,descs[fcount()],macrostr,ptr,lists[fcount()],string

SELECT = SELECT()
Recno  = Recno()
Fcount = Fcount()

Newscreen('List Records','',.T.)   && Use your own UDF - please see read.me file

IF Pcount()=1
   PRIVATE FIELDS[len(arrlist)]
   Acopy(arrlist,FIELDS)
ELSE
   Afields(FIELDS)
ENDIF

SELECT d_field

FOR I = 1 TO m->fcount
   SEEK UPPER(Iif(Pcount()=0,FIELDS[i],Substr(FIELDS[i],2)))
   IF .NOT. Eof()
      IF Pcount()=0
         descs[i] = Chr(32)+Left(d_field->field_desc,26)+Str(field_len,3)
      ELSE
         descs[i] = Left(FIELDS[i],1)+Left(d_field->field_desc,26)+Str(field_len,3)
      ENDIF
      lists[i]  = d_field->field_list
   ENDIF
NEXT i

Setcolor = Setcolor(colorstr('ARR'))
@ 4,25 CLEAR TO 20,56
@ 3,24 TO 21,57 DOUBLE
string = "'ENTER' accepts selection 'SPACE' toggles "
Highlight(24,Centre(string,80),string)  && Use your own UDF - please see read.me file

rn = checklist(descs,4,25,20,56,.T.,1)
Setcolor(m->setcolor)

CLEAR SCREEN

ptr = Ascan(descs,"")
IF m->ptr <> 0 .and. rn <> 27        && user made a selection & did not abort
   n=1
   FOR I = ptr+1 TO m->fcount
      IF Substr(descs[i],1,1)<>' '
         n=n+1
      ENDIF
   NEXT i
   PRIVATE listarray[n]
   n=1
   FOR I = ptr TO m->fcount
      IF SUBSTR(descs[i],1,1)<>' '
         listarray[n]=BLANKFILL(lists[i],Val(Right(descs[i],3)))+'|'+; && Use your own UDF - please see read.me file
            IIF(Pcount()=0,Left(FIELDS[i],10),Substr(FIELDS[i],2,10))
         n=n+1
      ENDIF
   NEXT i
   
   SELECT m->select
   Stdlist(listarray)
   
ENDIF

CLEAR SCREEN

SELECT m->select
GO Recno()
RETURN .T.

*!*********************************************************************
*!
*!       Function: STDLIST()
*!
*!*********************************************************************
FUNCTION Stdlist
*& Purpose : Standard List function

PARAMETERS listarray

stdlistscr = SCREENSAVE() && Use your own UDF - please see read.me file

PRIVATE arraytotal
arraytotal = Len(listarray)

PRIVATE arrayfield[m->arraytotal]

TITLE = ''
FOR n = 1 TO m->arraytotal
   atloc            = At('|',listarray[m->n])
   TITLE            = m->title + Left(listarray[m->n],m->atloc - 1) + ' '
   arrayfield[m->n] = Substr(listarray[m->n],m->atloc + 1)
NEXT
TITLE = m->title + Space(80-Len(m->title))

CLEAR
Highlight(0,0,m->title) && Use your own UDF - please see read.me file

counter = 0
recordno = Recno()
GO TOP

DO WHILE .NOT. Eof()
   
   ?
   FOR n = 1 TO m->arraytotal
      fieldvalue = ' '
      fieldvalue = arrayfield[m->n]
      ?? &fieldvalue
      ?? ' '
      RELEASE fieldvalue
   NEXT
   SKIP
   counter = m->counter + 1
   
   IF Eof()
      Statement('End of file') && Use your own UDF - please see read.me file
      EXIT
   ENDIF
   
   IF m->counter = 20
      IF .NOT. Logical('More') && Use your own UDF - please see read.me file
         EXIT
      ELSE
         CLEAR
         Highlight(0,0,m->title) && Use your own UDF - please see read.me file
         counter = 0
      ENDIF
   ENDIF
ENDDO (while .T.)

GO m->recordno

SCREENREST(m->stdlistscr) && Use your own UDF - please see read.me file

RETURN ''


***********************************************************************
*                                                                     *
*   Author:  John F. Kaster                                           *
*   Date:    3/1/89                                                   *
*   Notes:                                                            *
*                                                                     *
*   These routines make use of ACHOICE() from EXTEND.LIB.  Therefore, *
*   extend.lib must be linked in with them in order for them to work. *
*                                                                     *
***********************************************************************


************************************************************************
*                                                                      *
* Checklist( <array>, <top>, <left>, <bottom>, <right> [, <skip array> *
*            [, <markat> ]] )                                          *
*   Calls ACHOICE to put  marks on array elements                     *
*   returns the last key pressed.                                      *
*   Array must be character array with at least leading space          *
*   available in the character string for inserting/deleting          *
*                                                                      *
************************************************************************

*!*********************************************************************
*!
*!       Function: CHECKLIST()
*!
*!*********************************************************************
FUNCTION checklist
PARAMETER arr2chk, l1, c1, l2, c2, skiparr, markat
PRIVATE skiptype, curel, keyp
skiptype = Type('m->skiparr' )
IF m->skiptype # 'A'
   skiparr = .T.
ENDIF

IF Type( 'm->markat' ) <> 'N'
   markat = 1
ENDIF

curel = 1
keyp  = 0
DO WHILE m->curel # 0 .and. .NOT. enter() .and. .NOT. esc()
   
   curel = Achoice( m->l1, m->c1, m->l2, m->c2,;
      arr2chk, skiparr, 'chklist', m->curel)
   
   ** Move down from tag if spacebar was used
   IF spacebar()
      curel = IF( m->curel < Len( m->arr2chk ), m->curel + 1, m->curel )
      IF m->skiptype == 'A'
         IF ! skiparr[ m->curel ]
            curel = m->curel - 1
         ENDIF
      ENDIF
   ENDIF
   
ENDDO
RETURN Lastkey()

****************************************************************
*                                                              *
* chklist is a function called from ACHOICE that enables       *
* the user to  an array element by pressing the space bar.    *
* if the user presses the <space bar> again, the  is removed. *
* ALT-T tags all, ALT-U untags all (right now).                *
*                                                              *
****************************************************************

*!*********************************************************************
*!
*!       Function: CHKLIST()
*!
*!*********************************************************************
FUNCTION chklist
*         Status message   current element  relative position
PARAMETER STATUS, curel, relpos
PRIVATE   retval, I,n,z,o,q
retval  = 2

keyp = Lastkey()

DO CASE
CASE m->status = 1 && Cursor past top of list
   KEYBOARD Chr(30) && ^PgDn
CASE m->status = 2 && Cursor past end of list
   KEYBOARD Chr(31) && ^PgUp
CASE m->status = 3 && Keyboard exception
   DO CASE
   CASE lt_arrow()
      KEYBOARD Chr(5) && Up arrow
   CASE rt_arrow()
      KEYBOARD Chr(24) && Down arrow
   CASE home()
      KEYBOARD Chr(31) && ^PgUp
   CASE END()
      KEYBOARD Chr(30) && ^PgDn
   CASE enter()
      retval = 1
   CASE esc()
      retval = 0
   CASE spacebar()
      n=0
      o=0
      FOR z=1 TO Len(arr2chk)
         IF '' $ arr2chk[z]
            o=o+Val(Right(arr2chk[z],3))
            n=n+1
         ENDIF
      NEXT z
      q = .NOT.(Left(arr2chk[m->curel],1))=''
      o=o+Val(Right(arr2chk[curel],3))
      IF IF( m->skiptype # 'A', .T., skiparr[ m->curel ] )
         arr2chk[ m->curel ] = STUFF( arr2chk[ m->curel ], m->markat, 1, ;
            Iif(Left(arr2chk[m->curel],1)=' '.and. ;
            m->n<8.and.m->o<80,'',' ') )
      ENDIF
      IF m->n = 7
         Statement("You have selected the maximum number of fields",;
            "Press any key to continue")
      ENDIF
      IF m->o >=80.and.q
         Statement("You have selected more fields than can fit on the page")
      ENDIF
      retval = 1
      
   CASE alt_t()
      FOR I = 1 TO Len( arr2chk )
         IF IF( m->skiptype # 'A', .T., skiparr[ m->i ] )
            arr2chk[ m->i ] = STUFF( arr2chk[ m->i ], m->markat, 1, '')
         ENDIF
      NEXT
      retval = 1
      
   CASE alt_u()
      FOR I = 1 TO Len( arr2chk )
         IF IF( m->skiptype # 'A', .T., skiparr[ m->i ] )
            arr2chk[ m->i ] = STUFF( arr2chk[ m->i ], m->markat, 1, ' ')
         ENDIF
      NEXT
      retval = 1
   OTHER
      ****  Add message routine here! ***************************
      *    mess ('[Enter] accepts current changes,;[Space] toggles ,;  move;[Esc] aborts changes', 'Invalid Key!' )
   ENDCASE
ENDC


RETURN m->retval

*: EOF: FILEMNT.PRE

