DECLARE SUB SCRTITLE ()
DECLARE SUB SCRTITLE ()
DECLARE SUB UPPERCASE (name$)
DECLARE SUB INIT ()
DECLARE SUB CLRSCR ()
DECLARE SUB EXTENSION ()
DECLARE SUB KILLFILE ()
DECLARE SUB MAINTT ()
DECLARE SUB REPORTT ()
DECLARE SUB INQUIRYT ()
DECLARE SUB MENU ()
'         GENCVT - Convert GENIFER programs to CLIPPER format
'                 Copyright (c) Nordic Systems - 1987
'
' GENCVT - convert Genifer generated programs to allow compilation
'          by Clipper.  Converts procedure names to a standard form
'          of:
'                 . first six characters of input program name
'                 . next two characters of a sequence number
'
'          Note that this works only if your programs names are unique
'          within the first six characters of name.
'
' GENCVT works as follows:
'
'          1. You are asked for the program name you wish to convert
'          2. You are then asked for the type of program:
'
'                . Update
'                . Inquiry
'                . Report
'                . Menu
'
'          Depending on your answer to program type, one of four
'          subprograms is called.  Three of these programs use an
'          array of standard procedure names emitted by Genifer as
'          a source to look for string information in the generated
'          Genifer program.  Each then generates a corresponding array
'          of "new" procedure names to be substituted in the Genifer
'          text. The fourth program deals with menus and is more
'          interactive.  Upon locating a call to a procedure, it asks
'          if the call is to a procedure or another menu.  If it is a
'          menu, the "SET" statement is removed and the remaining "DO"
'          statement remains in the text to be executed.
'
'          Generally, the input program is read and appropriate substitutions are
'          are made to the text.  This text is written on a temporary file
'          with the same name as your input program with an extension
'          of "$$$".  If the translation finishes correctly, your
'          original ".PRG" file will be renamed with an extension of
'          ".BAK".  The "$$$" file will then be renamed with an extension
'          of ".PRG".  This way you always have a backup of your original
'          program should anything malfunction in the conversion process.
' Set up shared variables with subprograms to be used in printing
' final results of conversion
' rep             - number of replacements
' prog$           - old program name
' newprog$        - new program name
' temp$           - output line for new file
' firstime$       - flag for first time through the loop
' procname$       - main procedure name to be replaced
' filter$         - filter expression to be replaced
' index$          - index expression to be replaced
' killflag$       - flag which says files to kill arent there
COMMON SHARED rep, prog$, newprog$, temp$, procname$, filter$, index$, killflag$, origfile$, maxmaint, maxinq, maxrep
' Print screen title
CALL SCRTITLE
' Set up error handling for opening PRG files
ON ERROR GOTO ERRORHANDLE
' Set lowest array boundary to 1 (makes more sense)
OPTION BASE 1
' Allocate the procedure name arrays before initializing them
maxmaint = 35
maxinq = 27
maxrpt = 27
DIM SHARED maint$(35, 35)
DIM SHARED inquiry$(27, 27)
DIM SHARED report$(27, 27)
START:
' Clear the screen and ask for the program name to be examined
LOCATE 10, 12
PRINT "Please enter then name of your dBase program: ";
INPUT prog$
' Program name can't be any greater than six characters in length
' If so, chop it back to six.
infile$ = prog$ + ".PRG"
origfile$ = prog$
newname$ = prog$
IF LEN(prog$) > 8 THEN
  prog$ = LEFT$(prog$, 8)
END IF
CALL UPPERCASE(infile$)
LOCATE 10, 58
PRINT infile$;
' Lets see if we have a file by that name anywhere on the disk
OPEN infile$ FOR INPUT AS #1
IF number > 0 THEN
  number = 0
  GOTO START
END IF
' We have the file, so now initialize the corresponding procedure name
' arrays needed to do the conversion
CALL INIT
' Enter program type. This may be "M"enu, "I"nquiry,
' "R"eport or "Update
WHILE progtype$ <> "M" AND progtype$ <> "I" AND progtype$ <> "R" AND progtype$ <> "U"
  progtype$ = ""
  LOCATE 12, 25
  PRINT "Please enter the program type as follows: "
  LOCATE 14, 25
  PRINT "M - Menu program"
  LOCATE 15, 25
  PRINT "I - Inquiry program"
  LOCATE 16, 25
  PRINT "R - Report program"
  LOCATE 17, 25
  PRINT "U - Update program"
PRGLOOP:
    LOCATE 20, 30
    progtype$ = INKEY$
    IF LEN(progtype$) = 0 THEN
      GOTO PRGLOOP
    END IF
  CALL UPPERCASE(progtype$)
  LOCATE 20, 28
  PRINT progtype$
  CALL CLRSCR
  LOCATE 15, 24
  PRINT "<< Now converting: "; infile$; ">>"
WEND
' Get a new name for the program file we are creating. It is the old
' program name with the extension $$$ added to it
newprog$ = ""
CALL EXTENSION
' Now let's process the file according to the program type input by
' the user
CALL KILLFILE
OPEN newprog$ FOR OUTPUT AS #2
WHILE NOT EOF(1)
  LINE INPUT #1, temp$
  IF progtype$ = "U" OR progtype$ = "u" THEN
    CALL MAINTT
  ELSEIF progtype$ = "R" OR progtype$ = "r" THEN
    TRON
    CALL REPORTT
  ELSEIF progtype$ = "I" OR progtype$ = "i" THEN
    CALL INQUIRYT
  ELSEIF progtype$ = "M" OR progtype$ = "m" THEN
    CALL MENU
  END IF
   PRINT #2, temp$
WEND
CLOSE
' Tell him were done with the conversion
CALL CLRSCR
LOCATE 12, 22
PRINT "Conversion of "; infile$; " is complete"
LOCATE 14, 22
' Rename the original file as a .BAK file
' and rename the temporary .$$$ file as the new .PRG file
NAME infile$ AS origfile$ + ".BAK"
NAME newprog$ AS origfile$ + ".PRG"
' Now ask if there are any more PRGs to convert
ans$ = " "
ANSLOOP:
  WHILE ans$ <> "Y" AND ans$ <> "y" AND ans$ <> "N" AND ans$ <> "n"
    CALL CLRSCR
    LOCATE 12, 10
    PRINT "Are there any more PRG files to convert (Y/N)?: ";
    INPUT ans$
    IF ans$ = "Y" OR ans$ = "y" THEN
      GOTO START
    END IF
    IF ans$ = "N" OR ans$ = "n" THEN
      GOTO ENDIT
    END IF
  WEND
ENDIT:
  CLS
  LOCATE 12, 10
  PRINT "Conversion of Genifer programs to Clipper format is complete."
END
ERRORHANDLE:
  number = ERR
  IF number = 53 THEN
    IF killflag$ <> "Y" THEN
      LOCATE 13, 25
      PRINT "Program file "; prog$; " does not exist"
      LOCATE 14, 30
      PRINT "Hit any key to try again.";
INLOOP:
        a$ = INKEY$
        IF LEN(a$) = 0 THEN
          GOTO INLOOP
        END IF
      LOCATE 10, 58
      PRINT SPACE$(15)
      LOCATE 13, 25
      PRINT SPACE$(50)
      LOCATE 14, 30
      PRINT SPACE$(45)
    END IF
  END IF
RESUME NEXT
'data for maint$ array
DATA "addrec"
DATA "calcul"
DATA "chk_dupl"
DATA "chk_fils"
DATA "clrfld"
DATA "clrsay"
DATA "clr_cal"
DATA "del_rec"
DATA "disfld"
DATA "disp_cal"
DATA "disp_msg"
DATA "disp_rec"
DATA "disscr"
DATA "filter"
DATA "getfld"
DATA "getkey"
DATA "get_optn"
DATA "go_bot"
DATA "go_top"
DATA "inifld"
DATA "init_key"
DATA "list"
DATA "load"
DATA "lookup"
DATA "mnt_help"
DATA "modify"
DATA "pack_dbf"
DATA "replce"
DATA "retrieve"
DATA "save_rec"
DATA "scr_box"
DATA "skip"
DATA "tally"
DATA "valdte"
DATA "zoom"
'data for inquiry array
DATA "calcul"
DATA "chk_fils"
DATA "clrfld"
DATA "clrsay"
DATA "clr_cal"
DATA "disfld"
DATA "disp_cal"
DATA "disp_msg"
DATA "disp_rec"
DATA "disscr"
DATA "filter"
DATA "getfld"
DATA "getkey"
DATA "get_optn"
DATA "go_bot"
DATA "go_top"
DATA "inifld"
DATA "init_key"
DATA "list"
DATA "load"
DATA "lookup"
DATA "mnt_help"
DATA "retrieve"
DATA "scr_box"
DATA "skip"
DATA "tally"
DATA "zoom"
'data for reports array
DATA "adv_line"
DATA "adv_page"
DATA "chk_fils"
DATA "detail"
DATA "disp_msg"
DATA "page_hd"
DATA "page_ft"
DATA "rept_hd"
DATA "rept_ft"
DATA "brk1_head"
DATA "brk1_ft"
DATA "brk2_head"
DATA "brk2_ft"
DATA "brk3_head"
DATA "brk3_ft"
DATA "brk4_head"
DATA "brk4_ft"
DATA "brk5_head"
DATA "brk5_ft"
DATA "brk6_head"
DATA "brk6_ft"
DATA "brk7_head"
DATA "brk7_ft"
DATA "brk8_head"
DATA "brk8_ft"
DATA "brk9_head"
DATA "brk9_ft"

SUB CLRSCR STATIC
  ' Clear the screen between line 4 and line 23
  LOCATE 4, 1
  FOR i = 1 TO 20
    PRINT SPACE$(70)
  NEXT i
END SUB

SUB EXTENSION STATIC
  mark = INSTR(infile$, ".")
  IF mark = 0 THEN
    newprog$ = prog$ + ".$$$"
  ELSE
    newprog$ = LEFT$(prog$, mark - 1) + ".$$$"
  END IF
END SUB

' Subprogram to initialize the procedure name arrays
SUB INIT STATIC
' Initialize the maintenance program arrays first
  FOR i = 1 TO maxmaint
    READ maint$(2, i)
    num$ = STR$(i)
    length = LEN(num$)
    length = length - 1
    num$ = RIGHT$(num$, length)
    maint$(1, i) = prog$ + num$
  NEXT i
' Initialize the inquiry program arrays
  FOR i = 1 TO maxinq
    READ inquiry$(2, i)
    num$ = STR$(i)
    length = LEN(num$)
    length = length - 1
    num$ = RIGHT$(num$, length)
    inquiry$(1, i) = prog$ + num$
  NEXT i
' Initialize the report program array
  FOR i = 1 TO maxrep
    num$ = STR$(i)
    length = LEN(num$)
    length = length - 1
    num$ = RIGHT$(num$, length)
    READ report$(2, i)
    report$(1, i) = prog$ + num$
  NEXT i
END SUB

SUB INQUIRYT STATIC
    procname$ = "PROCEDURE " + prog$
    filter$ = "set filter to &filt_str"
    index$ = ".ndx"
' Capture first procedure name and convert for Clipper
  mark = INSTR(temp$, procname$)
  IF mark > 0 THEN
    temp$ = "PROCEDURE " + prog$ + "00"
    EXIT SUB
  END IF
  ' Trap erroneous filter setting which is not recognized by Clipper
  ' and change it to what Genifer recommends
  mark = INSTR(temp$, filter$)
  IF mark > 0 THEN
    temp$ = "      set filter to"
    PRINT #2, temp$
    temp$ = "      if '' <> trim(filt_str)"
    PRINT #2, temp$
    temp$ = "        set filter to &filt_str"
    PRINT #2, temp$
    temp$ = "      endif"
    EXIT SUB
  END IF
  ' Trap expressions that end in .ndx and change them to .ntx
  mark = INSTR(temp$, index$)
  IF mark > 0 THEN
    length = LEN(temp$)
    temp$ = LEFT$(temp$, mark - 1) + ".ntx" + RIGHT$(temp$, length - mark - 3)
    EXIT SUB
  END IF
  ' Now that all the exceptions are dealt with, trap the regular
  ' procedure calls and convert them to the new numbering scheme.
  FOR i = 1 TO maxinq
    target$ = "procedure " + inquiry$(2, i)
    mark = INSTR(temp$, target$)
    IF mark > 0 THEN
      temp$ = "procedure " + inquiry$(1, i)
      rep = rep + 1
      EXIT SUB
    END IF
    target$ = "do " + inquiry$(2, i)
    mark = INSTR(temp$, target$)
    IF mark > 0 THEN
      ' grab the first part of the sentence
      part1$ = LEFT$(temp$, mark + 2)
      ' then plug in the generated routine number
      part1$ = part1$ + inquiry$(1, i)
      ' get the length of the total sentence and the length of the
      ' original phrase
      templength = LEN(temp$)
      length = LEN(inquiry$(2, i))
      ' add three bytes to handle the DO portion
      length = length + 3
      ' calculate where to pick up the rest of the sentence if available
      mark = mark + length - 1
      part1$ = part1$ + RIGHT$(temp$, templength - mark)
      temp$ = part1$
      rep = rep + 1
      EXIT SUB
    END IF
 NEXT i
END SUB

SUB KILLFILE STATIC
  killflag$ = "Y"
  mark = INSTR(infile$, ".")
  IF mark = 0 THEN
    temprog$ = infile$ + ".$$$"
  ELSE
    temprog$ = LEFT$(infile$, mark - 1) + ".$$$"
  END IF
  KILL temprog$
  mark = INSTR(infile$, ".")
  IF mark = 0 THEN
    temprog$ = infile$ + ".BAK"
  ELSE
    temprog$ = LEFT$(infile$, mark - 1) + ".BAK"
  END IF
  KILL temprog$
END SUB

SUB MAINTT STATIC
  procname$ = "PROCEDURE " + prog$
  filter$ = "set filter to &filt_str"
  index$ = ".ndx"
  ' Capture first procedure name and convert for Clipper
  mark = INSTR(temp$, procname$)
  IF mark > 0 THEN
    temp$ = "PROCEDURE " + prog$ + "00"
    EXIT SUB
  END IF
  ' Trap erroneous filter setting which is not recognized by Clipper
  ' and change it to what Genifer recommends
  mark = INSTR(temp$, filter$)
  IF mark > 0 THEN
    temp$ = "      set filter to"
    PRINT #2, temp$
    temp$ = "      if '' <> trim(filt_str)"
    PRINT #2, temp$
    temp$ = "        set filter to &filt_str"
    PRINT #2, temp$
    temp$ = "      endif"
    EXIT SUB
  END IF
  ' Trap expressions that end in .ndx and change them to .ntx
  mark = INSTR(temp$, index$)
  IF mark > 0 THEN
    length = LEN(temp$)
    temp$ = LEFT$(temp$, mark - 1) + ".ntx" + RIGHT$(temp$, length - mark - 3)
    EXIT SUB
  END IF
  ' Now that all the exceptions are dealt with, trap the regular
  ' procedure calls and convert them to the new numbering scheme.
  FOR i = 1 TO maxmaint
    target$ = "procedure " + maint$(2, i)
    mark = INSTR(temp$, target$)
    IF mark > 0 THEN
      temp$ = "procedure " + maint$(1, i)
      rep = rep + 1
      EXIT SUB
    END IF
    target$ = "do " + maint$(2, i)
    mark = INSTR(temp$, target$)
    IF mark > 0 THEN
      ' grab the first part of the sentence
      part1$ = LEFT$(temp$, mark + 2)
      ' then plug in the generated routine number
      part1$ = part1$ + maint$(1, i)
      ' get the length of the total sentence and the length of the
      ' original phrase
      templength = LEN(temp$)
      length = LEN(maint$(2, i))
      ' add three bytes to handle the DO portion
      length = length + 3
      ' calculate where to pick up the rest of the sentence if available
      mark = mark + length - 1
      part1$ = part1$ + RIGHT$(temp$, templength - mark)
      temp$ = part1$
      rep = rep + 1
      EXIT SUB
    END IF
  NEXT i
END SUB

' Subprogram to convert menu programs to Clipper format
SUB MENU STATIC
  mark = INSTR(temp$, "enddo")
  IF mark > 0 THEN
    EXIT SUB
  END IF
  mark = INSTR(temp$, "if file")
  IF mark > 0 THEN
    LINE INPUT #1, temp$
    mark = INSTR(temp$, "set procedure to ")
    CALL CLRSCR
    LOCATE 12, 10
    proc$ = MID$(temp$, mark + 17, 6)
    PRINT "Is "; proc$; " a (M)enu program or a (P)rocedure";
MLOOP:
    INPUT ans$
    IF ans$ <> "M" AND ans$ <> "m" AND ans$ <> "P" AND ans$ <> "p" THEN
      GOTO MLOOP
    END IF
    IF ans$ = "M" OR ans$ = "m" THEN
      LINE INPUT #1, temp$
      EXIT SUB
    END IF
    PRINT #2, temp$
    LINE INPUT #1, temp$
    mark = INSTR(temp$, "do ")
    temp$ = LEFT$(temp$, mark + 8) + "00"
    EXIT SUB
  END IF
  mark = INSTR(temp$, "else")
  IF mark > 0 THEN
    LINE INPUT #1, temp$
    LINE INPUT #1, temp$
    LINE INPUT #1, temp$
    LINE INPUT #1, temp$
    EXIT SUB
  END IF
END SUB

SUB REPORTT STATIC
    procname$ = "PROCEDURE " + prog$
    filter$ = "set filter to &filt_str"
    index$ = ".ndx"
' Capture first procedure name and convert for Clipper
  mark = INSTR(temp$, procname$)
  IF mark > 0 THEN
    temp$ = "PROCEDURE " + prog$ + "00"
    EXIT SUB
  END IF
  ' Trap erroneous filter setting which is not recognized by Clipper
  ' and change it to what Genifer recommends
  mark = INSTR(temp$, filter$)
  IF mark > 0 THEN
    temp$ = "      set filter to"
    PRINT #2, temp$
    temp$ = "      if '' <> trim(filt_str)"
    PRINT #2, temp$
    temp$ = "        set filter to &filt_str"
    PRINT #2, temp$
    temp$ = "      endif"
    EXIT SUB
  END IF
  ' Trap expressions that end in .ndx and change them to .ntx
  mark = INSTR(temp$, index$)
  IF mark > 0 THEN
    length = LEN(temp$)
    temp$ = LEFT$(temp$, mark - 1) + ".ntx" + RIGHT$(temp$, length - mark - 3)
    EXIT SUB
  END IF
  ' Now that all the exceptions are dealt with, trap the regular
  ' procedure calls and convert them to the new numbering scheme.
  FOR i = 1 TO maxrep
    target$ = "procedure " + report$(2, i)
    mark = INSTR(temp$, target$)
    IF mark > 0 THEN
      temp$ = "procedure " + report$(1, i)
      rep = rep + 1
      EXIT SUB
    END IF
    target$ = "do " + report$(2, i)
    mark = INSTR(temp$, target$)
    IF mark > 0 THEN
      ' grab the first part of the sentence
      part1$ = LEFT$(temp$, mark + 2)
      ' then plug in the generated routine number
      part1$ = part1$ + report$(1, i)
      ' get the length of the total sentence and the length of the
      ' original phrase
      templength = LEN(temp$)
      length = LEN(report$(2, i))
      ' add three bytes to handle the DO portion
      length = length + 3
      ' calculate where to pick up the rest of the sentence if available
      mark = mark + length - 1
      part1$ = part1$ + RIGHT$(temp$, templength - mark)
      temp$ = part1$
      rep = rep + 1
      EXIT SUB
    END IF
  NEXT i
END SUB

SUB SCRTITLE STATIC
' Print screen title
  FOR i = 1 TO 78
    scrline$ = scrline$ + CHR$(196)
  NEXT i
  CLS
  PRINT CHR$(218);
  PRINT scrline$;
  PRINT CHR$(191)
  PRINT CHR$(179);
  LOCATE 2, 80
  PRINT CHR$(179)
  PRINT CHR$(192);
  PRINT scrline$;
  PRINT CHR$(217)
  title$ = "GENCVT: Convert GENIFER Ver. 2.0 to CLIPPER S'87"
  LOCATE 2, 2
  PRINT DATE$;
  LOCATE 2, ((80 - LEN(title$)) / 2)
  PRINT title$;
  LOCATE 2, 72
  PRINT TIME$
  FOR i = 1 TO 78
    boxstr$ = boxstr$ + CHR$(178)
  NEXT i
  LOCATE 23, 2
  PRINT "Upgraded for Genifer Ver 2.0 By G. Melton 4-18-89"
  LOCATE 24, 2
  PRINT boxstr$;
  copyr$ = " Copyright (c) 1987 - Nordic Systems "
  LOCATE 24, ((80 - LEN(copyr$)) / 2)
  PRINT copyr$;
END SUB

SUB UPPERCASE (name$) STATIC
' UPPERCASE - Convert string to uppercase
'
'  UPPERCASE converts a string to uppercase. If the string is already in
'  upper case nothing is done. It returns an empty string if name$ is empty.
  length = LEN(name$)
  ' If input string is empty just return an empty string
  IF length = 0 THEN
    EXIT SUB
  END IF
  FOR i = 1 TO length
    char = ASC(MID$(name$, i, 1))
  ' &hdf converts from lower to upper case
    IF ((char >= ASC("a")) AND (char <= ASC("z"))) THEN
      char = char AND &HDF
      MID$(name$, i, 1) = CHR$(char)
    END IF
  NEXT i
END SUB

