#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   local oBrush, oBar

   SET RESOURCES TO "DIALOGS.DLL"

   DEFINE BRUSH oBrush STYLE BRICKS

   DEFINE WINDOW oWnd FROM 1, 5 TO 20, 75 ;
      TITLE "Using Dialogs from DLLs" ;
      BRUSH oBrush ;
      MENU  BuildMenu()

   DEFINE BUTTONBAR oBar OF oWnd

   DEFINE BUTTON FILE "Select.bmp" OF oBar ACTION TestSelect() ;
      MESSAGE "Testing a sample selection dialog"

   DEFINE BUTTON FILE "Edit.bmp"   OF oBar ACTION TestClient() ;
      MESSAGE "Testing a typical bussiness dialog"

   DEFINE BUTTON FILE "Exit.bmp"   OF oBar ;
      ACTION Exit() MESSAGE "When you want to end"    // UDF

   DEFINE BUTTON FILE "Colors.bmp" OF oBar ACTION ChooseColor() GROUP ;
      MESSAGE "Calling Windows standard color selection dialog"

   DEFINE BUTTON FILE "Dlg.bmp"    OF oBar ;
      ACTION cGetFile( "*.dbf", "Select a DBF" ) ;
      MESSAGE "Calling Windows standard Get a File dialog"

   DEFINE BUTTON FILE "Fonts.bmp"  OF oBar ACTION ChooseFont() ;
      MESSAGE "Calling Windows standard font selection dialog"

   DEFINE BUTTON FILE "Blocks.bmp" OF oBar ACTION About() GROUP ;
      MESSAGE "About FiveWin designers"

   DEFINE BUTTON FILE "Printer.bmp" OF oBar ;
      ACTION WinHelp( "Order.hlp" ) MESSAGE "Please read this info"

   @ 6, 15 BITMAP FILENAME "Logo.bmp" SIZE 404, 245 OF oWnd

   SET MESSAGE OF oWnd ;
      TO "FiveWin - Storing Dialogs inside DLLs - pure Data-Driven power!"

   ACTIVATE WINDOW oWnd MAXIMIZED

   SET RESOURCES TO

return

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "Some &Dialogs"
      MENU
         MENUITEM "Make a selection..." ;
            MESSAGE "It's time to start building Windows applications easily!" ;
            ACTION TestSelect()

         MENUITEM "Now you have a real chance..." ;
            MESSAGE "Quick and easy Windows applications using your Clipper!!!" ;
            ACTION TestClient()

         SEPARATOR

         MENUITEM "End..." MESSAGE "Exit this demo" ACTION Exit()     // UDF
      ENDMENU

      MENUITEM "Some &Standards..."
      MENU
         MENUITEM "Choose A &Color..." ;
            MESSAGE "Calling standard Windows dialogs" ACTION ChooseColor()

         MENUITEM "Getting a &file..." ;
            MESSAGE "Hey, see how easy this is" ;
            ACTION cGetFile( "*.dbf", "Select a DBF" )

         MENUITEM "Selecting a f&ont..." ;
            MESSAGE "Any Windows facility is ready for you" ;
            ACTION ChooseFont()
      ENDMENU

      MENUITEM "About..." ;
         MESSAGE "Come on... we would like to see your name here soon!" ;
         ACTION About()

   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function TestSelect()

   local oDlg
   local cItem  := "Using a Dialog"
   local aItems := { "Using a Dialog",;
                     "stored inside a DLL",;
                     "is extremely easy!", "",;
                     "You can start using",;
                     "Borland's Resource WorkShop",;
                     "to 'draw' your screens!", "",;
                     "Welcome to the power of",;
                     "Clipper, Windows, xBase and OOPS!", "",;
                     "As we promised you:",;
                     "You don't have to know a word",;
                     "of Windows to build",;
                     "incredible Windows applications...",;
                     "You are an xBase Programmer!!!" }


   DEFINE DIALOG oDlg RESOURCE "Select"

   REDEFINE SAY ID 10 OF oDlg

   REDEFINE LISTBOX cItem ITEMS aItems ID 110 OF oDlg

   REDEFINE BUTTON ID 120 OF oDlg ;
      ACTION ( MsgInfo( "You selected..." + cItem ) )

   REDEFINE BUTTON ID 130 OF oDlg ;
      ACTION ( MsgStop( "Welcome to FiveWin POWER!!!" ),;
               If( MsgYesNo( "End this Dialog ?", "Select" ), oDlg:End(),) )

   REDEFINE BUTTON ID 140 OF oDlg ;
      ACTION ( MsgInfo( "You can execute any action from here...", "Info" ),;
               oDlg:Circle( 78, 260, 50 ) )

   ACTIVATE DIALOG oDlg CENTERED

return

//----------------------------------------------------------------------------//

function TestClient()

   local oDlg,  oRecNo,  oPhoto
   local oName, oAdress, oCountry, oActive, oNotes
   local cName, cAdress, cCountry, cNotes
   local aCountries := { "SPAIN", "USA", "CANADA", "GERMANY", "JAPAN", "..." }
   local lActive

   USE Clients

   cName    := Clients->Name
   cAdress  := Clients->Adress
   cCountry := Clients->Country
   lActive  := Clients->Active
   cNotes   := StrTran( Clients->Notes, Chr( 141 ) + Chr( 10 ), "" )
   cPhoto   := Clients->Photo

   DEFINE DIALOG oDlg RESOURCE "Client"

   REDEFINE SAY ID 10 OF oDlg                  // Just to make them 3D look
   REDEFINE SAY ID 20 OF oDlg
   REDEFINE SAY ID 30 OF oDlg
   REDEFINE SAY ID 40 OF oDlg
   REDEFINE SAY ID 50 OF oDlg
   REDEFINE SAY oRecNo PROMPT Str( RecNo(), 5 ) ;  // Here we trap a reference
      ID 60 OF oDlg                                // to the SAY Object

   REDEFINE GET oName   VAR cName   ID 110 OF oDlg
   REDEFINE GET oAdress VAR cAdress ID 120 OF oDlg
   REDEFINE COMBOBOX oCountry VAR cCountry ITEMS aCountries ID 130 OF oDlg
   REDEFINE CHECKBOX oActive  VAR lActive ID 140 OF oDlg

   REDEFINE GET oNotes VAR cNotes MEMO ID 150 OF oDlg

   REDEFINE GROUP  ID 160 OF oDlg
   REDEFINE BITMAP oPhoto FILENAME cPhoto ID 230 OF oDlg

   REDEFINE SCROLLBAR HORIZONTAL ID 220 OF oDlg RANGE 1, RecCount() ;
      ON DOWN ( DbSkip(),;
                If( EoF(), DbGoBottom(),),;
                oPhoto:LoadBMP( Clients->Photo ),;
                cName    := Clients->Name,    oName:Refresh(),;
                cAdress  := Clients->Adress,  oAdress:Refresh(),;
                cCountry := Clients->Country, oCountry:Refresh(),;
                lActive  := Clients->Active,  oActive:Refresh(),;
                cNotes   := StrTran( Clients->Notes, Chr( 141 ) + Chr( 10 ), "" ),;
                            oNotes:Refresh(),;
                oRecNo:SetText( Str( RecNo(), 5 ) ) ) ;
      ON UP   ( DbSkip( -1 ),;
                oPhoto:LoadBMP( Clients->Photo ),;
                cName   := Clients->Name,     oName:Refresh(),;
                cAdress := Clients->Adress,   oAdress:Refresh(),;
                cCountry := Clients->Country, oCountry:Refresh(),;
                lActive  := Clients->Active,  oActive:Refresh(),;
                cNotes  := StrTran( Clients->Notes, Chr( 141 ) + Chr( 10 ), "" ),;
                           oNotes:Refresh(),;
                oRecNo:SetText( Str( RecNo(), 5 ) ) )

   REDEFINE BUTTON ID 170 OF oDlg ACTION MsgStop( "Only available in commercial version" )
   REDEFINE BUTTON ID 180 OF oDlg ACTION MsgStop( "Only available in commercial version" )
   REDEFINE BUTTON ID 190 OF oDlg ACTION MsgStop( "Only available in commercial version" )
   REDEFINE BUTTON ID 200 OF oDlg ACTION MsgStop( "Only available in commercial version" )
   REDEFINE BUTTON ID 210 OF oDlg ACTION MsgStop( "Only available in commercial version" )

   REDEFINE BUTTON ID 240 OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

   USE

return

//----------------------------------------------------------------------------//

function About()

   local oDlg
   local cAuthors := OemToAnsi( "(c) Antonio Linares && Francisco Pulpn" )

   DEFINE DIALOG oDlg RESOURCE "About"

   REDEFINE SAY ID 10 OF oDlg          // Just to make them 3D Look
   REDEFINE SAY ID 20 OF oDlg
   REDEFINE SAY ID 30 OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

return

//----------------------------------------------------------------------------//

function Exit()

   local oDlg

   DEFINE DIALOG oDlg RESOURCE "Exit"

   REDEFINE SAY ID 10 OF oDlg
   REDEFINE BITMAP ID 110 OF oDlg RESOURCE "Question"

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == 1                     // IDOK
      oWnd:End()
   endif

return

//----------------------------------------------------------------------------//
