//----------------------------------------------------------------------------
//           Name: Box2()
//        Purpose: Display a box
//
//         Author: Wilson H. Yuen
//   Date created: 03-21-93
//   Time created: 05:52:11pm
//      Copyright: Wilson H. Yuen
//
//         Syntax: Box( nTop, nLeft, nBottom, nRight, cFrame, cColor,
//                      nShadow, lClrBox ) --> NIL
//
//       Argument: nTop    - box top coordinate
//                 nLeft   - box left coordinate
//                 nBottom - box bottom coordinate
//                 nRight  - box right coordinate
//                 cFrame  - character to use for box frame
//                           default is single line
//                 cColor  - color to use, default current color
//                 nShadow - shadow location,  default 0
//                 lClrBox - clear inside of box, default is .t.
//
//   Return Value: NIL
//
//    Description: When a screen is saved to a character string, every
//                 other character starting with the first contains the
//                 screen character.  Every other character starting
//                 with the second character is the color attribute of
//                 the character.  We will change every other character
//                 starting with the second character to Chr(8) aka "".
//
//                 Special thanks to Edward M. Stoll of C.W. Kreimer &
//                 Assoc. for showing me a better way of changing the
//                 color attribute by using the Stuff().
//
//        Example: Box(1,1,10,50)
//
//----------------------------------------------------------------------------
#include "Note.ch"

function Box2( nTop, nLeft, nBottom, nRight, cFrame, cColor, nShadow, lClrBox )
    local nShadowTop                          //-- top shadow coordinate.
    local nShadowBottom                       //-- bottom shadow coordinate.
    local nShadowLeft                         //-- left shadow coordinate.
    local nShadowRight                        //-- right shadow coordinate.
    local cOldColor := SetColor( cColor )     //-- get/set current color setting.
    local cScreen                             //-- area of screen to shadow.
    local nScreenLen                          //-- length of cScreen.
    local X                                   //-- FOR/NEXT loop counter

    DEFAULT cColor  TO SetColor()
    DEFAULT nShadow TO 0
    DEFAULT lClrBox TO .t.
    HIGHLIMIT( nTop, nBottom )

    *-------------------------------
    * Draw box                     |
    *-------------------------------
    if lClrBox
       @ nTop, nLeft CLEAR TO nBottom, nRight
    endif
    DispBox( nTop, nLeft, nBottom, nRight, cFrame, cColor )

    if nShadow # 0
       *-------------------------------
       * Draw shadow                  |
       * Left                         |
       *-------------------------------
       if nShadow == 7 .or. nShadow == 4 .or. nShadow == 1
           nShadowTop    := nTop + if( nShadow == 1, 1, 0 )
           nShadowRight  := nLeft - 1
           nShadowLeft   := nLeft - 2
           nShadowBottom := nBottom + if( nShadow == 1, 1, 0 ) - if( nShadow == 7, 1, 0 )
           cScreen       := SaveScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight )
           nScreenLen    := Len( cScreen )

           *-- Change the color attribute for each character.
           For X:=2 to nScreenLen  STEP 2
               cScreen := Stuff( cScreen, X, 1, "" )  //-- chr(8)
           Next
           RestScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight, cScreen )

       endif

       *-------------------------------
       * Bottom                       |
       *-------------------------------
       if nShadow == 1 .or. nShadow == 2 .or. nShadow == 3
           nShadowTop    := nShadowBottom := nBottom + 1
           nShadowLeft   := nLeft  + if( nShadow == 3, 1, 0)
           nShadowRight  := nRight - if( nShadow == 1, 1, 0 )
           cScreen       := SaveScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight )
           nScreenLen    := Len( cScreen )

           *-- Change the color attribute for each character.
           For X:=2 to nScreenLen  STEP 2
               cScreen := Stuff( cScreen, X, 1, "" )  //-- chr(8)
           Next
           RestScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight, cScreen )
       endif


       *-------------------------------
       * Right                        |
       *-------------------------------
       if nShadow == 3 .or. nShadow == 6 .or. nShadow == 9
           nShadowTop    := nTop + if( nShadow == 3, 1, 0 ) - if( nShadow == 9 , 1, 0 )
           nShadowRight  := nRight + 2
           nShadowLeft   := nRight + 1
           nShadowBottom := nBottom + if( nShadow == 3, 1, 0 ) - if( nShadow == 9, 1, 0)
           cScreen       := SaveScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight )
           nScreenLen    := Len( cScreen )

           *-- Change the color attribute for each character.
           For X:=2 to nScreenLen  STEP 2
               cScreen := Stuff( cScreen, X, 1, "" )  //-- chr(8)
           Next
           RestScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight, cScreen )

       endif

       *-------------------------------
       * Top                          |
       *-------------------------------
       if ( nShadow == 7 .or. nShadow == 8 .or. nShadow == 9 ) .and. nTop > 0
           nShadowTop   := nShadowBottom := nTop - 1
           nShadowLeft  := nLeft  - if( nShadow == 7, 2, 0 ) + if( nShadow == 9, 1, 0 )
           nShadowRight := nRight - if( nShadow == 7, 1, 0 )
           cScreen       := SaveScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight )
           nScreenLen    := Len( cScreen )

           *-- Change the color attribute for each character.
           For X:=2 to nScreenLen  STEP 2
               cScreen := Stuff( cScreen, X, 1, "" )  //-- chr(8)
           Next
           RestScreen( nShadowTop, nShadowLeft, nShadowBottom, nShadowRight, cScreen )

       endif
    endif
    SetColor( cOldColor )

return( NIL )
* eof Box2()
*
*
