*****************
*
* Syntax:   Seek( <seekval> [, <switches> 
*                [, <expression to return> ] ] )
* <seekval>   - value to seek.  Any type - must be same as index, however.
* <switches>  - 'S'oftseek:   'S' = on, 's' = off
*               'E'xact:      'E' = on, 'e' = off
*               'O'rder:      'Ox", where 'x' is a value from 0-F (hexadecimal)
*                             i.e., index order set to 10 would be "OA".
*               'R'estore:    'R' = restore position, if not passed, stay where
*                             seek positions you.
*
*  Notes:   Seeks <seekval>, with the switches <soft> ('Ss' ), <exact> 'Ee',
*           and <restore position> ('R').  Uses FUNCKY's STATUS().  If you
*           don't have FUNCKy available, you could use the QLOG functions
*           contained in QUERY87 on most Clipper boards.  ATTENTION!!! The
*           switches are case-sensitive, so make sure you pay attention in
*           your code: UPPERCASE=ON, lowercase=off.  If 'R' is omitted, 
*           position is not restored.  All other flags are set back to what
*           they were before seek() was called.
*
*           
******************
function seek
parameter skval, switches, retexp
private pc, saverec, savesoft, saveexact, saveord, foundit, i
pc = pcount()
if m->pc < 1
  @ 0,0 SAY 'Seek( <seekval> [, <soft/exact/restore> [, <ret.exp.> ] ] )'
  return .f.
endif
if m->pc < 3
  switches = if( m->pc < 2, '', m->switches )
  retexp   = "! eof()"
endif

saverec   = recno()
savesoft  = status( 17 )
saveexact = status( 10 )
saveord   = indexord()

if ! empty( m->switches )
  if 'S' $ m->switches
    set softseek on
  elseif 's' $ m->switches
    set softseek off
  endif
  if 'E' $ m->switches
    set exact on
  elseif 'e' $ m->switches
    set exact off
  endif

  i = at( 'O', upper( m->switches ) )
  if m->i # 0 .and. len( m->switches ) > m->i
    i = at( upper( substr( m->switches, m->i + 1, 1 ) ), '0123456789ABCDEF' ) - 1
    if m->i >= 0
      set order to ( m->i )
    endif
  endif

endif

if indexord() # 0
  seek m->skval
else
  if type( 'm->skval' ) = 'N'
    goto m->skval
  endif
endif

foundit = &retexp
if 'R' $ m->switches
  go m->saverec
endif

set softseek ( m->savesoft )
set exact ( m->saveexact )
set order to ( m->saveord )

return m->foundit

*******************
*
* Syntax: SmartSeek( <alias names>, <seek value> )
*
* Notes.: Performs a seek on multiple files, starting with the first alias
*         in the list until <seek value> is found in the current index for
*         an alias.  Returns the name of the alias, and leaves the record
*         pointer at the sought position.  Uses JFK's or FUNCKY's chrcount(),
*         RVH's lstset().
*
*******************

function smartseek
parameter alii, seekval
private cural, i, l
i = pcount()
if m->i < 2
  @ 0,0 say 'SmartSeek( <alias names>, <seek value> )'
  return .f.
endif
if empty( m->alii )
  return seek( m->seekval )
endif

l = chrcount( ',', m->alii ) + 1
i = 0
do while m->i < m->l
  i = m->i + 1
  cural =  lstset( m->alii, m->i )
  success = &cural->( seek( m->seekval ) )
  if m->success
    exit
  endif
enddo

if m->success
  return m->cural
endif

return ''
