#include "inkey.ch"


FUNCTION Spool( cLisDir )
LOCAL cAntColor, ;
      nCont, ;
      cSinExt, ;
      cConExt, ;
      nNumFic, ;
      cSelFic, ;
      bColumna, ;
      bColum1, ;
      bColum2, ;
      bGeneral, ;
      bImpr, ;
      bSpool, ;
      bList, ;
      nTecla, ;
      nPuntFic  := 1, ;
      nPuntExt  := 1, ;
      nPuntSpl  := 1, ;
      nPuerto   := 0, ;
      nVentana  := 1, ;
      aFichSpl  := {}, ;
      aDirec    := {}, ;
      aTabScr   := {}, ;
      aSpool    := {}, ;
      aConfir   := { " Si ", " No " }, ;
      aMenu     := { "LPT1", "LPT2", "LPT3" }, ;
      aScreen, ;
      nRow, ;
      nCol

PUBLIC nX := 1      // this var is public to fixed the bug with codeblocks
                    // in tbrowses. You can change this var to LOCAL or
                    // STATIC creating a function and returning a codeblock.



    nRow    := Row()
    nCol    := Col()
    aScreen := SaveScr( 0, 0, MaxRow(), MaxCol(), 1 + nRandom( 3 ) )
    cAntColor := SetColor()
    IF Empty( cLisDir )
      cLisDir := "\" + CurDir() + "\"
    ENDIF
    aDirec := Directory( cLisDir + "*.*" )
    IF ! Empty( aDirec )
      nNumFic := Len( aDirec )
      FOR nCont := 1 To nNumFic
        cSinExt := iif( at( ".", right( aDirec[ nCont, 1 ], 4 ) ) > 0, ;
                        padr( left( aDirec[ nCont, 1 ], at( ".", aDirec[ nCont, 1 ] ) -1 ), 9, " " ), ;
                        padr( aDirec[ nCont, 1 ], 9, " " ) )
        cSinExt += iif( at( ".", right( aDirec[ nCont, 1 ], 4 ) ) > 0, ;
                        padr( substr( aDirec[ nCont, 1 ], at( ".", aDirec[ nCont, 1 ] ) + 1 ), 3, " " ), ;
                        "   " )
        aAdd( aTabScr, { cSinExt + SPACE( 3 ) + dtoc( aDirec[ nCont, 3 ] ) + ;
                         SPACE( 2 ) + aDirec[ nCont, 4 ] } )
        cSinExt := ""
      NEXT
      nCont := 0
    ELSE
      alert( "There's no files to print" )
      RETURN NIL
    ENDIF

    bList                := TBrowseNew( 10, 3, 21, 37 )
    bColumna             := TBcolumnNew( , { || aTabScr[ nX, 1 ] } )
    bList:addColumn( bColumna )
    bList:colorSpec      := "W/B, W+/R, GR+/B, GR+/R"
    bList:skipBlock      := { |y| PasArray( aTabScr, y ) }
    bList:goTopBlock     := { || IniArray() }
    bList:goBottomBlock  := { || FinArray( len( aTabScr ) ) }
    bColumna:colorBlock  := { || { 1, 2 } }

    bImpr                := TBrowseNew( 10, 57, 12, 61 )
    bColum1              := TBcolumnNew( , { || aMenu[ nX ] } )
    bImpr:addColumn( bColum1 )
    bImpr:colorSpec      := "W/B, W+/R, GR+/B, GR+/R"
    bImpr:skipBlock      := { |y| PasArray( aMenu, y ) }
    bImpr:goTopBlock     := { || IniArray() }
    bImpr:goBottomBlock  := { || FinArray( len( aMenu ) ) }
    bColum1:colorBlock   := { || { 1, 2 } }

    bSpool               := TBrowseNew( 18, 41, 21, 76 )
    bColum2              := TBcolumnNew( , { || aSpool[ nX ] } )
    bColum2:Width        := 34
    bSpool:addColumn( bColum2 )
    bSpool:colorSpec     := "W/B, W+/R, GR+/B, GR+/R"
    bSpool:skipBlock     := { |y| PasArray( aSpool, y ) }
    bSpool:goTopBlock    := { || IniArray() }
    bSpool:goBottomBlock := { || FinArray( len( aSpool ) ) }
    bColum2:colorBlock   := { || { 1, 2 } }

    setcolor( "W/B, W+/R, , , W/B" )
    BoxOpen( 1, 0, 23, 79, "B" )
    BoxOpen( 2, 2,  4, 77, "B" )
    @ 3, 29 SAY "FAST.lib PRINTER MANAGER" COLOR "GR+/B"
    setcursor( 0 )
    WHILE .T.
      IF lastkey() == K_TAB
        IF nVentana == 3
          nVentana := 1
        ELSE
          nVentana++
        ENDIF
      ENDIF
      IF lastkey() == K_ESC
        If BoxQuery( "Are you sure you want to exit? (Y/N)" )
          EXIT
        EndIf
      ENDIF
      Ventanas( nVentana )
      DO CASE
        CASE nVentana == 1
          iif( len( aSpool ) > 0, pRestart(), )
          bGeneral := bList
          nPuntSpl := nX
          nX := nPuntFic
        CASE nVentana == 2
          bGeneral := bImpr
          nPuntFic := nX
          nX := nPuntExt
          EstImpr( nPuerto )
        CASE nVentana == 3
          IF ! IsPrint()
            alert( "PRINT not loaded" )
            bGeneral := bList
            nPuntSpl := nX
            nX := nPuntFic
            nVentana := 1
            Ventanas( nVentana )
          ELSE
            aSpool := {}
            @ 18, 41 CLEAR TO 21, 76
            aSpool = pQueue()
            IF len( aSpool ) > 0
              bGeneral := bSpool
              nPuntExt := nX
              nX := nPuntSpl
              bGeneral:refreshAll()
            ELSE
              alert( "Sorry, spool is empty" )
              bGeneral := bList
              nPuntSpl := nX
              nX := nPuntFic
              nVentana := 1
              Ventanas( nVentana )
            ENDIF
          ENDIF
      END
      WHILE .T.
        WHILE ! bGeneral:stabilize()
          nTecla := Inkey()
          IF nTecla != 0
            EXIT
          ENDIF
        END
        IF bGeneral:stable
          IF ( bGeneral:hitTop .OR. bGeneral:hitBottom ) .AND. nTecla != 0
            Tone( 500, 1 )
          ENDIF
          nTecla := Inkey( 1 )
        ENDIF
        DO CASE
           CASE nTecla == K_F1
             BoxWarning( { "", ;
                           "This program has been ideated, created and published by Grupo EIDOS", ;
                           "in your book 'Maestros en Clipper, 1992'", ;
                           "", ;
                           "Improved and addapted to FAST.lib by Manu Roibal", ;
                           "" ;
                         } )
          CASE nTecla == K_TAB .OR. nTecla == K_ESC
            bGeneral:dehilite()
            EXIT
          CASE nTecla == K_UP .OR. nTecla == K_LEFT
            bGeneral:up()
            IF nVentana == 2
              iif( nPuerto > 0, nPuerto--, nPuerto )
              EstImpr( nPuerto )
            ENDIF
          CASE nTecla == K_DOWN .OR. nTecla == K_RIGHT
            bGeneral:down()
            IF nVentana == 2
              iif( nPuerto < 2, nPuerto++, nPuerto )
              EstImpr( nPuerto )
            ENDIF
          CASE nTecla == K_PGUP
            bGeneral:pageDown()
          CASE nTecla == K_PGDN
            bGeneral:pageUp()
          CASE nTecla == K_HOME
            bGeneral:home()
          CASE nTecla == K_END
            bGeneral:end()
          CASE nTecla == K_RETURN .AND. nVentana == 1
            IF BoxQuery( "Send the File to Spool? (Y/N)" )
              cSelFic := left( aTabScr[ nX, 1 ], 12 )
              cConExt := iif( empty( alltrim( right( cSelFic, 3 ) ) ), ;
                              alltrim( cSelFic ), ;
                              left( cSelFic, at( " ", cSelFic ) - 1 ) + "." + ;
                                  alltrim( right( cSelFic, 3 ) ) )
              pAddFile( TrueName( ALLTRIM( cConExt ) ) )
            EndIf
          CASE nTecla == K_F2 .AND. nVentana == 3
            IF BoxQuery( "Delete the Spool? (Y/N)" )
              pDelAll()
              aSpool := {}
              @ 18, 41 CLEAR TO 21, 76
              bGeneral := bList
              bGeneral:refreshAll()
              nVentana := 1
              Ventanas( nVentana )
              nCont := 0
            EndIf
          CASE nTecla == K_DEL .AND. nVentana == 3
            IF BoxQuery( "Delete the File from the Spool? (Y/N)" )
              pDelFile( TrueName( aSpool[ nX ] ) )
              aDel( aSpool, nX )
              aSize( aSpool, len( aSpool ) - 1 )
              IF len( aSpool ) > 0
                bGeneral:refreshAll()
                nCont--
                pRestart()
              ELSE
                @ 18, 41 CLEAR TO 21, 76
                bGeneral := bList
                bGeneral:refreshAll()
                nVentana := 1
                Ventanas( nVentana )
                nCont := 0
              ENDIF
            ENDIF
        END
      END
    END
    RestScr( 0, 0, MaxRow(), MaxCol(), aScreen, 40 )
    SetPos( nRow, nCol )
RETURN NIL


FUNCTION PasArray( aArrayMov, nNum )
LOCAL nIntentos := 0
    IF nNum > 0
      WHILE nIntentos < nNum
        MEMVAR->nX++
        IF MEMVAR->nX > len( aArrayMov )
          MEMVAR->nX--
          EXIT
        ENDIF
        nIntentos++
      END
    ELSE
      WHILE nIntentos > nNum
        MEMVAR->nX--
        IF MEMVAR->nX < 1
          MEMVAR->nX++
          EXIT
        ENDIF
        nIntentos--
      END
    ENDIF
RETURN nIntentos


FUNCTION IniArray()
    MEMVAR->nX := 1
RETURN NIL


FUNCTION FinArray( nPosic )
    MEMVAR->nX := nPosic
RETURN NIL



FUNCTION Ventanas( nVentana )
LOCAL xPantalla
LOCAL aBox
    DispBegin()
    xPantalla := SaveScreen( 10, 3, 21, 37 )
    aBox := BoxOpen( 5, 2, 22, 38, "B" )
    If nVentana != 1
      BoxTurn( aBox, .F. )
    EndIf
    RestScreen( 10, 3, 21, 37, xPantalla )
    @  6, 4 SAY "FILES"
    @  7, 4 SAY Replicate( "", 33 ) COLOR "N/B"
    @  8, 4 SAY "NAME           DATE       TIME"
    @  9, 4 SAY Replicate( "", 33 ) COLOR "N/B"
    xPantalla := SaveScreen( 10, 41, 13, 76 )
    aBox := BoxOpen( 5, 40, 14, 77, "B" )
    If nVentana != 2
      BoxTurn( aBox, .F. )
    EndIf
    RestScreen( 10, 41, 13, 76, xPantalla )
    @  6, 42 SAY "PRINTER"
    @  7, 42 SAY Replicate( "", 34 ) COLOR "N/B"
    @  8, 42 SAY "PRINT          PORT   STATUS"
    @  9, 42 SAY Replicate( "", 34 ) COLOR "N/B"
    xPantalla := SaveScreen( 18, 41, 21, 76 )
    aBox := BoxOpen( 15, 40, 22, 77, "B" )
    If nVentana != 3
      BoxTurn( aBox, .F. )
    EndIf
    RestScreen( 18, 41, 21, 76, xPantalla )
    @ 16, 42 SAY "SPOOL"
    @ 17, 42 SAY Replicate( "", 34 ) COLOR "N/B"
    LineaAyuda( nVentana )
    DispEnd()
RETURN NIL



FUNCTION EstImpr( nPuerto )
    DispBegin()
    @ 10, 42 SAY iif( IsPrint(),                  "INSTALLED    ", "NOT INSTALLED" )
    @ 10, 65 SAY iif( GetPrinter( nPuerto ) == 0, "ON LINE   ",    "OFF LINE  " )
    @ 11, 65 SAY iif( GetPrinter( nPuerto ) == 2, "W/O PAPER ",    "WITH PAPER" )
    @ 12, 65 SAY iif( GetPrinter( nPuerto ) == 1, "BUSY      ",    "NOT BUSY  " )
    @ 13, 65 SAY iif( GetPrinter( nPuerto ) == 5, "ERROR     ",    "NORMAL    " )
    DispEnd()
RETURN NIL


FUNCTION LineaAyuda( nVentana )
    DO CASE
      CASE nVentana == 1
        LinAyuda( { "Tab", "Window", "Esc", "Exit", "<",  "File To Spool", "F1", "About" } )
      CASE nVentana == 2
        LinAyuda( { "Tab", "Window", "Esc", "Exit" } )
      CASE nVentana == 3
        LinAyuda( { "Tab", "Window", "Esc", "Exit", "Del", "Delete File", "F2", "Delete All" } )
    ENDCASE
RETURN NIL
