*----------------------------------------------------------------------
* Implementation of a SET KEY TO ...-like function for FORCE
* (C) Copyright KRS Unternehmensberatung-EDV GmbH
*               Postfach 1265
*               D 5093 Burscheid
* Author:       Wolfgang Manousek
*               CIS 100010,2071
* Editor:       KRS ETP, Vers. 2.1
*               tabs 4,7
* Environment:  FCO 2.1 d
*
*----------------------------------------------------------------------
*
* Revision:    1.0   Mrz 1991       Wolfgang Manousek
*                    Initial Release
*----------------------------------------------------------------------

#include io.hdr
#include macros.hdr
#include setkey.hdr

#pragma W_FUNC_PROC-
#pragma W_INDIRECT-


#define     KTABSIZE    30                   && Maximum number of the
                                             && keys we are able to redefine

vardef private                               && Two tables to remember the
                                             && desired redifinition:
   uint     aKeyCode[&KTABSIZE]              && The keycodes and
   ulong    aKeyFunc[&KTABSIZE]              && the corresponding table
                                             &&   for the functions.
   int      iKeyTabPos          = -1         && Index to the next free
                                             && tableentry.
enddef

* Local Prototypes
   function int _FindSetKey prototype
      parameters  value uint uiSearchCode

   function ulong _DelSetKey prototype
      parameters  value uint uiSearchCode

   procedure _InsertSetKey prototype
      parameters  value uint  uiKeyCode,;
                  value ulong ulKeyFunc

   function uint _CallKeyMacro prototype
      parameters  value ulong Adresse

procedure InitSetKey
   * Initialise the tables. Just put the position-pointer to its
   * initial value.
   iKeyTabPos = -1
endpro

function uint DispatchKey
   vardef
      uint  uiKeyCode
      ulong ulKeyFunc
   enddef

   on key do                              && Deactivate ON KEY DO to prevent
                                          && a recursive call
   uiKeyCode = lastkey()
   ulKeyFunc = GetSetKey(uiKeyCode)
   if ulKeyFunc <> 0
      uiKeyCode = _CallKeyMacro(ulKeyFunc)
      keyboard(" ")
      do while is_key() <> 0              && Delete all waiting keys in the
         get_key()                        && Keyboard-buffer
      enddo
   endif

   on key do DispatchKey                  && Reactivate ON KEY DO
   return(uiKeyCode)
endpro

function ulong GetSetKey
   parameters  value uint uiSearchCode
   * Get a Functions-adress from the translation-table.
   * Parameters:
   *     uiSearchCode   -  The keycode we have to look for.
   * Returns:
   *     0              -  The keycode isn't defined
   *     <ulong>        -  funktion-adress
   vardef
      int   iCounter
   enddef
   iCounter = _FindSetKey(uiSearchCode)
   if (iCounter = -1)
      return(0)
   endif
   return(aKeyFunc[iCounter])
endpro

function ulong DefineSetKey
   parameters  value uint  uiKeyCode,;
               value ulong ulKeyFunc
   * Define a function-adress in the translation-table.
   * Parameter:
   *     uiKeyCode      -  The KeyCode
   *     ulKeyFunc      -  Adress of function to call if uiKeyCode has been
   *                       pressed. Is this value 0 or MAXULONG, the function
   *                       will delete the uiKeyCode-entry from the
   *                       translation-table.
   * Rckgabe:
   *     0              -  okay
   *     MAXULONG       -  Tabele full. Can't insert new key
   *     <ulong>        -  function-adress which has been set before the
   *                       replace or delete
   vardef
      int   iCounter
      ulong ulResult
   enddef
   ulResult = _DelSetKey(uiKeyCode)
   if (iKeyTabPos = &KTABSIZE)
      return(&MAXULONG)
   endif
   if (ulKeyFunc = 0) .or. (ulKeyFunc = -1)
      return(ulResult)
   endif
   _InsertSetKey(uiKeyCode,ulKeyFunc)
   return(ulResult)
endpro


*---------------------------------------------------------------------------
* Local Funktionen
function int _FindSetKey
   parameters  value uint uiSearchCode
   * Look for a entry in the translation-table
   * Parameter:
   *     uiSearchCode   -  The KeyCode
   * Return:
   *     -1             -  Key wasn't found
   *     <int>          -  Table-index
   vardef
      int   iCounter
   enddef
   for iCounter=0 to iKeyTabPos
      if aKeyCode[iCounter] = uiSearchCode
         return(iCounter)
      endif
   next
   return(-1)
endpro

function ulong _DelSetKey
   parameters  value uint uiSearchCode
   * Delte a Entry from the translation-table
   * Parameter:
   *     uiSearchCode   -  The Key
   vardef
      int      iPos
      int      iCounter
      ulong    ulReturn
   enddef
   iPos = _FindSetKey(uiSearchCode)
   if iPos = -1
      return(0)
   endif
   ulReturn = aKeyFunc[iPos]
   for iCounter= iPos to (iKeyTabPos-1)
      aKeyCode[iCounter] = aKeyCode[iCounter+1]
      aKeyFunc[iCounter] = aKeyFunc[iCounter+1]
   next
   iKeyTabPos= iKeyTabPos-1
   return(ulReturn)
endpro

procedure _InsertSetKey
   parameters  value uint  uiKeyCode,;
               value ulong ulKeyFunc
   * Define a function-adress in the translation-table
   * Parameter:
   *     uiKeyCode      -  The key
   *     ulKeyFunc      -  Adress of function to call
   iKeyTabPos = iKeyTabPos+1
   aKeyCode[iKeyTabPos] = uiKeyCode
   aKeyFunc[iKeyTabPos] = ulKeyFunc
endpro

function uint _CallKeyMacro
   parameters  value ulong Adresse
   IndCall()
endpro


* End Of File