*=========================================================*
* Author : Mathieu De Smet                                *
* CIS    : 100140,1375                                    *
* Country: Belgium                                        *
* Data   : July 20, 1994                                  *
*=========================================================*

*
*  Compile  CLIPPER FLAGS /M/N/V/W
*  Link     BLINKER FI FLAGS
*           RTLINK  FI FLAGS
*           ...
*

#include "Inkey.ch"

*=========================================================*
PROCEDURE Main()
LOCAL aFlags := {}
LOCAL nSel   := 1
LOCAL nPrev  := 0

LOCAL GetList
LOCAL nKey

 aAdd( aFlags, { |l| FBelgium( 02,02,l ) } )
 aAdd( aFlags, { |l| FFrance(  02,30,l ) } )
 aAdd( aFlags, { |l| FHolland( 02,60,l ) } )
 aAdd( aFlags, { |l| FGermany( 12,02,l ) } )
 aAdd( aFlags, { |l| FUSA(     12,30,l ) } )

 SETCOLOR( "W/B" )
 CLEAR

 SETCURSOR(0)
 aEVAL( aFlags, { |e| EVAL( e, .F. ) } )
 DO WHILE .T.
    IF nPrev != nSel
       IF nPrev > 0
          EVAL( aFlags[nPrev], .F. )
       ENDIF
       EVAL( aFlags[nSel], .T. )
       nPrev := nSel
    ENDIF
    nKey := INKEY(0)
    DO CASE
       CASE nKey == K_ESC
            EXIT
       CASE nKey == K_ENTER
            EXIT
       CASE nKey == K_LEFT  .OR. nKey == K_SH_TAB
            IF --nSel < 1
               nSel := LEN( aFlags )
            ENDIF
       CASE nKey == K_RIGHT .OR. nKey == K_TAB
            IF ++nSel > LEN( aFlags )
               nSel := 1
            ENDIF
    ENDCASE
 ENDDO

 DEVPOS( 22,1 )

 ? "You choose :"
 ?? nSel

RETURN
*=========================================================*



*=========================================================*
PROCEDURE FBelgium( nRow,nCol, lFlag )
LOCAL c := SETCOLOR()
LOCAL n
 SETCOLOR( "W/W" )
 @ nRow,nCol CLEAR TO nRow+7, nCol+16
 @ nRow+7,nCol+5 SAY "Belgium" COLOR IF( IF( lFlag == NIL, .F., lFlag ), "R+/W", "N/W" )
 FOR n := 0 TO 5
     @ nRow+1+n,nCol+1+00 SAY "" COLOR "N/W"
     @ nRow+1+n,nCol+1+05 SAY "" COLOR "GR+/W"
     @ nRow+1+n,nCol+1+10 SAY "" COLOR "R/W"
 NEXT
 SETCOLOR( c )
RETURN
*==========================================*



*==========================================*
PROCEDURE FFrance( nRow,nCol, lFlag )
LOCAL c := SETCOLOR()
LOCAL n
 SETCOLOR( "W/W" )
 @ nRow,nCol CLEAR TO nRow+7, nCol+16
 @ nRow+7,nCol+5 SAY "France" COLOR IF( IF( lFlag == NIL, .F., lFlag ), "R+/W", "N/W" )
 FOR n := 0 TO 5
     @ nRow+1+n,nCol+1+00 SAY "" COLOR "B/W"
     @ nRow+1+n,nCol+1+05 SAY "" COLOR "W+/W"
     @ nRow+1+n,nCol+1+10 SAY "" COLOR "R/W"
 NEXT
 SETCOLOR( c )
RETURN
*==========================================*



*==========================================*
PROCEDURE FHolland( nRow,nCol, lFlag )
LOCAL c := SETCOLOR()
LOCAL n
 SETCOLOR( "W/W" )
 @ nRow,nCol CLEAR TO nRow+7, nCol+16
 @ nRow+7,nCol+5 SAY "Holland" COLOR IF( IF( lFlag == NIL, .F., lFlag ), "R+/W", "N/W" )
 FOR n := 0 TO 1
     @ nRow+1+n+0,nCol+1 SAY "" COLOR "R/W"
     @ nRow+1+n+2,nCol+1 SAY "" COLOR "W+/W"
     @ nRow+1+n+4,nCol+1 SAY "" COLOR "B/W"
 NEXT
 SETCOLOR( c )
RETURN

*==========================================*



*==========================================*
PROCEDURE FGermany( nRow,nCol, lFlag )
LOCAL c := SETCOLOR()
LOCAL n
 SETCOLOR( "W/W" )
 @ nRow,nCol CLEAR TO nRow+7, nCol+16
 @ nRow+7,nCol+5 SAY "Germany" COLOR IF( IF( lFlag == NIL, .F., lFlag ), "R+/W", "N/W" )
 FOR n := 0 TO 1
     @ nRow+1+n+0,nCol+1 SAY "" COLOR "N/W"
     @ nRow+1+n+2,nCol+1 SAY "" COLOR "R/W"
     @ nRow+1+n+4,nCol+1 SAY "" COLOR "GR+/W"
 NEXT
 SETCOLOR( C )
RETURN
*==========================================*



*==========================================*
PROCEDURE FUSA( nRow,nCol, lFlag )
LOCAL c := SETCOLOR()
LOCAL n
 SETCOLOR( "W/W" )
 @ nRow,nCol CLEAR TO nRow+7, nCol+16
 @ nRow+7,nCol+7 SAY "USA" COLOR IF( IF( lFlag == NIL, .F., lFlag ), "R+/W", "N/W" )

 @ nRow+1+00,nCol+1 SAY "XXXXXXX" COLOR "W+/B"
        @ nRow+1+00,nCol+8 SAY "" COLOR "W+/R"
 @ nRow+1+01,nCol+1 SAY "XXXXXXX" COLOR "W+/B"
        @ nRow+1+01,nCol+8 SAY "" COLOR "W+/R"
 @ nRow+1+02,nCol+1 SAY "XXXXXXX" COLOR "W+/B"
        @ nRow+1+02,nCol+8 SAY "" COLOR "W+/R"
 @ nRow+1+03,nCol+1 SAY "" COLOR "W+/R"
 @ nRow+1+04,nCol+1 SAY "" COLOR "W+/R"
 @ nRow+1+05,nCol+1 SAY "" COLOR "W+/R"
 SETCOLOR( C )
RETURN
*=========================================================*

