*
***************
FUNCTION FINDIT
***************
*
* Author: Cliff Peterson
*
*         Cliff Peterson and Associates
*         Suite 258, 1702 West Camelback Road
*         Phoenix, AZ 85015
*         (602) 242-8286
*
* Syntax: FINDIT( <expC>, <expC> )
*
* Use:    Find the first <expC> in the field(s) specified in the second
*         <expC>.  Performs a modified binary search, looking for the
*         first occurrence.  USEd field MUST be in the same sequence as
*         the fields in the second <expC>.  Search is case insensitive.
*
* Return: .T. if substring match is found, otherwise .F.
*
* Example: If OWNER.DBF is in NAME sequence, then:
*
*          USE OWNER
*          X = FINDIT("JONES","NAME")
*
*          will find "Jones, John" (first JONES) and return .T.
*
* Comment: In very large files, the indexes can require as much file
*          space as the DBF indexed.  If you're short of file space
*          and still wish to SEEK on a key, this is the ticket.  The
*          number of GOTOs performed is a power of two, and runs very
*          quickly.  Remember, the file must be in the sequence of the
*          desired search key.
*
PARAMETERS LOOKSTR, FIELD
    LOOKSTR = UPPER(TRIM(LOOKSTR))
    LOWLIM = 0
    UPLIM = RECCOUNT() + 1
    DO WHILE UPLIM > LOWLIM + 1
        POINT = INT((UPLIM - LOWLIM) / 2) + LOWLIM
        GOTO POINT
        DO CASE
            CASE LOOKSTR > SUBSTR(UPPER(&FIELD),1,LEN(LOOKSTR))
                LOWLIM = POINT
            CASE LOOKSTR < SUBSTR(UPPER(&FIELD),1,LEN(LOOKSTR))
                UPLIM = POINT
            OTHERWISE
                IF POINT = LOWLIM + 1
                    RETURN(.T.)
                ENDIF
                UPLIM = POINT + 1
        ENDCASE
    ENDDO
RETURN(.F.)
