*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

*  WINDOW.PRG

FUNC window
   PARA top_row,left_col,bot_row,right_col

   PRIVATE firstrow, ;  &&  starting row
           mquit , ;    &&  Logical Quit/ not Quit
           keypress,;   &&  ASCII of key pressed
           mloop   ,;   &&  Logical Loop/ not Loop
           lastrow ,;   &&  last row displayed in browse
           cur_row ,;   &&  current row of cursor
           mchoice ,;   &&  choice of keystroke
           old_screen,;
           last_col,;
           white,;
           mret        && screen to return

   DO set_browse

   mret = SAVESCR(top_row,MAX(left_col-1,0),MIN(bot_row+1,24),right_col)

   * see if any GROUP is specified:
   IF TYPE([M->group_key]) = [U]
      group_key = []
   ENDIF
   IF TYPE([M->group]) = [U]
      group  = IF(EMPTY(M->Group_key), [], &group_key)
   ENDIF

   key_field     = IF(TYPE([M->key_field])=[U], INDEXKEY(0), M->key_field)
   default_color = IF(TYPE([default_color])=[U],.T.,default_color)
   wprompt       = IF(TYPE([wprompt])=[U],'Press letter to list from, [Enter] to select a record, [Esc] to abort',wprompt)

   *  Screen 
   CO_PUSH()
   CO_CHG(0,c_frame)
   DRAWSHADOW(top_row,left_col,bot_row,right_col)
   CO_CHG(IF(default_color,c_window,curr_grp),c_frame)
   @ top_row,left_col,bot_row,right_col BOX stdbox
   CO_CHG(curr_grp,c_sayget)
   SCROLL(top_row+1,left_col+1,bot_row-1,right_col-1,0)   && Clears it

   IF ! EMPTY(mtitle)
      mtitle = [ ]+TRIM(LTRIM(mtitle))+[ ]
      xcol = left_col + (((right_col-left_col) - LEN(mtitle)) / 2)
      CO_CHG(curr_grp,c_title)
      @ top_row,xcol SAY mtitle
   ENDIF
   old_screen = SAVESCREEN(24,0,24,79)
   @ 24,0
   @ 24,0 SAY wprompt

   *  Ready to go 
   CURS_OFF()
   SET MESSAGE TO
   firstrow  = top_row+3
   mquit     = .F.
   white     = .F.
   PRIVATE mrec
   DO WHIL ! mquit
      CO_CHG(curr_grp,c_text)
      @ top_row+2,left_col+3 SAY wtitle
      CO_CHG(curr_grp,c_sayget)

      DO list_em
      white = .F.
      mloop = .T.
      DO WHIL mloop
         IF ! M->white
            DO rev_line
         ENDIF

         WINKEY()       && used so other hot keys can be caught with a custom winkey function
         keypress = LASTKEY()
         IF M->keypress = 28    &&   F1 for help
            DO whelp            &&   window help, in library
         ENDIF

         mchoice = UPPER(CHR(keypress))
         IF keypress =  13
            CURS_ON()
            RESTSCREEN(24,0,24,79,old_screen)
            CO_POP()
            RETURN mret
         ENDIF

         *  allow find on any letter pressed:
         IF ! CURSORKEY(keypress) .AND. ! ESC()
            *  not a direction key, so try seeking it
            IF ! EMPTY(INDEXKEY(0))   && there is an index in use
               PRIV mrec,seeking
               mrec      = RECNO()
               seeking   = M->group + UPPER(CHR(LASTKEY()))

               SOFT(M->seeking)
               DO list_em
               IF ! M->white
                  DO rev_line
               ENDIF

               DO WHILE .T.
                  keypress = INKEY(1)   &&  give 'em some time
                  IF CURSORKEY(M->keypress) .OR. M->keypress = 13 .OR. M->keypress = 27 .OR. M->keypress = 0
                     white = .F.
                     EXIT
                  ELSE
                     seeking = M->seeking + UPPER(CHR(M->keypress))
                     SOFT(M->seeking)
                     DO list_em
                  ENDIF
               ENDDO

               IF EOF()
                  GOTO mrec
                  LOOP
               ENDIF
               LOOP
            ENDIF
         ENDIF

         DO rev_line
         DO cursor
     ENDDO
   ENDDO

   CO_POP()
   CURS_ON()
   RESTSCREEN(24,0,24,79,old_screen)
RETURN mret

PROC whelp
   DO hc_help WITH [windowhelp]
RETURN

FUNC winkey
   INKEY(0)
RETU []
