*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

* Disks.prg   collection of disk/drive/dos routines

FUNC drive              && used to check drive is ready, and space on drive
   PARA drive,spacecheck,spaceneed
   spacecheck = DEFAULT([spacecheck],.F.)
   PRIV mhandle,filename,mret,xchoice,mline
   filename = drive+[:TEMP.TRY]
   mhandle  = FCREATE(filename,0)
   mline    = SAVESCR(24,0,24,79)
   DO CASE
      CASE FERROR() = 0  && no error means drive exists
         mret = .T.
      CASE FERROR() = 3  && drive door open
         ?? CHR(7)
         DO kbhit WITH [Drive door is open.]
         mret = .F.
      CASE FERROR() = 5  && write protection enabled
         ?? CHR(7)
         DO kbhit WITH [Disk in drive is write-protected.]
         mret = .F.
      CASE FERROR() = 15  && invalid drive
         ?? CHR(7)
         DO kbhit WITH [Drive is invalid.]
         mret = .F.
      OTHERWISE   && other sundry errors
         ?? CHR(7)
         DO kbhit WITH [Error ]+STR(FERROR(),2,0)+[: Drive is not accessable.]
         mret = .F.
   ENDCASE
   IF spacecheck .AND. mret
      IF DISKSPACE(NUMDRIVE(M->drive)) < spaceneed
         mret = .F.
         DO kbhit WITH [Insufficient Disk Space On Drive &drive. ]
      ENDIF
   ENDIF
   FCLOSE(mhandle)  && get rid of temp file
   DELE FILE &filename
   RESTSCR(mline)
RETURN mret

FUNC numdrive    && required since clipper refers to drives internally as numerics
  PARA drive
RETU AT(drive,[ABCDEFGHIJ])

* 
FUNC makedir                  && create a directory and check it - only works down path
   PARA mdrive,mdirname
   PRIV mret,mcdir,mdisk,xchoice
   mret = .T.
   mdisk = mdrive+[:]
   RUN &mdisk
   mcdir =UPPER(CURDIR(mdrive))
   RUN MD &mdirname
   RUN CD &mdirname
   IF ! UPPER(CURDIR(mdrive)) = IF(!EMPTY(mcdir),mcdir+[\],[])+mdirname
      BOXX(0,0,[Unable to create directory. Installation aborting.])
      mret = .F.
   ENDIF
RETU mret

* 
FUNC dosver                               && checks for DOS 3.3 or greater
   PRIV mhandle, mdosver,mret,xchoice
   mdosver = SPAC(40)  && max length of return of DOS VER command

   RUN VER > TEMP  && pipe output to temp file for analysis
   IF FERROR() > 0  && error in making the temp file... big trouble
      BOXX(0,0,[Error in determining DOS version.  Please check your PATH.])
      RETU .F.
   ENDIF

   mhandle = FOPEN([temp])
   FSEEK(mhandle,0)
   FREAD(mhandle,@mdosver,40)
   DO CASE
      CASE [3.3] $ mdosver
         mret = .T.
      CASE [3.4] $ mdosver
         mret = .T.
      CASE [4.] $ mdosver
         mret = .T.
      OTHERWISE
         BOXX(0,0,[This system requires DOS version 3.3 or later. Installation aborting.])
         CLOSE DATA
         mret = .F.
   ENDCASE
   FCLOSE(mhandle)  && get rid of temp file
   DELETE FILE temp
RETU mret

FUNC filesize  && returns the number of bytes in file (mfile)
  PARA mfile   && useful in conjunction with DISKSPACE()
  PRIV handle,msize
  handle = FOPEN(mfile,0)
  msize  = FSEEK(handle,0,2)
  FCLOSE(handle)
RETU(msize)
