*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                      (703) 671 - 3003                                     *
*                                                                           *
*   The color routines and methodology used in this library were developed  *
*   by Scott Hurlbert and Art Salinas from Quantum Data Systems in          *
*   Bakersfield California.                                                 *
*                                                                           *
*****************************************************************************

DECLARE co1[11],co2[11],co3[11],co4[11],;  && save current colors to these
        no1[11],no2[11],no3[11],no4[11],;  && save new values to these
        cpx[6]                             && component position xref

ACOPY(color1,co1)
ACOPY(color2,co2)
ACOPY(color3,co3)
ACOPY(color4,co4)

cpx[1] = 1
cpx[2] = 4
cpx[3] = 7
cpx[4] = 10
cpx[5] = 15
cpx[6] = 18

CLEAR
CO_PUSH()                                     && updates variable co_stack
DO WHILE .T.
   CO_CHG(c_backdrop,c_sayget)
   @ 0,0 CLEAR
   CO_CHG(c_menus)
   DO box WITH 1, 2,18,13,[Video Mode]
   @  4,4 PROMPT [MONO       ]
   @  5,4 PROMPT [CGA        ]
   @  6,4 PROMPT [EGA        ]
   @  7,4 PROMPT [VGA        ]
   MENU TO vchoice

   IF vchoice = 0
      EXIT
   ENDIF
   vsel = SUBS([MONOCGA EGA VGA ],((vchoice-1)*4)+1,4)

   DO WHILE .T.
      CO_CHG(c_backdrop,c_sayget)
      @ 24,0
      @ 0,18 CLEAR
      CO_CHG(c_menus,c_sayget)
      CO_CHG(M->curr_grp,M->c_frame)
      @  8,3 SAY REPLICATE(CHR(205),13)
      @ 10,3 SAY REPLICATE(CHR(205),13)
      CO_CHG(M->curr_grp,M->c_title)
      @  9,3 SAY [ Color Group ]
      CO_CHG(c_menus,c_sayget)
      @ 11,4 PROMPT [BACKDROP   ]
      @ 12,4 PROMPT [MENUS      ]
      @ 13,4 PROMPT [STATUS LINE]
      @ 14,4 PROMPT [BROWSE     ]
      @ 15,4 PROMPT [FULL SCREEN]
      @ 16,4 PROMPT [WINDOW/PICK]
      @ 17,4 PROMPT [HELP SCREEN]
      @ 18,4 PROMPT [POP-UP 1   ]
      @ 19,4 PROMPT [POP-UP 2   ]
      @ 20,4 PROMPT [POP-UP 3   ]
      @ 21,4 PROMPT [ERRORS     ]
      MENU TO gchoice
      IF gchoice = 0
         EXIT
      ENDIF
      gsel = SUBS([00]+LTRIM(STR(gchoice,2)),-2)

      @ 1,19,9,55 BOX stdbox + [ ]
      CO_CHG(M->curr_grp,M->c_text)
      @ 2,22 SAY [Attribute:]
      @ 5,22 SAY [Component:]
      DO box WITH 1,58,18,19,[Colors]
      CO_CHG(M->curr_grp,M->c_text)
      @  4,60 SAY [Fore/Background]
      @ 13,60 SAY [Background Only]

      DO co_load WITH vsel

      DO co_edit

      DO co_load WITH videotype

   ENDDO
ENDDO

* re-load system color values
DO co_load WITH videotype
CO_POP()
RETURN

*
PROCEDURE co_edit
   PRIVATE sel,melement,moffset,item_max,comp_max,colo_max,cur_item,cur_comp,cur_colo
   attr_max = 4     && sayget/frame/text/title
   item_max = 3     && say/get/unselect
   comp_max = 6     && fore/back
   colo_max = 16    && black-white
   cur_attr = 1
   cur_item = 1
   cur_comp = 1
   cur_arry = [COLOR] + STR(cur_attr,1)
   cur_colo = VAL(SUBS(&cur_arry[gchoice],cpx[cur_comp],2))+1
   KEYBOARD CHR(13)
   curs_stat = M->cursoron
   CURS_OFF()
   DO WHILE .T.
      chg_flag = .F.
      sel = INKEY(0)
      DO CASE
         CASE sel = 5  && UP
            cur_colo = IF(cur_colo>1,cur_colo-1,colo_max)
            &cur_arry[gchoice] = STUFF(&cur_arry[gchoice],cpx[cur_comp],2,SUBS([00]+LTRIM(STR(cur_colo-1,2)),-2))
            chg_flag = .T.

         CASE sel = 24 && DOWN
            cur_colo = IF(cur_colo<colo_max,cur_colo+1,1)
            &cur_arry[gchoice] = STUFF(&cur_arry[gchoice],cpx[cur_comp],2,SUBS([00]+LTRIM(STR(cur_colo-1,2)),-2))
            chg_flag = .T.

         CASE sel = 19 && LEFT
            IF cur_comp > 1
               cur_comp = cur_comp-1
            ELSE
               cur_attr = if(cur_attr>1,cur_attr-1,attr_max)
               cur_comp = comp_max
            ENDIF
            cur_arry = [COLOR] + STR(cur_attr,1)
            cur_colo = VAL(SUBS(&cur_arry[gchoice],cpx[cur_comp],2))+1

         CASE sel = 4  && RIGHT
            IF cur_comp < comp_max
               cur_comp = cur_comp+1
            ELSE
               cur_attr = if(cur_attr<attr_max,cur_attr+1,1)
               cur_comp = 1
            ENDIF
            cur_arry = [COLOR] + STR(cur_attr,1)
            cur_colo = VAL(SUBS(&cur_arry[gchoice],cpx[cur_comp],2))+1

         CASE sel = 27 && ESC cancel
            EXIT

         CASE sel = -2 && F3 save
            DO yes_no WITH [Save current settings?]
            IF myn = [Y]
               RELEASE mainmenu,backdrop
               DO co_save
               EXIT
            ELSE
               LOOP
            ENDIF

         CASE sel = 13 && Enter - just push through
            chg_flag = .T.

         OTHERWISE
            LOOP
      ENDCASE

      CO_PUSH()
      IF chg_flag
         * reset colors & repaint box

         CO_CHG(M->c_backdrop,M->c_sayget)
         @ 11,18 CLEAR TO 23,55
         CO_CHG(gchoice,M->c_frame)
         DO box WITH 12,22, 6,29,[Title]
         @ 12,24 SAY [Frame]
         @ 12,31 PROMPT [Sel Get]
         var1 = [UnSel Get]
         @ 12,40 GET var1
         CLEAR GETS
         KEYBOARD esc
         MENU TO dummy

         CO_CHG(gchoice,M->c_title)
         @ 14,28 PROMPT [Sel Get]
         var1 = [UnSel Get]
         @ 14,37 GET var1
         CLEAR GETS
         KEYBOARD esc
         MENU TO dummy

         CO_CHG(gchoice,M->c_text)
         @ 16,26 SAY [   Text]
         @ 17,26 SAY [   Text]
         @ 16,34 PROMPT [Selected Get]
         var1 = [Un-Selected Get]
         @ 17,34 GET var1
         CLEAR GETS
         KEYBOARD esc
         MENU TO dummy

         CO_CHG(gchoice,M->c_sayget)
         @ 19,26 SAY [Say/Get]
         @ 20,26 SAY [Say/Get]
         @ 19,34 PROMPT [Selected Get]
         var1 = [Un-Selected Get]
         @ 20,34 GET var1
         CLEAR GETS
         KEYBOARD esc
         MENU TO dummy

         DO saystat WITH [Left/Right to select Attribute & Component, Up/Down to select Color, F3 to Save.]
      ENDIF

      CO_POP()

      DO CASE
         CASE cur_comp < 3
            cur_item = 1
         CASE cur_comp < 5
            cur_item = 2
         OTHERWISE
            cur_item = 3
      ENDCASE

      ACOPY(color1,no1)
      ACOPY(color2,no2)
      ACOPY(color3,no3)
      ACOPY(color4,no4)

      ACOPY(co1,color1)
      ACOPY(co2,color2)
      ACOPY(co3,color3)
      ACOPY(co4,color4)

      CO_CHG(c_menus,c_sayget)

      @  3,22 PROMPT [SAY/GET]
      @  3,32 PROMPT [ FRAME ]
      @  3,40 PROMPT [ TEXT  ]
      @  3,47 PROMPT [ TITLE ]

      dummy = cur_attr
      KEYBOARD CHR(27)
      MENU TO dummy

      @  6,22 PROMPT [   Say   ]
      @  6,33 PROMPT [   Get   ]
      @  6,43 PROMPT [Un-selected]

      dummy = cur_item
      KEYBOARD CHR(27)
      MENU TO dummy

      @  7,22 PROMPT [Fore]
      @  7,27 PROMPT [Back]
      @  7,33 PROMPT [Fore]
      @  7,38 PROMPT [Back]
      @  7,44 PROMPT [Fore]
      @  7,49 PROMPT [Back]

      dummy = cur_comp
      KEYBOARD CHR(27)
      MENU TO dummy

      @  5,61 PROMPT [BLACK           ]
      @  6,61 PROMPT [BLUE            ]
      @  7,61 PROMPT [GREEN           ]
      @  8,61 PROMPT [CYAN            ]
      @  9,61 PROMPT [RED             ]
      @ 10,61 PROMPT [MAGENTA         ]
      @ 11,61 PROMPT [BROWN           ]
      @ 12,61 PROMPT [WHITE           ]
      @ 14,61 PROMPT [GREY            ]
      @ 15,61 PROMPT [LIGHT BLUE      ]
      @ 16,61 PROMPT [LIGHT GREEN     ]
      @ 17,61 PROMPT [LIGHT CYAN      ]
      @ 18,61 PROMPT [LIGHT RED (PINK)]
      @ 19,61 PROMPT [LIGHT MAGENTA   ]
      @ 20,61 PROMPT [YELLOW          ]
      @ 21,61 PROMPT [BRIGHT WHITE    ]

      dummy = cur_colo
      KEYBOARD CHR(27)
      MENU TO dummy

      ACOPY(no1,color1)
      ACOPY(no2,color2)
      ACOPY(no3,color3)
      ACOPY(no4,color4)

   ENDDO
   IF curs_stat
      CURS_ON()
   ENDIF
RETURN

*
PROCEDURE co_save
   PRIVATE i,sel
   SELE 0
   DO stdcolor
   * load in colors
   SEEK SUBS(M->vsel+space(len(stdcolor->videotype)),1,len(stdcolor->videotype)) + [01]
   FOR M->i = 1 TO 11
      IF RLOCK()
         REPLACE stdcolor->co_sayget  WITH co_strip(color1[i]),;
                 stdcolor->co_frame   WITH co_strip(color2[i]),;
                 stdcolor->co_text    WITH co_strip(color3[i]),;
                 stdcolor->co_title   WITH co_strip(color4[i])
         UNLOCK
      ENDIF
      SKIP
   NEXT
   USE
RETURN

*
FUNCTION co_strip
   PARA incoming
   PRIVATE outgoing
   outgoing = SUBS(incoming,1,2)+SUBS(incoming,4,2)+;
              SUBS(incoming,7,2)+SUBS(incoming,10,2)+;
              SUBS(incoming,15,2)+SUBS(incoming,18,2)
RETURN (outgoing)

