*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

* 
PROC bckup     &&  Backup all databases to floppy disk
   PRIVATE answer
   DO backdrop
   DO topscreen
   @ 8,10,16,70 BOX double+[ ]
   @ 10,13 SAY 'Enter drive to backup FROM: '
   @ 12,13 SAY 'Enter drive to backup TO: '

   fdrive = [ ]
   tdrive = [ ]
   @ 10,43 GET fdrive PICT '!'
   @ 12,43 GET tdrive PICT '!'
   CO_CHG(curr_grp,c_sayget)
   READ
   CO_CHG(curr_grp,c_text)
   @ 14,13 SAY 'Have ready several blank, formatted, labeled diskettes.'
   DO yes_no WITH [Do you want to continue? (Y/N)]
   IF myn = [Y]
      SET CONS OFF
      IF FILE([&fdrive.:*.bak])
         RUN DEL &fdrive.:*.BAK
      ENDIF
      RUN BACKUP &fdrive.:*.DB? &tdrive.:
      SET CONS ON
   ENDIF
RETURN

* 
FUNC addmon      && add months
   * TURBO! addmon
   *Returns date + num months
   PARAM pdate,num
   PRIV i,myears,newmon,newyr,mday
   IF PCOUNT()#2
      num = 1
   ENDIF
   IF EMPTY(pdate)
      RETU(pdate)
   ENDIF

   * Make sure day is not past 28
   mday = DAY(pdate)

   * Add years first
   myears = INT(num/12)
   IF num > 0
      num = num - myears*12
      IF MONTH(pdate)+num>12
         newyr  = YEAR(pdate)+myears + 1
         newmon = MONTH(pdate)+num-12
      ELSE
         newyr  = YEAR(pdate)+myears
         newmon = MONTH(pdate)+num
      ENDIF
   ELSE
      * Now subtract months
      num = num - myears * 12
      IF MONTH(pdate)+num<1
         newyr  = YEAR(pdate)+myears - 1
         newmon = MONTH(pdate)+num+12
      ELSE
         newyr  = YEAR(pdate)+myears
         newmon = MONTH(pdate)+num
      ENDIF
   ENDIF
   pdate = CTOD(STR(newmon,2,0)+[/]+STR(MIN(mday,28),2,0)+[/]+STR(newyr,4,0))
   IF mday > 28
      DO WHIL ! islast(pdate) .AND. DAY(pdate) < mday
         pdate = pdate + 1
      ENDDO
   ENDIF
RETU pdate

* 
FUNC addyears        && add years to a date
   PARA mdate,years
   mdate = CTOD(SUBS(DTOC(mdate),1,6) + STR(VAL(SUBS(DTOC(mdate),7))+years,2))
RETU (mdate)

* 
FUNC odd           && return true if a number is odd
  PARA val
  val = ROUND(val,0)
RETU val%2 = 1

* 
FUNC scount        && count the instances of a character within a string
   PARA char,str
   PRIV mret
   mret = 0
   DO WHILE char $ str
      mret = mret + 1
      str = SUBS(str,AT(char,str)+LEN(char))
   ENDDO
RETU mret

* 
FUNC asum
  PARA array,s,e
  s = DEFAULT([s],1)
  e = DEFAULT([e],LEN(array))
  PRIV mval,i
  mval = 0
  FOR i = s TO e
    mval = mval + array[i]
  NEXT
RETU mval

* 
FUNC v_file                      && validate allowable DOS filenames.
   PARA filename

   PRIV mret,i,f_sub
   mret = .T.
   filename = TRIM(LTRIM(filename))
   IF EMPTY(filename)
      mret = .F.
   ENDIF
   IF SCOUNT([.],filename) > 1
      DO kbhit WITH [Only 1 "." allowed in a DOS filename. Anykey ...]
      mret = .F.
   ENDIF
   i = 1
   DO WHIL i <= LEN(filename) .AND. mret = .T.
      f_sub = SUBS(filename,i,1)
      IF ! UPPER(f_sub) $ [ABCDEFGHIJKLMNOPQRSTUVWXYZ_1234567890$%.]
         DO kbhit WITH [The name ]+ f_sub + [ is not a valid DOS filename. Anykey ...]
         mret = .F.
      ELSE
         mret = .T.
      ENDIF
      i = i + 1
   ENDDO
RETU (mret)

* 
FUNC da    && used for debugging ... prints an array
   PARA aname,autoprint
   autoprint = DEFAULT([autoprint],.F.)
   mprint = .F.
   SAVE SCREEN TO temp
   @ 0,0 CLEAR
   IF ! autoprint
      DO openit
   ELSE
      DO printit WITH [NO]
   ENDIF
   CLEAR
   @ 1,0 SAY [Data in array: ]+aname
   PRIV i
   @ 1,0
   mln = 1
   FOR i = 1 TO LEN(&aname)
     IF i/20 = INT(i/20) .AND. mdevice = [S]
         mln = mln + 1
         @ mln,0
         WAIT
         CLEAR
         @ 1,0 SAY [Data in array: ]+aname
         mln = 1
     ENDIF
     IF TYPE('&aname.[i]') <> [U]
        mln = mln + 1
        @ mln,5 SAY i
        IF TYPE('&aname.[i]') = [N]
           @ mln,20  SAY &aname.[i]     PICT [999,999,999.9999]
        ELSE
           @ mln,20  SAY &aname.[i]
        ENDIF
     ENDIF
     IF ESC()
        EXIT
     ENDIF
   NEXT
   mln = mln + 1
   @ mln,0
   DO closeit
   REST SCREEN FROM temp
RETU []


* 
PROC make_field   && adds a field to current database  (Extended)
  PARAM name,type,len,dec
  APPE BLAN
  REPL field_name WITH name,;  &&  You'll create a field from this record.
     Field_type WITH type,;
     Field_len  WITH len,;
     field_dec  WITH dec
RETURN
