* cal_help.prg        Calendar help for dates

*****************************************************************************
*              Copyright 1990, Financial Dynamics                           *
*                      (703) 671 - 3003                                     *
*****************************************************************************

* Called from LIBHELP whenever input_var is a date type.


PRIVATE oldscreen, _date, input_var2, range, start_range
input_var2 = []

PARAM input_var,;      &&
      input_var2       &&   optional second date for ranges

oldscreen = SAVESCREEN(11,0,24,79)

PRIVATE cal[7*6], colnames[7],tab[7],i
AFILL(cal,[])
colnames[1] = [Sun]
colnames[2] = [Mon]
colnames[3] = [Tue]
colnames[4] = [Wed]
colnames[5] = [Thu]
colnames[6] = [Fri]
colnames[7] = [Sat]

tab[1]   =  45
FOR i = 2 TO 7
  tab[i]   =  tab[i-1] + 4
NEXT i

SET CURSOR OFF

_date = M->&input_var
IF EMPTY(_date)
   _date = DATE()
ENDIF
PRIVATE key,  first_date

BEGIN SEQUENCE

CO_PUSH()

*----in case a range of dates is desired--------------------------
M->range       = .F.
M->start_range = CTOD([])

*--------display the month box-----------------------------------
CO_CHG(c_pop3,c_text)
DO BOX WITH 12,42,7,30,(CMON(_date)+[ ]+STR(YEAR(_date),4,0)), .F.
FOR i = 1 TO 7
   @ 15,tab[i] SAY colnames[i]
NEXT i
@ 24,0
@ 24,0 SAY [Use arrows to move within the month,  Page to other months.]

DO WHIL .T.   && while they stay in calendar help

   *----------display the current month name------------------------
   @13,45 SAY CENTER( CMON(_date)+[ ]+STR(YEAR(_date),4,0), 28)
   @16,tab[1] CLEAR TO 21,tab[7]+3

   FOR i = (M->_date - DAY(_date)+ 1 ) TO  LDOM(M->_date)
      @ 15+_WEEK(i),tab[DOW(i)] SAY DAY(i) PICT [99]
   NEXT i
   first_date = _date - DAY(_date) + 1
   * ---------------------------------------------------------------------

   DO WHIL .T.
      * say the current date in another color:
      CO_PUSH()
      CO_CHG(curr_grp,c_sayget)
      @ 15+_WEEK(_date),tab[DOW(_date)]  SAY DAY(_date) PICT [99]
      CO_POP()

      M->key = INKEY(0)   && wait for a key

      *----if the key is a period, then start marking a range----
      IF CHR(M->key) = [.] .AND. ! EMPTY(M->input_var2)
         range = .T.
         start_range = _date
      ENDIF

      IF ! M->range      &&  not marking a range, so back to normal colors
         @ 15+_WEEK(_date),tab[DOW(_date)]  SAY DAY(_date) PICT [99]
      ENDIF

      DO CASE
         CASE M->key = 13        && enter
            IF EMPTY(m->input_var2)   &&  only one variable to plug
               STORE _date TO &input_var.
            ELSE
               *-------they're expecting a range of dates
               IF EMPTY(M->start_range)  &&  plug 'em both with _date
                  STORE _date TO &input_var. , &input_var2.
               ELSE
                  STORE MIN(_date,M->start_range) TO &input_var.
                  STORE MAX(_date,M->start_range) TO &input_var2.
               ENDIF
            ENDIF
            KEYBOARD CHR(13)   &&  one enter key, even if two dates
            BREAK

          CASE M->key = 27        && escape
            BREAK

          CASE M->key = 24 .AND. ! M->range          && down
             _date = _date + 7

          CASE M->key = 5 .AND. ! M->range           && up
             _date = _date - 7

          CASE M->key = 4              && right
             _date = _date + 1

          CASE M->key = 19             && left
             _date = _date - 1

          CASE M->key = 1 .AND. ! M->range     && home
             _date = _date - DAY(_date) + 1

          CASE M->key = 6  .AND. ! M->range    && end - go to the end in any direction
             @ 24,77 SAY [END]
             key = INKEY(0)
             DO CASE
                CASE M->key = 24                                            && down
                   _date = _date + 7 * (_WEEK(LDOM(_date)) - _WEEK(_date))

                CASE M->key = 5                                             && up
                   _date = _date + 7 * (1- _WEEK(_date))

                CASE M->key = 4                                             && right
                   _date = _date + 7 - DOW(_date)

                CASE M->key = 19                                            && left
                   _date = _date - DOW(_date) + 1

                CASE M->key = 6 .OR. M->key = 1      && end or home
                   _date = LDOM(_date)
             ENDCASE
             @ 24,77 SAY [   ]

          CASE M->key = 3  .AND. ! M->range  && pagedown -- same day of next month
             _date = ADDMON(_date,1)

          CASE M->key = 18 .AND. ! M->range    && pageup -- same day of prior month
             _date = ADDMON(_date,-1)
      ENDCASE

      IF _date > LDOM(M->first_date) .OR. _date < M->first_date
         EXIT     && have moved into another month
      ENDIF

   ENDDO
   *  want to display another month
ENDDO
END SEQUENCE

CO_POP()
RESTSCREEN(11,0,24,79,M->oldscreen)
SET CURSOR ON

RETURN
*** eof ***


FUNC _WEEK
   PARAM _date
RETURN  INT( (DAY(_date) + DOW(_date-DAY(_date)+1) - 1) / 7.1 ) + 1
