/*
    FDEM11.PRG
    ----------
    Frankie v2.21 demo: ADdbview() as a taglist 
    Reguires TAGLIST.DBF with at least two fields
        "TAG", "C", 1, 0               
        "SELECTION", "C", 10, 0 

    Compile:  clipper fdem11 /a /b /n /v /w
    Link   :  blinker fi fdem11 lib frankie
              rtlink fi fdem11 lib frankie
              exospace fi fdem11 lib frankie, exospace
              wl32 fdem11,,, frankie, cwclp52

    Copyright (c) Angelito Dizon, 1994.  All rights reserved.
*/

static lSelected := .f.

#include "frankie.ch"
#include "inkey.ch"

/*----
  Main Function
*/
func main()
field tag, selection
local bConfig := {||ADdb_enter( {||field->tag := if( empty( field->tag ), "*", " ")} ),;
                    xHotKeys(),;      // define hot keys
                    xExtra();         // define push buttons
                 }
local aSelection[0]

// Some demo prep steps
if( ADversion() != "2.21", ADmessage( { "Needs Frankie v2.21" } ), )
ADdevblock( {||ADfview( "FDEM11.PRG" )} )
ADset_help( "fdem11" )
ADhelp( "ABOUT_DB_TAGLIST", "About This Demo" )

use taglist
ADdbview( 10,10,19,40, bConfig,, "DB_TAGLIST" )

// collect selected records into an array and _untag_ the database
dbgotop()
do while ! eof()       
    if lSelected
        if tag == "*"
            aadd( aSelection, selection )
        endif
    endif

    tag := ""   // reset the tag
    skip
enddo

ADaview( aSelection )     // displays the selected items
ADhelp( "END_DB_TAGLIST", "Goodbye Notes" )
return NIL


/*-----
  Hot keys definition
*/
func xHotKeys()
local aKeys := {K_SPACE, K_ENTER}
ADdb_keys( aKeys, {|n,k|xHotKeyHandler( k )} )
return NIL


/*------
  Hot keys handler
*/
func xHotKeyHandler( nKey )
if nKey == K_SPACE
    field->tag := if( empty( field->tag ), "*", " ")
elseif nKey == K_ENTER
    ADdb_exit()
    lSelected := .t.
endif
return NIL

/*----
  Push buttons are attached to the browse via the ADdb_extra() API.
*/
func xExtra()
local bBegin, bEnd, bUndisplay, aScn, ePB

bEnd := {||aScn := ADbox( ADdb_bottom()+1, ADdb_left(), ADdb_bottom()+3, ADdb_right(), ADdb_color()[1] ),;
           ePB := xPushButtons(),; 
           ADdb_lbuttons( ADpb_spots( ePB ), {|n|xPBHandler(ePB,n)} ),;
           ADdb_keys( ADpb_altkeys( ePB ), {|n|xPBHandler(ePB,n)}, .t. );
        }
bUndisplay := {||ADrestscn( aScn )}
ADdb_extra( bBegin, bEnd, bUndisplay )
return NIL


/*-----
  Push Buttons definition
*/
func xPushButtons()
local ePB

ePB := ADpb_horizontal( ADdb_bottom()+2, ADdb_left()+1, { "Tag ", " OK ", "Cancel", "  ", "  ", "Help" }, {1,2,1,2,2,1}, 1 )
ADpb_show( ePB )
return ePB

/*-----
  Push buttons handler
*/
func xPBHandler( ePB, nButton )
if nButton == 1
    ADpb_push( ePB, nButton )
    ADm_rwait()
    field->tag := if( empty( field->tag ), "*", " ")
elseif nButton == 2
    ADpb_push( ePB, nButton )
    ADm_rwait()
    ADdb_exit()
    lSelected := .t.
elseif nButton == 3
    ADpb_push( ePB, nButton )
    ADm_rwait()
    ADdb_exit()
elseif nButton == 4
    ADdb_navigate( DBNAVIGATE_UP )
    ADdb_stabilize( .f., .f. )
    inkey( .1 )
elseif nButton == 5
    ADdb_navigate( DBNAVIGATE_DOWN )
    ADdb_stabilize( .f., .f. )
    inkey( .1 )
elseif nButton == 6
    ADpb_push( ePB, nButton )
    ADm_rwait()
    ADhelp( "DB_TAGLIST" )
endif
return NIL

