*- We need the following header file for the AT() and other string functions.
#INCLUDE STRING.HDR
#INCLUDE system.HDR
# include math.hdr
# include io.hdr

* CMDPARSE.PRG
* this will put all command line arguments in a public array argv[]
* number of args will be public int argc
* this is including the EXE file with full path

* strings on command line must be enclosed in "double quotes"

#DEFINE MAX_ARGS 20        && arrays are 0 based

VARDEF
   uint argc
   char argv[&MAX_ARGS]
ENDDEF


procedure cmd_line_err

   ? "You didn't close the quote!"
   quit 1

endpro

* remove redundant spaces
function char rmv_redndt
   parameters CONST char str_to_cmprs

   vardef
      uint where
      char ckstr,newstr,tmpstr
   enddef

   ckstr = str_to_cmprs

   where = at(" ",ckstr)
   newstr=""
   do while where  > 0
      tmpstr=left(ckstr,where-1)
      ckstr=substr(ckstr,where+1,len(ckstr)-where)
      ckstr=ltrim(ckstr)
      where = at(" ",ckstr)
      newstr=newstr+" "+tmpstr
   enddo

   ckstr=newstr+" "+ckstr

   return ltrim(ckstr)

endpro


function int count_chr
   parameters CONST char(1) chr_to_cnt, CONST char str_to_cnt

   vardef
      uint x,where,count_quotes
      char ckstr
      char dblquote
   enddef

   dblquote = chr(34)
   count_quotes = 0

   ckstr = ltrim(rtrim(str_to_cnt))

   x=0

   where = at(chr_to_cnt,ckstr)
   if len(ckstr) > 0
      x=1
   endif

   do while where  > 0
      x=x+1
      ckstr=substr(ckstr,where+1,len(ckstr)-where)

      if substr(ckstr,1,1) = dblquote
         x=x-1
         count_quotes = count_quotes + 1
         ckstr=substr(ckstr,2,len(ckstr)-1)
         where = at(dblquote,ckstr)
         if where > 0
            count_quotes = count_quotes + 1
            loop
         endif
         ckstr=ltrim(ckstr)
      endif

      where = at(chr_to_cnt,ckstr)

   enddo

   if count_quotes > 0
      if ( count_quotes % 2) > 0
         cmd_line_err()
      endif
   endif

   return x

endpro

PROCEDURE CLEAR_ARGS

   vardef
      uint x
   enddef

   for x = 0 to ( &MAX_ARGS - 1)
      argv[x]=""
   next

ENDPRO


PROCEDURE CMD_PARSE
   PARAMETERS CONST CHAR(128) cmd_line

  VARDEF
    CHAR(200)          new_cmd
    UINT               x,where
    char dblquote
  ENDDEF

  dblquote=chr(34)
  new_cmd = ltrim(rtrim(cmd_line))

  * remove extra spaces
  new_cmd = rmv_redndt(new_cmd)

  * get prg name as first arg
  new_cmd = get_exec()+" "+new_cmd

  clear_args()

  * will return a 1 even if no spaces in arg
  * as long as len<0
  argc=count_chr(" ",new_cmd)

   x=0
   repeat

      where = at(" ",new_cmd)
      if where > 0

         if substr(new_cmd,1,1) = dblquote
            new_cmd=substr(new_cmd,2,len(new_cmd)-1)
            where = at(dblquote,new_cmd)
            argv[x]=substr(new_cmd,1,where-1)
            new_cmd=substr(new_cmd,where+1,len(new_cmd)-where)
            new_cmd=ltrim(new_cmd)
         else
            argv[x]=substr(new_cmd,1,where-1)
            new_cmd = substr(new_cmd,where+1,len(new_cmd)-where)
         endif
      else
         argv[x]=ltrim(rtrim(new_cmd))
         new_cmd=""
      endif
      if left(argv[x],1) = "/"
         argv[x] = "-" + right(argv[x],len(argv[x])-1)
      endif
      x=x+1

   until x = argc

ENDPRO


