.MODEL large, c
.286
; ***********************************************************************
; *                                                                     *
; * MASM 6.x example of calling the multiplex interrupt function 1216h. *
; *                                                                     *
; * This code is released to the public domain.                         *
; *                                                                     *
; ***********************************************************************


; type definitions and defines
FARPTR					TYPEDEF				FAR PTR			; far ptr to anything
TRUE						EQU					1
FALSE						EQU					0


; DOS16/M register structure for ExoRMInterrupt()
EXOREGS STRUCT
wDS						WORD					?
wES						WORD					?
wDI						WORD					?
wSI						WORD					?
wBP						WORD					?
wSP						WORD					?
wBX						WORD					?
wDX						WORD					?
wCX						WORD					?
wAX						WORD					?
EXOREGS ENDS



;**********************************************************************
; code
;**********************************************************************
.CODE

; DOS/16M external function prototypes
ExoRMInterrupt PROTO FAR C wInt:WORD, InRegs:FARPTR, OutRegs:FARPTR


handles PROC FAR C _wNumHandles:WORD

	LOCAL _Regs:EXOREGS


	; set up registers
	mov _Regs.wAX, 1216h
	mov ax, _wNumHandles
	mov _Regs.wBX, ax

	; call the real mode interrupt
	INVOKE ExoRMInterrupt, 2Fh, ADDR _Regs, ADDR _Regs

	; get the flags that were returned in ax
	push ax
	popf

	; see if _wNumHandles was greater than FILES setting
	.IF (CARRY?)
		; yup, it was greater
		mov ax, FALSE
	.ELSE
		; nope, FILES >= _wNumHandles
		mov ax, TRUE
	.ENDIF

	; return with ax set to TRUE or FALSE
	ret

handles ENDP


END

