/*****
*
* Author     Jean Paquin
* CompuServe [76130,3455]
* Date       August 15th, 1991
*
* Syntax     RIGHTADDER(cString)
*
* Purpose    To increment last character of a string.
*            The function processes strings with embedded CHR(0).
*
*            When trying to find the last record that matches a
*            particular string in an index, the Clipper programmer
*            must:
*
*            a) save the actual status of SET SOFTSEEK in a variable
*            b) turn SOFTSEEK ON
*            c) increment the last character of the string to seek
*            d) seek the transformed string in the controling index
*            e) skip backward one record
*            f) restore the initial status of SET SOFTSEEK
*
*            This SEEK LAST OCCURENCE strategy is well known of
*            people using TBrowse with a WHILE scoped. The expression
*            commonly used to transform the string to seek is:
*
*            SEEK LEFT(cString,LEN(cString) - 1) +;
*                 CHR(ASC(RIGHT(cString,1)) + 1)
*
*            As you can see, the conversion process involves five
*            Clipper functions: namely LEFT, LEN, CHR, ASC and RIGHT.
*            This is obviously not a fast and elegant way. It would
*            be nice to have a function to process cString in a
*            single call. The C function I offer you today does
*            exactly that:
*
*            SEEK RIGHTADDER(cString)
*
*            RIGHTADDER() acts as a string incrementor that adds
*            1 even if the actual character is ASCII 255 (it then
*            becomes ASCII 0) and assigns the carry of this addition
*            to the previous character in cString until it reaches
*            the beginning of cString. As with any other calculator,
*            an overflow problem will occur if you submit a string
*            exclusively composed of ASCII 255 characters. In that
*            particular case,
*
*            RIGHTADDER(REPLICATE(CHR(255),5)
*
*            will return a string of five ASCII 0 characters
*
*
* Compiling  CL /c /AL /Zl /Od /FPa /Gs noaccent.c
*
*            /c     compile only, do not automatically invoke the linker
*            /AL    use the large model
*            /Zl    do not place the names of the default librairies
*                   in the object file
*            /Od    defeats optimization so that function will work
*                   properly when linking with Blinker and WarpLink
*            /FPa   do not generate floating point calls
*            /Gs    do not generate stack probes
*
***/

#include "nandef.h"
#include "extend.h"

CLIPPER RIGHTADDER()
{
    byte *string = "";
   quant  length = 0;        // if empty or invalid mandatory parameter

   quant  i;                 // type (quant) used to process long strings
     int  end    = FALSE;    // exit while loop when replacement occured

                             // mandatory parameter checking

   if (ISCHAR(1) && (quant)_parclen(1) > 0) {

      string = _parc(1);
      length = _parclen(1);
           i = length;

      while (i-- > 0 && !end) {

          // i-- because we do not process cString terminator '/0'

         if (string[i] < 255)
             end = TRUE;

         string[i]++;

      }

   }

   _retclen(string,length);

}
