*  Sample link lines:

*  link yourprg hllclp extor hllc_l,,,clipper extend /se:512
*  tlink yourprg hllclp extor hllc_l,,,clipper extend
*  plink86 file yourprg, hllclp, extor, hllc_l lib clipper, extend
*  blinker file yourprg, hllclp, extor, hllc_l lib clipper, extend
*  rtlink file yourprg, hllclp, extor, hllc_l lib clipper, extend
*  warplink /r /op:70 (yourprg) hllclp extor hllc_l,,,clipper (extend)


#include "hll.ch"
#include "inkey.ch"


FUNCTION HLGetString (where, length)
** This function returns a string of length from location where:
** string = HLGetString(102, 39)

  LOCAL buffer := SPACE(length)
  HLWait()
  GetString( @buffer, @length, @where)
  RETURN buffer

FUNCTION HLPutWords (message, length, where, optionkey)
** This function puts a string on the screen in a defined 
** place and then optionally sends a key using HLSendKey().
** HLPutWords("MY_PASSWORD", 4, 1, "ENTER")

  LOCAL parcnt := PCOUNT(), retval

  HLWait()

  IF parcnt == 4 .and. (retval := (PUT_STRING( @message, @length, @where ) # 0))
    IF !HLSendKey(optionkey)
      retval := .f.
    ENDIF
  ENDIF
  RETURN retval


FUNCTION HLIsEmpty (where, length)
** This function looks to see if a spot on the screen of a
** given length is empty.
** HLIsEmpty(899, 10)

  LOCAL buffer := SPACE(length+1)
  GETSTRING( @buffer, @length, @where)

** The STRTRAN is necessary because the string returned from  
** the HLLAPI call for an empty screen consists of all CHR(0)
** which EMPTY() does not see as empty.

  RETURN EMPTY( TRIM( STRTRAN(buffer, CHR(0)) ) ) 


FUNCTION HLWaitFor (where, what)
** This function is almost the same as HLCheckFor except it
** will wait for the requested string to appear
** HLLookFor(246, "USERID:")


  LOCAL retval := .F., i

  FOR i = 1 TO 3
    HLWait()
    IF HLCheckFor(where, what)
      retval := .T.
      EXIT
    ENDIF
  NEXT
  RETURN retval

FUNCTION HLCheckFor (where, what)
** This functions looks at a "where" on the screen for "what"
** and returns .T. or .F. 
** HLCheckFor(162, "WHO ARE YOU??")

  LOCAL length := LEN(WHAT)
  LOCAL buffer := SPACE(length+1) 

  GETSTRING( @buffer, @length, @where)
  RETURN buffer == what


FUNCTION HLClear
** This function attempts to clear the screen and then 
** checks to see that it was successful.
** HLClear()  

  LOCAL i, buffer, length, where

  IF !HLSendKey("CLEAR")
    RETURN .F.
  ENDIF

  buffer := space(2001) 
  length := 2000
  where  := 1

  FOR i = 1 TO 5

    HLWait()
    GETSTRING( @buffer, @length, @where)

** The STRTRAN is necessary because the string returned from  
** the HLLAPI call for an empty screen consists of all CHR(0)
** which EMPTY() does not see as empty.


    IF EMPTY(STRTRAN(buffer, CHR(0)))
      retval := .T.
      EXIT
    ENDIF
    IF !HLSendKey("CLEAR")
      retval := .F.
      EXIT
    ENDIF
  NEXT
  RETURN retval

FUNCTION HLSendKey (keystroke)
** A convenient way to send a system key.  The main reason 
** this function is to make the code that sent the keys
** easy to read.
** HLSendKey("JUMP")

  LOCAL buffer := "  ", length, dummy, retval
  keystroke:=UPPER(keystroke) 
  DO CASE 
    CASE keystroke == "ENTER"
      buffer := HL_ENTER
    CASE keystroke == "CLEAR"
      buffer := HL_CLEAR
    CASE keystroke == "JUMP"
      buffer := HL_JUMP
    CASE SUBS(keystroke, 1, 2) == "PF"
      IF VAL(SUBS(keystroke, 3)) <= 9
        buffer := "@" + SUBS(keystroke, 3, 1)
      ELSE
        buffer := "@" + chr(VAL(SUBS(keystroke, 3))+87)
      ENDIF
  ENDCASE

  length := 2
  dummy  := 0

  IF !EMPTY(buffer) 
    HLWait()
    retval := SENDKEY( @buffer, @length, @dummy) == 0 
    HLWait()
  ENDIF
  RETURN retval


FUNCTION HLDispLocation
** Continuously displays the location of the cursor
** when run behind a 3270 session.

  LOCAL cBuffer := " ", nLength := 0, nDumy := 0
  DO WHILE INKEY(1) # K_ESC
    @ 12, 12 SAY hllclp(GET_LOCATI,@cBuffer,@nLength,@nDumy)
  ENDDO
  RETURN .T.
