		page	60, 132
;
;	hllclp.asm
;
;	Clipper interface to the memory-resident 3270 HLL API.
;
;	D. Rifkind  19 Sep 90
;


;	External functions.  __par...() functions retrieve
;	parameters; __retni() returns an integer result to
;	Clipper.  __storni() changes the value of an integer
;	parameter passed by reference.  In Summer '87, it was
;	part of the "extor" package, but in 5.0 it was added
;	to the regular Clipper libraries.

		extrn	__parinfo:far
		extrn	__parc:far
		extrn	__parclen:far
		extrn	__parni:far
		extrn	__retni:far
		extrn	__storni:far


;	Data segment.

_DATA		segment	word public 'DATA'
DGROUP		group	_DATA

verify_7Fh	db	0		; Non-zero if we already know that
					;   the API TSR is installed

;	HLL API program control block (PCB).

pcb_t		struc
  pcb_hdr	db	'PCB'		; Control block identifier
  pcb_func	db	?		; Function code
  pcb_dseg	dw	?		; Pointer to data string, segment/
  pcb_doff	dw	?		;   offset reversed (don't ask me...)
  pcb_length	dw	?		; Data string length
		db	0		; Not used
  pcb_return	dw	?		; Return code
  pcb_maxlen	dw	?		; Maximum string length
pcb_t		ends

pcb		pcb_t	<>		; Allocate one PCB

_DATA		ends


;	Code segment.

HLLCLP_TEXT	segment	word public 'CODE'
		assume	cs:HLLCLP_TEXT, ds:DGROUP

;
;	nCode = HLLCLP(nFunc, @cString[, @nLength[, nParam]])
;
;	nCode	Return code from HLL API
;	nFunc	Function request code
;	cString	String passed to (or returned from) HLL API
;	nLength	Length of string passed/returned
;	nParam	Optional function-specific parameter
;
;	We can't change the length of a string passed by refer-
;	ence, so to get a string back from the API, you have to
;	pass a cString large enough to hold all returned data,
;	and an nLength in which we can store the number of bytes
;	returned.  If nLength is not passed we'll use the actual
;	length of cString instead (and expect no data back).
;

		public	HLLCLP
HLLCLP		proc	far

;	Make sure the API TSR is installed.

		cmp	verify_7Fh, 0
		jnz	verified

		mov	ax, 357Fh	; Check the INT 7Fh vector
		int	21h
		mov	ax, es
		or	ax, bx		; If the vector is zero...
		mov	ax, -1		; ...someone screwed up!
		jnz	verified
		jmp	hllclp_return

verified:
		mov	verify_7Fh, 1	; Don't need to do that again

;	Fill in the PCB for the HLL API call.

		mov	ax, 1		; Parameter 1 = nFunc
		push	ax
		call	__parni
		add	sp, 2
		mov	pcb.pcb_func, al

		mov	ax, 2		; Parameter 2 = cString
		push	ax
		call	__parc
		add	sp, 2
		mov	pcb.pcb_doff, ax
		mov	pcb.pcb_dseg, dx

		mov	ax, 2		; Also need the maximum length of
		push	ax		;   cString
		call	__parclen
		add	sp, 2
		mov	pcb.pcb_maxlen, ax
		mov	pcb.pcb_length, ax
					; Actual length is also the default
					;   input length

		mov	ax, 4		; If nParam was not passed, the API
		push	ax		;   function didn't need it anyway,
		call	__parinfo	;   and we don't care that this does
		add	sp, 2		;   not give back anything meaningful
		mov	pcb.pcb_return, ax

;	Now: if nLength was passed, we'll use it instead of the
;	true length of cString as the length parameter.

		mov	ax, 3
		push	ax
		call	__parinfo
		add	sp, 2
		test	ax, 2		; True if nLength was passed
		jz	no_length

		mov	ax, 3
		push	ax
		call	__parni
		add	sp, 2
		mov	pcb.pcb_length, ax
no_length:

;	All set to call the API TSR.

		push	bp		; Don't trust anyone--save
		push	si		;   everything important
		push	di
		push	ds

		mov	ax, 104h
		mov	bx, 0
		mov	si, offset DGROUP:pcb
		int	7Fh

		pop	ds
		pop	di
		pop	si
		pop	bp

;	Stash the returned length in nLength (does no harm if
;	nLength not passed).

		push	pcb.pcb_length
		mov	ax, 3
		push	ax
		call	__storni
		add	sp, 4

		mov	ax, pcb_return	; API return value

hllclp_return:
		push	ax
		call	__retni
		add	sp, 2

		ret

HLLCLP		endp

HLLCLP_TEXT	ends
		end
