FUNCTION empty
***************
*  Used to check whether a variable contains anything:
*
*       Field type          Checks for
*       ----------          -------------------
*       C - Character       Any character(s) other than blank(s)
*       N - Numeric         Any value other than zero
*       F - Float           Any value other than zero
*       D - Date            Any date other than a blank field: "  /  /  "
*       M - Memo            Any contents (a single line with only blanks
*                               returns .F.; multiple lines always return .T.)
*
*  Syntax:
*           empty( <expression> / <memory variable> / <field name> )
*
*  Returns: logical .T. or .F.
*
*  Samples:
*
*           SET PROCEDURE TO EMPTY            |
*                                             |     use my_dbf
*           Z = "Hello"                       |     ? empty( my_dbf->field_1 )
*           ? empty( Z )                      |     .T.
*           .F.                               |
*                                             |     replace my_dbf->field_1 with "AnyThing"
*           Z = {}                            |     ? empty( my_dbf->field_1 )
*           ? empty( Z )                      |     .F.
*           .T.                               |
*                                             |

PARAMETERS f_variable       && may be memory variable or database field name
PRIVATE f_set_talk, f_return

IF SET("TALK") = "ON"
    SET TALK OFF
    f_set_talk = "ON"
ELSE
    f_set_talk = "OFF"
ENDIF

f_return = .F.      &&  FALSE means:  variable is NOT empty

DO CASE
    CASE TYPE( "f_variable" ) = "C"
        IF LEN( LTRIM(RTRIM( f_variable )) ) = 0
            f_return = .T.
        ENDIF

    CASE TYPE( "f_variable" ) = "N" .OR. TYPE( "f_variable" ) = "F"
        IF f_variable = 0
            f_return = .T.
        ENDIF

    CASE TYPE( "f_variable" ) = "L"
        f_return = .F.  && Can't check logical fields

    CASE TYPE( "f_variable" ) = "D"
        IF f_variable = {}
            f_return = .T.
        ENDIF

    CASE TYPE( "f_variable" ) = "M"
        IF LEN( f_variable ) = 0
            f_return = .T.
        ENDIF

    OTHERWISE   && TYPE = "U"
        f_return = .T.

ENDCASE

IF f_set_talk = "ON"
    SET TALK ON
ENDIF

RETURN f_return

