*------------------------------------------------------------
* LASRSAMP.PRG
* Demonstration program for Clipper '87
* By Mark Leavitt MD PhD, MedicaLogic, Inc., 73270,672
* Public Domain...use and enjoy; no warranty implied
* Requires UDF's (found in LASRFUNC.PRG):
*    DOWNLOAD() to download a soft font to HP compatible laser printer
*    FONTSEL() to select a previously downloaded font
* Requires UDF's (found in IOCTL.ASM or IOCTL.OBJ):
*    IORAW()
*    IOCOOKED()
* To demonstrate: Compile LASRSAMP and LASRFUNC with Clipper '87
*                 Link LASRSAMP+LASRFUNC+IOCTL

CLEAR
FontFile=SPACE(12)
PortName="LPT1"
FontID=0
DO WHILE .T.
   @ 12,10 SAY "Font file to download (include extension): "
   @ 13,10 SAY "  Port to download to (LPT1 or LPT2 etc.): "
   @ 14,10 SAY "ID Number to be assigned to font (0...15): "
   @ 16,30 SAY "Press ESCAPE when finished."
   @ 12,53 GET FontFile
   @ 13,53 GET PortName
   @ 14,53 GET FontID VALID (FontID >= 0 .AND. FontID < 16)
   READ
   IF LASTKEY()=27
      EXIT
   ENDIF
   Result=DOWNLOAD(FontFile,PortName,FontID)
   IF .NOT. Result
      @ 18,10 SAY "Unsuccessful download attempt...press a key to try again"
   ELSE
      @ 18,10 SAY "   Downloading was successful...press a key to continue"
   ENDIF
   INKEY(0)
   CLEAR
   FontFile=SPACE(12)
   FontID=FontID+1
ENDDO
CLEAR
SampText="Now is the time for all good men..."
FontID=0
DO WHILE .T.
   @ 12,10 SAY " Sample text to print out : "
   @ 13,10 SAY "Font ID to select (0...15): "
   @ 16,25 SAY "Press ESCAPE to quit and eject page."
   @ 12,40 GET SampText
   @ 13,40 GET FontID VALID (FontID >= 0 .AND. FontID < 16)
   READ
   IF LASTKEY()=27
      EXIT
   ENDIF
   SET PRINTER TO &PortName
   SET PRINT ON
   SET CONSOLE OFF
   ? FONTSEL(FontID)+SampText
   SET CONSOLE ON
   SET PRINT OFF
   SET PRINTER TO
ENDDO
CLEAR
SET PRINTER TO &PortName
EJECT
SET PRINTER TO
RETURN
