*------------------------------------------------------------
* LASRFUNC.PRG
* Contains 2 UDF's for Clipper '87
* By Mark Leavitt MD PhD, MedicaLogic, Inc., 73270,672
* Public Domain...use and enjoy; no warranty implied
* Contents:
*    DOWNLOAD() to download a soft font to HP compatible laser printer
*    FONTSEL()  returns the appropriate font selection code
* Requires:
*    IORAW() and IOCOOKED(), assembly language UDF's found in IOCTL.ASM
*      or IOCTL.OBJ
* For examples of usage, see LASRSAMP.PRG

*------------------------------------------------------------
* Function DOWNLOAD
* Syntax:
*    DOWNLOAD(<expC1>,<expC1>,<expN>)
*    where:
*       <expC1> = File name of soft font, e.g. HV10R#US.SFP or AA0101AH.HPF
*       <expC2> = Device name to download to, e.g. LPT1 or LPT2
*       <expN>  = Font number (0 ... 15) which is used to select font using
*                 FONTSEL()
* Returns: .T. if successful, .F. if unsuccessful
* Example of usage:  DOWNLOAD("HV10R#US.SFP","LPT1",1)
FUNCTION DOWNLOAD
PARAMETERS FontFile,PortName,FontNum
PRIVATE PrnHandle,FHandle,ReadBuff,ReadSize,Temp
PrnHandle=FOPEN(PortName,2)    && Open printer device for output
Temp=IORAW(PrnHandle)          && Sets device to "RAW" (binary) mode
IF Temp <> 0
   RETURN .F.
ENDIF
IF .NOT. FILE(FontFile)        && Check for existence of FontFile
   RETURN .F.
ENDIF
FHandle=FOPEN(FontFile,0)      && Open it for reading only
IF FHandle=-1
   RETURN .F.
ENDIF
FWRITE(PrnHandle,CHR(27)+"*c"+LTRIM(STR(FontNum))+"D") && Preamble for downld
ReadBuff=SPACE(1024)                          && Prepare a buffer for reading
ReadSize=FREAD(FHandle,@ReadBuff,1024)        && Read a chunk
DO WHILE ReadSize=1024
   FWRITE(PrnHandle,ReadBuff)                 && Send it to the printer
   ReadSize=FREAD(FHandle,@ReadBuff,1024)     && Read another chunk
ENDDO
FWRITE(PrnHandle,LEFT(ReadBuff,ReadSize))     && Send the last chunk
FWRITE(PrnHandle,CHR(27)+"*c5F")              && Make font permanent
FCLOSE(FHandle)                 && Close the font file
Temp=IOCOOKED(PrnHandle)        && Set device back to "COOKED" mode
IF Temp <> 0
   RETURN .F.
ENDIF
FCLOSE(PrnHandle)               && Close the device file
RETURN .T.                      && Successful return

*------------------------------------------------------------
* Function FONTSEL
* Syntax:
*    FONTSEL(<expN>)
*    where:
*       <expN>  = Font number (0 ... 15) to select
* Returns: <expC>, a printer control string which selects that font number
* Example of usage:  SET PRINT ON
*                    ?? FONTSEL(1)
*                    ?? "This is printed using Font 1"
FUNCTION FONTSEL
PARAMETERS FontNum
RETURN CHR(27)+"("+LTRIM(STR(FontNum))+"X" && Font select code
