*********************************************************** 
*                  Diction.Prg 07/20/87                   *
*   Program to create and update database dictionaries    *
*                           by                            *
*                                                         * 
*                     David L. West                       *
*                   208 Randall Street                    *
*                   Reinbeck IA 50669                     *
*                 Voice only 319-345-6562                 *
*                                                         *
* Placed in the public domain July 28, 1987. Feel free to *
* distribute this program to others, with only one little *
* restriction... please do not distribute modified copies.*
*                                                         *
* This program is compatible with dbase III+ and Clipper, *
* but I make no guarantees as to it's usefulness, ability,*
* or aesthetic beauty.                                    *
*                                                         *
* Contributions of any amount are welcomed, but are not   *
* required. Enjoy!                                        *
***********************************************************
* V1.1&&       for the benefit of dBase users.
SET BELL OFF && Note: Some of these SETs will cause compiler errors,
SET TALK OFF &&       just ignore them and link anyway. They are there
SET MENU OFF &&       for the benefit of dBase users.
SET CARRY OFF
SET STATUS OFF
SET DELIMITERS OFF
SET DELETED ON
SET SCOREBOARD OFF
SET EXACT OFF
SET SAFETY OFF

PUBLIC Clipper && This variable will be true if this is in Clipper
store "" to xstatus

if clipper
   set key -1 to To_Dos && F2 temporarily exits to DOS
endif

SET PROCEDURE TO
SET PROCEDURE TO Diction

CLOSE DATABASES

DO WHILE .T. && Main loop of program starts here, EXIT this exits program
   STORE IIF(Clipper,"Clipper","dBase III")+" Dictionary Utility Menu" TO XStatus
   DO status
   @ 1,0 CLEAR
   @ 6,16 say  " >>>>>>>>>> Database Dictionary Utilty <<<<<<<<<< "
   @ 7,16 SAY  "ͻ"
   @ 8,16 SAY  "  0  - Exit to                                  "
   @ 9,16 SAY  "  1  - CREATE a dictionary                      "
   @ 10,16 SAY "  2  - MODIFY a dictionary                      "
   @ 11,16 SAY "  3  - PRINT a dictionary                       "
   @ 12,16 SAY "  4  - CREATE a database from a dictionary      "
   @ 13,16 SAY "  5  - MODIFY a database structure (CAUTION!)   "
   @ 14,16 SAY "͹"
   @ 15,16 SAY "  Press the key corresponding to your selection "
   @ 16,16 SAY "ͼ"
   @ 8,32 SAY IIF(Clipper,"operating system","dBase dot prompt")
   @ 24,1 SAY "F10 repeats last file name entered"
   @ 24,50 say "F2 temporarily exits to DOS"
   STORE "?" TO Option
   DO WHILE .NOT. Option$"012345"
      STORE "?" TO Option
      @ 17,16 SAY "Enter selection -> "GET Option picture "#"
      READ
   ENDDO
   
   DO CASE
     CASE option="0"
      EXIT
     CASE option="1"
      DO Make_Dic
     CASE option="2"
      DO Edit_Dic
     CASE option="3"
      DO Print_Dic
     CASE option="4"
      DO Make_Dbf
     CASE option="5"
      do Modi_Stru
   ENDCASE
   
ENDDO && From main loop
STORE "Bye....." TO XStatus
DO status
@ 1,0 CLEAR
@ 6,1 SAY "Ŀ"
@ 7,1 SAY " If you have found this program useful, "
@ 8,1 SAY " please pass it along to others.        "
@ 9,1 SAY ""
CLOSE DATABASES
SET PROCEDURE TO
RELEASE clipper


PROCEDURE Status && Write a status message on line 0
@ 0,1 SAY XStatus+SPACE(79-LEN(Xstatus))
RETURN

PROCEDURE Repeat
PARAMETERS setting
SET function 10 TO setting

PROCEDURE Make_Dic
DO WHILE .T.
   
   * Display the usual status message
   STORE "Create a dictionary" TO Xstatus
   DO status
   @ 1,0 CLEAR
   
   * Get the name of the database
   STORE SPACE(8) TO Dbf_Name
   @ 2,1 SAY "Enter database name or leave blank to quit "GET Dbf_Name picture "@!"
   READ
   
   IF Dbf_Name=SPACE(8)
      EXIT && Get out of this proc
   ELSE
      DO repeat WITH Dbf_Name && Store this for later use
   ENDIF
   
   * Generate actual file names
   STORE TRIM(Dbf_Name)+".DIC" TO Dic_Name
   STORE TRIM(Dbf_Name)+".DBF" TO Dbf_Name
   
   * Check to see that there is such a file
   IF .NOT. FILE("&Dbf_Name")
      ? CHR(7)
      @ 4,1 CLEAR TO 5,79
      @ 4,1 SAY "Sorry, guy... no such database!"
      WAIT " Press any key to continue"
      LOOP
   ENDIF
   
   * Check to see if dictionary already exists
   IF FILE("&Dic_Name")
      ? CHR(7)
      @ 4,1 CLEAR TO 5,79
      @ 4,1 SAY "Whoa! That dictionary already exists!"
      
      STORE "?" TO Killit
      DO WHILE .NOT. Killit$"YN"
         STORE "?" TO Killit
         @ 5,1 SAY "Do you want to overwrite it (Y/N) "GET KillIt picture "!"
         READ
      ENDDO
      IF killit="Y"
         DELETE FILE &Dic_Name
         @ 4,0 CLEAR
      ELSE
         LOOP
      ENDIF
   ENDIF
   
   STORE "Creating dictionary for "+Dbf_Name+"..." TO XStatus
   DO status
   
   USE &Dbf_Name
   COPY STRUCTURE Extended TO DTemp1
   
   USE DTemp1
   COPY STRUCTURE Extended TO DTemp2
   
   USE Dtemp2
   APPEND BLANK
   REPLACE field_Name WITH "FIELD_DESC",FIELD_TYPE WITH "C",FIELD_LEN WITH 45,FIELD_DEC WITH 0
   USE
   
   CREATE &Dic_Name FROM Dtemp2
   USE &Dic_Name
   APPEND FROM Dtemp1
   USE
   
   DELETE FILE Dtemp1.DBF
   DELETE FILE Dtemp2.DBF
   
   ? CHR(7)
   WAIT " "+Dic_Name+" created. Press any key to continue."
   
ENDDO
RETURN


PROCEDURE Edit_Dic
DO WHILE .T.
   STORE "Edit a dictionary " TO xstatus
   DO status
   @ 1,0 CLEAR
   STORE SPACE(8) TO Dic_Name
   @ 2,1 SAY "Enter dictionary name or leave blank to quit "GET Dic_Name picture "@!"
   READ
   IF dic_name=SPACE(8)
      EXIT
   ELSE
      DO repeat WITH Dic_Name
   ENDIF
   store trim(dic_name)+".DIC" to dic_name

   * Check to see if dictionary exists
   IF .NOT. FILE("&Dic_Name")
      ? CHR(7)
      @ 4,1 SAY "No dictionary for that database!"
      WAIT " Use option 1 to create a dictionary."
      LOOP
   ELSE
      USE &Dic_Name
   ENDIF
   
   DO WHILE .T.
      
      STORE "Edit a dictionary ("+TRIM(Dic_Name)+")" TO xstatus
      DO status
      @ 1,0 CLEAR
      
      * now display dictionary
      STORE 3 TO row
      STORE RECNO() TO base
      @ 2,1 SAY "Field        Type Length Decimals Description"
      STORE .F. TO Get_Op
      DO WHILE .T.
         IF row=23
            STORE .T. TO GET_Op
         ELSE
            IF EOF()
               @ row,1 SAY "No more fields...."
               STORE .T. TO Get_OP
            ENDIF
         ENDIF
         
         IF Get_Op
            STORE .F. TO Get_Op
            STORE SPACE(10) TO F_Name
            CLEAR GETS
            if reccount()>22
               IF .NOT. EOF()
                  @ 24,55 SAY "(Enter + for next page) "
               ELSE
                  @ 24,55 SAY "(Enter + for first page)"
               ENDIF
            endif
            @ 24,1 SAY "Enter field name or leave blank to quit "GET F_Name picture "@!"
            READ
            IF "+"$F_Name
               STORE 3 TO row
               @ 3,0 CLEAR
               IF EOF()
                  GO TOP
               ELSE
               ENDIF
               LOOP
            ELSE
               EXIT
            ENDIF
         ELSE
            IF row=3
               STORE RECNO() TO base
            ENDIF
            @ row,1  GET Field_Name
            @ row,15 GET Field_TYPE
            @ row,21 GET Field_Len Picture "###"
            @ row,28 GET Field_Dec picture "###"
            @ row,35 SAY Field_Desc
            STORE row+1 TO row
            SKIP
         ENDIF && If Get_Op was true/false
      ENDDO && Display structure loop ends here
      
      IF F_Name=SPACE(10)
         EXIT
      ENDIF
      SET EXACT ON
      locate FOR Field_Name=F_Name
      SET EXACT OFF
      @24,0 CLEAR TO 24,79
      IF .NOT. FOUND()
         ? CHR(7)
         @ 24,0 SAY SPACE(80)
         store "?" to ok
         clear gets
         @ 24,1 SAY "No such field! Press any key to continue or A to Add " get ok picture "!"
         read
         if ok#"A"
            GO base
            LOOP
         else
            append blank
            replace field_name with F_Name
         endif
      else
         clear gets
         store "?" to ok
         @ 24,0 say space(80)
         @ 24,1 say "C to change, D to delete, any key to continue "GET OK PICTURE "!"
         read
         do case
           case Ok="D"
            if recno()=base
               delete
               go top
            else
               delete
               go base
            endif
            loop
           case OK="C"
            * Get ready to edit
           otherwise
            go base
            loop
         endcase
      endif
      @ 24,0 say space(80)
      CLEAR GETS
      @ 24,1  SAY Field_Name
      do case
        case field_type="D" .and. (field_len#8 .or. field_dec#0)
         replace field_len with 8,field_dec with 0
        case field_type="M" .and. (field_len#10 .or. field_dec#0)
         replace field_len with 10,field_dec with 0
      endcase
      
      if clipper
         @ 24,15 get Field_TYPE picture "!" valid Field_Type$"CDLMN"
         @ 24,21 get Field_Len Picture "###" valid Field_Len>0 .and. Field_Len<255
         @ 24,28 get Field_Dec picture "###" valid (Field_Dec>-1 .and. Field_Dec<16)
         @ 24,35 get Field_Desc
      else
         @ 24,15 get Field_TYPE
         @ 24,21 get Field_Len Picture "###" range 0,255
         @ 24,28 get Field_Dec picture "###" range 0,15
         @ 24,35 get Field_Desc
      endif
      READ
      DO WHILE RECNO()/20 <> int(RECNO()/20) .AND. RECNO()#1
         SKIP -1
      ENDDO
   ENDDO
   USE
ENDDO && End of loop for Edit_Dic procedure
USE
RETURN

PROCEDURE Print_Dic
DO WHILE .T.
   
   STORE "Print a dictionary" TO xstatus
   DO status
   @ 1,0 CLEAR
   STORE SPACE(8) TO Dic_Name
   @ 2,1 SAY "Enter dictionary name or leave blank to quit "GET Dic_Name picture "@!"
   READ
   IF dic_name=SPACE(8)
      EXIT
   ELSE
      DO repeat WITH Dic_Name
   ENDIF
   store trim(dic_name)+".DIC" to dic_name
   * Check to see if dictionary exists
   IF .NOT. FILE("&Dic_Name")
      ? CHR(7)
      @ 4,1 SAY "No dictionary for that database!"
      WAIT " Use option 1 to create a dictionary."
      LOOP
   ELSE
      USE &Dic_Name
   ENDIF
   
   @ 4,1 SAY "Make sure the printer is ready and press any key..."
   DO WHILE inkey()=0
   ENDDO
   
   STORE .T. TO header
   STORE 0 TO page,row,field_tot
   STORE "Printing dictionary ("+TRIM(Dic_Name)+")" TO xstatus
   DO status
   SET DEVICE TO PRINT
   DO WHILE .NOT. EOF()
      
      IF header .OR. row>54
         IF row>54
            IF page>0
               STORE row+1 TO row
               @ row,1 SAY "continued..."
            ENDIF
            STORE 1 TO row
            EJECT
         ENDIF
         STORE .F. TO header
         STORE page+1 TO page
         STORE "*** Database Dictionary "+TRIM(Dic_Name)+", Page "+LTRIM(STR(Page,2,0)) TO Line
         @ row,(80-LEN(Line))/2 SAY Line
         STORE row+1 TO row
         STORE "*** Prepared on "+DTOC(DATE())+" by David L. West ***" TO line
         @ row,(80-LEN(Line))/2 SAY Line
         STORE row+2 TO row
         @ row,1 SAY "Field        Type Length Decimals Description"
         STORE row+2 TO row
      ENDIF
      
      @ row,1  SAY Field_Name
      @ row,15 say Field_TYPE
      @ row,21 say Field_Len Picture "###"
      @ row,28 Say Field_Dec picture "###"
      @ row,35 Say Field_Desc
      STORE row+1 TO row1
      STORE Field_Len+Field_tot TO Field_Tot
      SKIP
   ENDDO
   
   STORE row+1 TO row
   @ row,1 SAY "Total record length"
   @ row,21 SAY Field_Tot picture "###"
   
   SET DEVICE TO SCREEN
   EJECT
ENDDO && End of print_dic loop
USE
RETURN

PROCEDURE Make_Dbf

DO WHILE .T.
   
   STORE "Create database" TO xstatus
   DO status
   @ 1,0 CLEAR
   * Get the name of the dictionary
   STORE SPACE(8) TO Dic_Name
   @ 2,1 SAY "Enter dictionary name or leave blank to quit "GET Dic_Name picture "@!"
   READ
   IF dic_name=SPACE(8)
      EXIT
   ELSE
      DO repeat WITH Dic_Name
   ENDIF
   
   * Check to see if dictionary exists
   STORE TRIM(Dic_Name)+".DIC" TO dic_name
   IF .NOT. FILE("&Dic_Name")
      ? CHR(7)
      @ 4,1 SAY "No such dictionary!"
      WAIT " Use option 1 to create a dictionary."
      LOOP
   ENDIF
   
   * Get the name of the database to create
   STORE SPACE(8) TO Dbf_Name
   @ 4,1 SAY "Enter name of database to create             "GET Dbf_Name picture "@!"
   READ
   IF dbf_name=SPACE(8)
      LOOP
   ENDIF
   
   * Check to see if database already exists
   STORE TRIM(Dbf_Name)+".DBF" TO dbf_name
   IF FILE("&Dbf_Name")
      ? CHR(7)+CHR(7)
      @ 6,1 SAY "WARNING! That database already exists!"
      STORE "?" TO OK2KIll
      DO WHILE .NOT. Ok2Kill$"YN"
         STORE "?" TO OK2KIll
         CLEAR GETS
         @ 7,1 SAY "Do you want to overwrite it (Y/N) "GET Ok2Kill picture "!"
         READ
      ENDDO
      @ 6,0 CLEAR
      IF ok2kill="N"
         LOOP
      ENDIF
   ENDIF
   
   USE
   STORE "Creating "+TRIM(DBF_Name)+" from "+TRIM(DIC_Name) TO xstatus
   DO status
   @ 1,0 CLEAR
   CREATE &Dbf_Name FROM &Dic_Name
   USE
   
ENDDO && End of loop for Make_Dbf
USE
RETURN

procedure Modi_Stru
Do while .t.
   store "Modify a database structure" to xstatus
   do status
   @ 1,0 clear
   * Get the name of the dictionary
   STORE SPACE(8) TO Dic_Name
   @ 2,1 SAY "Enter dictionary name or leave blank to quit "GET Dic_Name picture "@!"
   READ
   IF dic_name=SPACE(8)
      EXIT
   ELSE
      DO repeat WITH Dic_Name
   ENDIF
   
   * Check to see that there is such a file
   store trim(Dic_Name)+".DIC" to Dic_Name
   IF .NOT. FILE("&Dic_Name")
      ? CHR(7)
      @ 4,1 CLEAR TO 5,79
      @ 4,1 SAY "Sorry, guy... no such dictionary!"
      WAIT " Press any key to continue"
      LOOP
   ENDIF
   
   * get name of existing database
   STORE SPACE(8) TO Dbf_Name
   @ 4,1 SAY "Enter name of database to modify             "GET Dbf_Name picture "@!"
   READ
   IF dbf_name=SPACE(8)
      LOOP
   ENDIF
   
   * Check to see that there is such a file
   store trim(dbf_Name)+".DBF" to Dbf_Name
   IF .NOT. FILE("&Dbf_Name")
      ? CHR(7)
      @ 4,1 CLEAR TO 5,79
      @ 4,1 SAY "Sorry, guy... no such database!"
      WAIT " Press any key to continue"
      LOOP
   ENDIF
   
   store TRIM(dbf_name)+".BAK" to Bak_Name
   if file("&Bak_Name")
      ? CHR(7)
      @ 4,1 clear to 5,79
      @ 4,1 say Bak_Name+" already exists!"
      store "?" to ok
      do while .not. ok$"YN"
         store "?" to ok
         clear gets
         @ 5,1 say "Do you want to overwrite it (Y/N) " GET OK PICTURE "!"
         READ
      enddo
      if OK="N"
         Loop
      endif
      delete file &Bak_Name
   endif
   
   store "Modifying structure of "+dbf_name to xstatus
   do status
   @ 1,0 clear
   @ 2,1 say "Renaming "+Dbf_Name+" to "+Bak_Name
   rename &dbf_name to &Bak_name
   
   @ 3,1 say "Creating empty database from "+trim(dic_Name)+"....."
   
   * Create database
   Create &Dbf_Name from &Dic_Name
   @ 4,1 say "Opening "+Dbf_Name+" and adding records from "+Bak_Name+"....."
   USE &Dbf_Name
   Append from &Bak_Name
   USE
   ?? chr(7)+chr(7)
   @ 5,1 say ltrim(str(reccount(),10,0))+" records copied."
   @ 7,1 say "Please inspect modified database carefully before deleting "+Bak_Name
   @ 8,1 say "*** Press any key to continue ***"
   do while inkey()#0 && Flush keyboard buffer
   enddo
   wait ""
   
enddo && From top of modi_stru routine
return
*
*
*EOF DICTION.PRG

PROCEDURE To_Dos && Note: This works for Clipper only
Parameters Prog,Line,Var
save screen to To_Dos
clear
@ 1,0 say "Temporarily exiting to DOS.... do not load any memory resident programs!"
@ 2,0 say "Type EXIT to return to program"
@ 3,0
RUN \COMMAND
restore screen from To_Dos
return

procedure help
parameters Prog,Line,Var
if clipper .and. type("Recursive")="U" .and. substr(var,1,1)="D"
   private base,row,array,maxlen,help
   save screen to help
   store xstatus to tstatus
   store "Reading files, please stand by... " to xstatus
   do status
   declare Dic[Adir("*.DIC")]
   declare Dbf[Adir("*.DBF")]
   Adir("*.DIC",Dic)
   Adir("*.DBF",Dbf)
   store 1 to x
   do while x<=max(Len(Dic),Len(Dbf))
      if x<=Len(Dic)
         store substr(dic[x],1,len(dic[x])-4) to dic[x]
      endif
      if x<=Len(DBf)
         store substr(dbf[x],1,len(dBf[x])-4) to dbf[x]
      endif
      Store x+1 to x
   enddo
   store tstatus to xstatus
   do status
   store iif(substr(var,1,3)="DIC","DIC","DBF") to Array
   store .t. to recursive
   store iif(len(&Array)>22,23,len(&Array)+2) to hi
   *@ 1,1 clear to hi,12
   @ 1,1 to hi,12
   @ 1,3 say ">*."+Array+"<"
   store 1 to base,x
   store 2 to row
   if array="DIC"
      store len(Dic) to MaxLen
   else
      store len(Dbf) to MaxLen
   endif
   do while .t.
      if row=2
         @ 2,2 clear to hi-1,11
         store x to base
      endif
      if x>maxlen .or. row=23
         store 0 to option
         menu to option
         store lastkey() to key
         if maxlen<21
            store 0 to key
         endif
         do case
           case key=18 && Pgup
            store iif(x>20,1,x-20) to x,base
            store 2 to row
            loop
           case key=3 && PgDn
            store iif(x<=(MaxLen-20),x+20,maxlen-20) to x,base
            store 2 to row
            loop
           otherwise
            exit
         endcase
      else
         
         if Array="DIC"
            @ row,3 prompt Dic[x]+space(8-Len(Dic[x]))
         else
            @ row,3 prompt Dbf[x]+space(8-Len(Dbf[x]))
         endif
         store x+1 to x
         store row+1 to row
         
      endif
      
   enddo
   restore screen from help
   if option#0
      if array="DIC"
         keyboard dic[base+(option-1)]
      else
         keyboard dbf[base+(option-1)]
      endif
   endif
   release recursive
endif
return

*
*
*EOF DICTION.PRG
