/*
** fix_UE669() - version 2.0
**
** Used for "working around" a memory allocation "bug" or "incorrect
** allocation decision for some of us" in Clipper 5.0 - 5.2c (and probably
** later versions as well).
**
** Copyright(C) 1993, Robert G. Montgomery.  All Right Reserved.
** 
** You are hereby granted rights to include this function in your application
** programs, free of charge, and if deemed necessary, you may also distribute
** the source for the function with the source for any applications which use
** them, free of charge.
**
** This is a C function which is similar to fix668.prg, but it does what
** it does at the Memvar Table end of DGROUP.
**
** call the function from Clipper like this:
**
**    fix_UE669(nNumItems)
**
** where nNumItems is the number of items for which space is to be allocated.
**
** As configured here, more than 512 ITEMs allocated could lead to horrible
** things happening.  If you need more, you must change the allocation below
** in the C source and recompile.  Then you must make sure that you give
** enough cpu stack space with your linker to handle it.  It takes two bytes
** of cpu stack space for each ITEM allocated for with this routine, but that
** is only during the execution of this routine.
**
*/

#include "extend.api"
#include "item.api"

#define fix_UE669num 512 /* max number of ITEMS which may be allocated */

/* FIX_UE669()
**
** Causes a larger area of DGROUP to be allocated to to the Memvar Table, 
** which keeps it from being turned over to the VMM system to be used as 
** conventional memory.  This routine is used to prevent the 
** "Unrecoverable Error 669, Eval Stack Fault" error from happening.  
** 
** THIS ROUTINE DOES NOTHING TO HELP ANY OTHER ERROR, AND IN THE EVENT 
** THAT YOUR PROBLEM IS ANOTHER ERROR, THIS ROUTINE WILL PROBABLY MAKE 
** THINGS WORSE.  
** 
** This routine should be called as one of the first statements in your 
** program.  Note that as configured here, it will require just over 1K 
** of cpu stack to work.  This should not be a problem as long as this 
** routine is called from your "main program".  
** 
** The UE 669 error occurs when the Memvar Table end of DGROUP needs to 
** expand through allocation of ITEMs through ITEM.API.  Note that some 
** clipper internals generate ITEMs also.  If the VMM has allocated the 
** space in which it must expand into, then you get UE 669 - Eval Stack 
** Fault.  
** 
** This routine reserves space to keep it available for ITEMS, by keeping 
** the VMM from reallocating it to the conventional memory pool.  
** 
** parameter - nNumItems 
** This determines the number of ITEMs for which space is to be allocated 
** at the end of DGROUP.  Allocating too many ITEMs with this routine or 
** with fix_UE668() may lead to UE 667 Eval Stack fault, or
** UE <whatever> Conventional Memory Exhausted.  
** 
** One of the first statements in your program should be a call to this 
** routine, which will eat up enough Memvar Table space for your program 
** to run, then allow it to be reclaimed.  But after the call, the VMM 
** will not reallocate this space to the conventional memory pool since 
** it will think that your program might use it again later for allocation 
** of ITEMs.  
** 
** All this program really does is create a whole mess of ITEMs 
** initialized to nil, then it releases them, then it returns.  
** 
** This routine accepts one parameter, indicating the number of ITEMs 
** for which space is to be allocated. This routine only works for 
** multiples of 50 variables.  The number you give is rounded down to 
** the nearest multiple of 50.  
** 
** If you get one of following unrecoverable errors after using this: 
** 1. UE 667 Eval Stack fault (Eval Stack overrun of Memvar Table) 
**    You are allocating too much space with fix_UE669().  Reduce the 
**    number of variables to be allocated or eliminate the call to 
**    fix_UE669().  Also try reducing the number of variables parameter 
**    to fix_UE668() if you are using it.  
** 2. UE <whatever> conventional memory exhausted - similar to item #1.  
** 3. UE 669 Eval Stack Fault (Memvar Table attempted overrun of memory 
**    space which has been reallocated as conventional memory).  
**    Increase the number of ITEMs to be allocated.  
** 
** Note that this is not a catch all solution. There are many things 
** which eat up DGROUP, and many combinations which lead to peril: 
** a. C and ASM static data.  
** b. CPU stack.  
** c. Eval Stack.  
** d. Memvar Table.  
** e. "last resort" conventional memory.  
** The total size of DGROUP is 64K.  It is configured so that the 
** Eval Stack grows toward the Memvar Table.  If it overruns it, you 
** get UE 667.  If there is a large piece of memory in between the Eval 
** Stack and the Memvar Table, and the VMM sees that after some time of
** program execution that your program has not accessed this area, it
** will allocate it as conventional memory as a last resort.  After that
** point, if more local variables are instantiated, and the Eval Stack
** overruns the VMM conventional memory, you get UE 668.  
** 
** If, at some point, the VMM attempts to allocate conventional memory, 
** and there is none left, you get "Conventional Memory Exhausted".  
** 
** UE 669 is what you get when the Clipper static variable area cannot be 
** expanded for the same reason.  UE 650 processor stack fault, is caused 
** by the cpu call stack growing too large, its size can be controlled with 
** the linker /STACK command, or equivelent (SET PROCEDURE DEPTH, Etc.).  
*/

CLIPPER fix_UE669() {
  ITEM iarr[fix_UE669num], param1;
  unsigned int arr_num;
  unsigned int nNumItems;
  param1 = _itemParam(1);
  nNumItems = _itemGetNL(param1);
  _itemRelease(param1);
  for (arr_num=0;arr_num<nNumItems;arr_num++)
    iarr[arr_num] = _itemNew(NULL);
  for (arr_num=0;arr_num<nNumItems;arr_num++)
    _itemRelease(iarr[arr_num]);
  _itemRelease(_itemReturn(NULL));
  }
