/*
 * dfdemo.prg
 *
 * Copyright 1991 by Taylor Data Services
 *
 */


#include "inkey.ch"

#define HANDLE 1
#define TOP    2
#define LEFT   3
#define BOT    4
#define RIGHT  5


static WinList := {}
static CurrWin := 0


function Main()

local nKey    := 0
local i       := 0
local x1, y1
local x2, y2

Set Cursor On

__Clear()

@ 1, 0 Say "DispFile() 6.0 demo                      Copyright 1991 by Taylor Data Systems"
@ 2, 0 Say "                                         CIS: 73310,3013   Voice: 215.923.4695"
@ MaxRow(), 0 Say "F2 -- Create a DispFile() Window           Tab -- switch to next window"

if File("dispfile.txt")
    i := DF_Setup("dispfile.txt", MaxRow() - 12, 1, MaxRow() - 3, MaxCol() - 1,;
                  7, 15, .t., 1, 90, 4096, 0, 0, { "W/B", "W/R" },;
                  .t., "", "")

    AAdd(WinList, { i, MaxRow() - 13, 0, MaxRow() - 2, MaxCol() })

    CurrWin := Len(WinList)

    @ MaxRow() - 13, 0 To MaxRow() - 2, MaxCol()

    DF_Draw(WinList[CurrWin, HANDLE])
endif

if File("features.txt")
    i := DF_Setup("features.txt", MaxRow() - 18, 33, MaxRow() - 5, MaxCol() - 3,;
                  7, 112, .f., 1, 90, 4096, 0, 3, { "W/B", "W/R" })

    AAdd(WinList, { i, MaxRow() - 19, 32, MaxRow() - 4, MaxCol() - 2 })

    CurrWin := Len(WinList)

    @ MaxRow() - 19, 32 To MaxRow() - 4, MaxCol() - 2

    DF_Draw(WinList[CurrWin, HANDLE])
else
    DispMsg("Features.txt file not found.")
endif

if File("order.txt")
    x1 := 14
    y1 := 4

    x2 := x1 + 52
    y2 := y1 + 5

    i := DF_Setup("order.txt", y1 + 1, x1 + 1, y2 - 1, x2 - 1,;
                  7, 15, .t., 1, 90, 512, 0, 0, { "W/B", "W/R" })

    AAdd(WinList, { i, y1, x1, y2, x2 })

    CurrWin := Len(WinList)

    @ y1, x1 To y2, x2

    DF_Draw(WinList[CurrWin, HANDLE])
else
    DispMsg("Order.txt file not found.")
endif

if File("colors.txt")
    i := DF_Setup("colors.txt", 5, 5, 18, MaxCol() - 5,;
                  7, 112, .f., 1, 90, 4096, 0, 0, { "W/B", "W/R" })

    AAdd(WinList, { i, 4, 4, 19, MaxCol() - 4 })

    CurrWin := Len(WinList)

    @ 4, 4 To 19, MaxCol() - 4

    DF_Draw(WinList[CurrWin, HANDLE])
else
    DispMsg("Colors.txt file not found.")
endif

if File("intro.txt")
    x1 := Int(MaxCol() / 2) - 14
    y1 := Int(MaxRow() / 2) - 4

    x2 := x1 + 28
    y2 := y1 + 8

    i := DF_Setup("intro.txt", y1 + 1, x1 + 1, y2 - 1, x2 - 1,;
                  7, 15, .t., 1, 90, 512, 0, 0, { "W/B", "W/R" })

    AAdd(WinList, { i, y1, x1, y2, x2 })

    CurrWin := Len(WinList)

    @ y1, x1 To y2, x2

    DF_Draw(WinList[CurrWin, HANDLE])
else
    DispMsg("Intro.txt file not found.")
endif

do while .t.
    if ( CurrWin > 0 )
        Set Cursor On

        nKey := DispFile(WinList[CurrWin, HANDLE])
    else
        nKey := Inkey()
    endif

    do case
        case nKey == K_ESC
            EXIT

        case nKey == K_F2
            BuildWin()

        case nKey == K_TAB
            if ( ++CurrWin > Len(WinList) )
                CurrWin := 1
            endif

            @ WinList[CurrWin, TOP], WinList[CurrWin, LEFT] TO;
              WinList[CurrWin, BOT], WinList[CurrWin, RIGHT]

            DF_Draw(WinList[CurrWin, HANDLE])

    endcase
enddo

for i := 1 to Len(WinList)
    DF_Close(WinList[i, HANDLE])
next

@ 0,0 Clear

@ 2,0 Say "Thank you for running the DispFile() 6.0 demo"

@ 4,0

return (NIL)



function BuildWin()

local r         := MaxRow() - 13
local c         := 5
local Scrn      := SaveScreen(r, 0, MaxRow(), MaxCol())
local cInFile   := space(60)          // filename must have extension
local nKey      := 0                  // key pressed when dispfile() exits
local nNColor   := 7                  // foreground color
local nHColor   := 15                 // background color
local nColSkip  := 5                  // how many columns to move for left/right arrow
local nRMargin  := 132                // max line size
local lBrowse   := .f.
local lScroll   := .t.
local nBuffSize := 4096
local nRowLock  := 0
local nColLock  := 0

local y1 := 10
local x1 := 10
local y2 := 40
local x2 := 70

local cScrollBack := ""
local cScrollChar := ""

local GetList := {}

@ r, 0 Clear

@ r, c To r + 10, c + 66

@ r + 1, c +  2 Say "   Enter filename:" Get cInFile     Picture "@S30"
@ r + 2, c +  2 Say "       Foreground:" Get nNColor     Picture "999"
@ r + 3, c +  2 Say "        Highlight:" Get nHColor     Picture "999"
@ r + 4, c +  2 Say "         Col Lock:" Get nColLock    Picture "99"
@ r + 5, c +  2 Say "         Row Lock:" Get nRowLock    Picture "99"
@ r + 6, c +  2 Say "      scroll mode?" Get lScroll     Picture "Y"
@ r + 7, c +  2 Say "scroll background:" Get cScrollBack

@ r + 2, c + 42 Say " column increment:" Get nColSkip    Picture "999"
@ r + 3, c + 42 Say "    max line size:" Get nRMargin    Picture "999"
@ r + 4, c + 42 Say "      browse mode?" Get lBrowse     Picture "Y"
@ r + 6, c + 42 Say "      Buffer Size:" Get nBuffSize   Picture "9999"
@ r + 7, c + 42 Say "scroll character :" Get cScrollChar

@ r + 9, c +  2 Say "y1:"                Get y1          Picture "99"
@ r + 9, c + 12 Say "x1:"                Get x1          Picture "999"
@ r + 9, c + 22 Say "y2:"                Get y2          Picture "99"
@ r + 9, c + 32 Say "x2:"                Get x2          Picture "999"

do while .t.
    Read

    RestScreen(r, 0, MaxRow(), MaxCol(), Scrn)

    if (( LastKey() != 27 ) .and. ( !Empty(cInFile) ))
        if File(cInFile)
            r := DF_Setup(cInFile, y1 + 1, x1 + 1, y2 - 1, x2 - 1,;
                        nNColor, nHColor, lBrowse,;
                        nColSkip, nRMargin, nBuffSize,;
                        nColLock, nRowLock, { "W/B", "W/R", },;
                        lScroll,  cScrollBack, cScrollChar)

            if ( r > 0 )
                AAdd(WinList, { r, y1, x1, y2, x2 })

                CurrWin := Len(WinList)

                @ y1, x1 TO y2, x2

                DF_Draw(WinList[CurrWin, HANDLE])

                Exit
            else
                DispMsg("Error " + AllTrim(Str(FError())) + " opening file.")
            endif
        else
            DispMsg("File not found.")
        endif
    else
        Exit
    endif
enddo

return (NIL)





static function DispMsg(cText)

local cScrn := SaveScreen(MaxRow(), 0, MaxRow(), MaxCol())

@ MaxRow(), 0 Clear

@ MaxRow(), 0 Say cText

Tone()

Inkey(0)

RestScreen(MaxRow(), 0, MaxRow(), MaxCol(), cScrn)

return (NIL)
