/***
*  ARRAY.PRG
*  Clipper 5.01
*  Creates an ACHOICE() menu
*
*  Copyright (c) 1991 Nantucket Corp.  All rights reserved.
*       Written by Roy Corneloues on 06/07/91 at 04:45:06
*
*  Notes: This module is contained inside MENU.LIB
*
*/

#define MENU_TITLE     1
#define MENU_PROMPTS   2

FUNCTION ArrayMenu( aMenu )
	LOCAL nWidth := LEN(aMenu[MENU_TITLE])
   LOCAL nHeight
   LOCAL I

	FOR I := 1 TO LEN(aMenu[MENU_PROMPTS])
		aMenu[MENU_PROMPTS][I] := " " + aMenu[MENU_PROMPTS][I] + " "
		IF LEN(aMenu[MENU_PROMPTS][I]) > nWidth
			nWidth := LEN(aMenu[MENU_PROMPTS][I])
		ENDIF
	NEXT // I

	nHeight := IF(LEN(aMenu[MENU_PROMPTS]) > MAXROW() - 4, MAXROW() - 1,;
      LEN(aMenu[MENU_PROMPTS]) + 4)

	DISPBOX(1, 0, 3, nWidth + 3, "Ŀ    ")
	DISPBOX(3, 0, nHeight, nWidth + 3, "Ĵ ")
	@ 2, 1 SAY PADC( aMenu[MENU_TITLE], nWidth + 2 )

	RETURN (ACHOICE(4, 1, nHeight, nWidth + 2, aMenu[MENU_PROMPTS]))

// End of Array.prg
