/***
*  MENUTO.PRG
*  Clipper 5.01
*  Creates a MENU TO style menu
*
*  Copyright (c) 1991 Nantucket Corp.  All rights reserved.
*       Written by Roy Corneloues on 06/07/91 at 04:47:14
*
*  Notes: This module is contained inside MENU.LIB.
*         The options will automatically wrap round if there are
*         too many to fit on one line
*/

#define MENU_TITLE     1
#define MENU_PROMPTS   2


FUNCTION ToMenu( aMenu )
	LOCAL nLeftMargin
	LOCAL nRow := 1
	LOCAL nCol
	LOCAL I
	LOCAL nChoice

	@ nRow, 0 SAY aMenu[MENU_TITLE] + ":"

	STORE LEN(aMenu[MENU_TITLE]) + 2 TO nLeftMargin, nCol

	FOR I := 1 TO LEN(aMenu[MENU_PROMPTS])
		IF nCol + LEN(aMenu[MENU_PROMPTS][I]) + 3 > MAXCOL()
			nCol := nLeftMargin
			nRow++
		ENDIF
		@ nRow, nCol PROMPT " " + aMenu[MENU_PROMPTS][I] + " "
		nCol += LEN(aMenu[MENU_PROMPTS][I]) + 3
	NEXT // I
	MENU TO nChoice

	RETURN (nChoice)

// End of MenuTo.prg
