/***
*  DBASE.PRG
*  Clipper 5.01
*  Creates a DBase style menu
*
*  Copyright (c) 1991 Nantucket Corp.  All rights reserved.
*       Written by Roy Corneloues on 06/07/91 at 04:46:16
*
*  Notes: This module is contained inside MENU.LIB.
*         If lMode is false (.F.), the menu will use a number
*         selection technique.  Supplying true (.T.) will use an
*         alphabetic selection technique.  The default is false (.F.)
*/

#define MENU_TITLE     1
#define MENU_PROMPTS   2

FUNCTION DBaseMenu( aMenu, lMode )
	LOCAL GetList := {}
	LOCAL xChoice
	LOCAL I

        IF lMode == NIL
           lMode := .F.
        ENDIF

	xChoice := IF(lMode, SPACE(3), 0)

	@ 1, 0 SAY aMenu[MENU_TITLE]

	FOR I := 1 TO LEN(aMenu[MENU_PROMPTS])
		@ I + 2, 0 SAY If( lMode, Chr(64 + I),Str(I, 3) ) + ". " +; 
         aMenu[MENU_PROMPTS][I]
	NEXT // I

	IF lMode
		@ I + 3, 0 SAY "Enter Choice: ";
         GET xChoice;
			PICTURE "!AAA";
         VALID xChoice >= Chr(65) .And. xChoice <= Chr( 64+;
         LEN(aMenu[MENU_PROMPTS]) )
	ELSE
		@ I + 3, 0 SAY "Enter Choice: ";
			GET xChoice;
			RANGE 1, LEN( aMenu[MENU_PROMPTS] );
			PICTURE "999"
	ENDIF
	READ

	RETURN (IF(lMode, ASC(xChoice) - 64, xChoice))

// End of Dbase.prg
